/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.dcm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import rad.dicom.dcm.DcmDDE;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;

public class DcmOutputStream
extends FilterOutputStream {
    private OutputStream outStream;
    private DcmDataObject copyDDO;
    private byte[] metaFilePreambel = new byte[128];
    private int extEncoding;
    private int extStructure;
    private int extStorage;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveDDO(DcmDataObject ddo, File f) throws Exception {
        FileOutputStream fos = null;
        DcmOutputStream dos = null;
        try {
            fos = new FileOutputStream(f);
            dos = new DcmOutputStream(fos);
            dos.writeDDO(ddo);
            Object var6_4 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fos != null) {
                fos.close();
            }
            dos = null;
            throw throwable;
        }
        fos.close();
    }

    public DcmOutputStream(OutputStream out) {
        super(out);
        this.outStream = out;
    }

    /*
     * WARNING - void declaration
     */
    public void writeDDO(DcmDataObject ddo) throws Exception {
        DcmValue dcmval;
        boolean padding = false;
        this.copyDDO = ddo.getCopyOfMe();
        this.extEncoding = this.copyDDO.getEncoding();
        this.extStructure = this.copyDDO.getStructure();
        this.extStorage = this.copyDDO.getStorage();
        if (this.extStorage == 128) {
            this.writeFileMetaInfo();
        }
        while ((dcmval = this.copyDDO.pop()) != null) {
            byte[] buf;
            void var2_3;
            int vr = var2_3.getVR();
            int length = var2_3.getData().length;
            if (length % 2 != 0) {
                padding = true;
                ++length;
            } else {
                padding = false;
            }
            this.writeUInt16(var2_3.getGroup());
            this.writeUInt16(var2_3.getElement());
            if (this.extStructure == 8) {
                this.writeUInt32(length);
            } else {
                String vrn = DcmDDE.vrCodeToString(vr);
                this.outStream.write(vrn.getBytes());
                if (vr == 13 | vr == 14 | vr == 18 | vr == 24) {
                    this.writeUInt16(0);
                    this.writeUInt32(length);
                } else {
                    this.writeUInt16(length);
                }
            }
            if (this.extEncoding == 1) {
                buf = var2_3.getData();
            } else {
                buf = (byte[])var2_3.getData().clone();
                DcmValue.swapBuf(buf, vr);
            }
            this.outStream.write(buf);
            if (!padding) continue;
            buf = new byte[]{vr == 22 | vr == 13 ? (byte)0 : 32};
            this.outStream.write(buf);
        }
    }

    private void writeUInt16(int i) throws Exception {
        byte[] dat = new byte[2];
        if (this.extEncoding == 1) {
            dat[0] = (byte)i;
            dat[1] = (byte)(i >>> 8);
        } else {
            dat[1] = (byte)i;
            dat[0] = (byte)(i >>> 8);
        }
        this.outStream.write(dat);
    }

    private void writeUInt32(long i) throws Exception {
        byte[] dat = new byte[4];
        if (this.extEncoding == 1) {
            dat[0] = (byte)i;
            dat[1] = (byte)(i >>> 8);
            dat[2] = (byte)(i >>> 16);
            dat[3] = (byte)(i >>> 24);
        } else {
            dat[3] = (byte)i;
            dat[2] = (byte)(i >>> 8);
            dat[1] = (byte)(i >>> 16);
            dat[0] = (byte)(i >>> 24);
        }
        this.outStream.write(dat);
    }

    public void setPreambel(byte[] pre) {
        int l = 128;
        if (pre.length < 128) {
            l = pre.length;
        }
        int i = 0;
        while (i < l) {
            this.metaFilePreambel[i] = pre[i];
            ++i;
        }
    }

    private void writeFileMetaInfo() throws Exception {
        this.outStream.write(this.metaFilePreambel);
        byte[] buf = new byte[]{68, 73, 67, 77};
        this.outStream.write(buf);
        DcmDataObject metaDDO = new DcmDataObject(1, 16, 64);
        metaDDO.setUS(2, 1, 256);
        metaDDO.setString(2, 2, this.copyDDO.getString(7));
        metaDDO.setString(2, 3, this.copyDDO.getString(8));
        if (this.copyDDO.getEncoding() == 1) {
            if (this.copyDDO.getStructure() == 8) {
                metaDDO.setString(2, 16, "1.2.840.10008.1.2");
            } else {
                metaDDO.setString(2, 16, "1.2.840.10008.1.2.1");
            }
        } else {
            if (this.copyDDO.getStructure() == 8) {
                throw new Exception("Big Endian/Implicite VR is not a DICOM Transfersyntax");
            }
            metaDDO.setString(2, 16, "1.2.840.10008.1.2.2");
        }
        metaDDO.setString(2, 18, "1.2.3.4711.4");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DcmOutputStream dos = new DcmOutputStream(baos);
        dos.writeDDO(metaDDO);
        dos.flush();
        buf = baos.toByteArray();
        baos.close();
        dos.close();
        this.outStream.write(buf);
    }
}

