/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.dcm;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import rad.dicom.dcm.DcmDDE;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;

public class DcmInputStream
extends FilterInputStream {
    private BufferedInputStream binStream = null;
    private boolean isEOF = false;
    private boolean isMaxGroupNumber = false;
    private int maxGroupNumber = Integer.MAX_VALUE;
    private int extEncoding;
    private int extStructure;
    private int extStorage;
    private int testEncoding;
    private int testStructure;
    private int testStorage;
    private DcmDataObject metaInfoDDO = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isDicomStream(File f) {
        BufferedInputStream bis;
        boolean valid;
        block10: {
            valid = false;
            FileInputStream fis = null;
            bis = null;
            fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            valid = DcmInputStream.isDicomStream(bis);
            Object var7_4 = null;
            if (fis == null) break block10;
            try {
                fis.close();
                break block10;
            }
            catch (Exception e2) {
                // empty catch block
            }
            {
                break block10;
                catch (Exception e) {
                    boolean bl = false;
                    Object var7_5 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    bis = null;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                bis = null;
                throw throwable;
            }
        }
        bis = null;
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDicomStream(InputStream is) {
        boolean valid = false;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(is);
            valid = DcmInputStream.isDicomStream(bis);
            Object var4_3 = null;
            bis = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            bis = null;
            throw throwable;
        }
        return valid;
    }

    public static boolean isDicomStream(BufferedInputStream bis) {
        bis.mark(132);
        byte[] buf = new byte[132];
        try {
            bis.read(buf, 0, buf.length);
            bis.reset();
        }
        catch (Exception ex) {
            return false;
        }
        if (buf[128] == 68 & buf[129] == 73 & buf[130] == 67 & buf[131] == 77) {
            return true;
        }
        if (buf[0] == 8 & buf[1] == 0) {
            return true;
        }
        return buf[0] == 0 & buf[1] == 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DcmDataObject loadDDO(File f) throws Exception {
        BufferedInputStream bis;
        DcmDataObject ddo;
        block5: {
            ddo = null;
            FileInputStream fis = null;
            bis = null;
            DcmInputStream dis = null;
            try {
                fis = new FileInputStream(f);
                bis = new BufferedInputStream(fis);
                dis = new DcmInputStream(bis);
                ddo = dis.readDDO();
                Object var7_5 = null;
                if (fis == null) break block5;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (fis != null) {
                    fis.close();
                }
                bis = null;
                dis = null;
                throw throwable;
            }
            fis.close();
        }
        bis = null;
        return ddo;
    }

    public static DcmDataObject loadDDO(URL u) throws Exception {
        URLConnection uc = u.openConnection();
        InputStream is = uc.getInputStream();
        DcmDataObject ddo = DcmInputStream.loadDDO(is);
        is.close();
        return ddo;
    }

    public static DcmDataObject loadDDO(InputStream is) throws Exception {
        DcmDataObject ddo = null;
        BufferedInputStream bis = null;
        DcmInputStream dis = null;
        try {
            bis = new BufferedInputStream(is);
            dis = new DcmInputStream(bis);
            ddo = dis.readDDO();
            Object var6_4 = null;
            bis = null;
            dis = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            bis = null;
            dis = null;
            throw throwable;
        }
        return ddo;
    }

    public DcmInputStream(BufferedInputStream bis) {
        super(bis);
        this.binStream = bis;
    }

    public DcmDataObject readDDO() throws Exception {
        return this.readDDO(4, 32, 256);
    }

    public DcmDataObject getMetaInfo() {
        return this.metaInfoDDO;
    }

    public DcmDataObject readDDO(int encoding, int structure, int storage) throws Exception {
        this.extEncoding = encoding;
        this.extStructure = structure;
        this.extStorage = storage;
        if (this.extEncoding == 4 || this.extStructure == 32 || this.extStorage == 256) {
            this.testTransferSyntax();
        }
        if (this.extEncoding == 4) {
            this.extEncoding = this.testEncoding;
        }
        if (this.extStructure == 32) {
            this.extStructure = this.testStructure;
        }
        if (this.extStorage == 256) {
            this.extStorage = this.testStorage;
        }
        DcmDataObject ddo = new DcmDataObject(this.extEncoding, this.extStructure, this.extStorage);
        while (true) {
            byte[] buf;
            long length;
            int vr;
            int group = this.readUInt16();
            if (this.isMaxGroupNumber && group > this.maxGroupNumber || this.isEOF) break;
            int element = this.readUInt16();
            if (this.extStructure == 8) {
                vr = 0;
                length = this.readUInt32();
            } else {
                buf = new byte[2];
                this.readData(buf);
                vr = DcmDDE.vrStringToCode(new String(buf));
                if (vr == 13 || vr == 14 || vr == 18 || vr == 24) {
                    byte[] dat = new byte[2];
                    this.readData(dat);
                    length = this.readUInt32();
                } else {
                    length = this.readUInt16();
                }
            }
            buf = new byte[(int)length];
            this.readData(buf);
            if (this.extEncoding == 2) {
                DcmValue.swapBuf(buf, vr);
            }
            DcmValue dcmvalue = new DcmValue(group, element, buf);
            dcmvalue.setVR(vr);
            ddo.push(dcmvalue);
        }
        return ddo;
    }

    public void setMaxGroupNumber(int mgn) {
        this.isMaxGroupNumber = true;
        this.maxGroupNumber = mgn;
    }

    public void clearMaxGroupNumber() {
        this.isMaxGroupNumber = false;
    }

    private void readData(byte[] dat) throws Exception {
        int idx = 0;
        int l = 0;
        int nBytes = dat.length;
        while (nBytes > 0) {
            l = this.binStream.read(dat, idx, nBytes);
            if (l == -1) {
                this.isEOF = true;
                break;
            }
            idx += l;
            nBytes -= l;
        }
    }

    private int readUInt16() throws Exception {
        byte[] dat = new byte[2];
        this.readData(dat);
        if (this.extEncoding == 1) {
            return dat[0] & 0xFF | (dat[1] & 0xFF) << 8;
        }
        return dat[1] & 0xFF | (dat[0] & 0xFF) << 8;
    }

    private long readUInt32() throws Exception {
        byte[] dat = new byte[4];
        this.readData(dat);
        if (this.extEncoding == 1) {
            return (long)dat[0] & 0xFFL | ((long)dat[1] & 0xFFL) << 8 | ((long)dat[2] & 0xFFL) << 16 | ((long)dat[3] & 0xFFL) << 24;
        }
        return (long)dat[3] & 0xFFL | ((long)dat[2] & 0xFFL) << 8 | ((long)dat[1] & 0xFFL) << 16 | ((long)dat[0] & 0xFFL) << 24;
    }

    public boolean isDicomStream() {
        return DcmInputStream.isDicomStream(this.binStream);
    }

    private void testTransferSyntax() throws Exception {
        this.binStream.mark(512);
        byte[] buf = new byte[128];
        this.readData(buf);
        buf = new byte[4];
        this.readData(buf);
        this.binStream.reset();
        if (buf[0] == 68 & buf[1] == 73 & buf[2] == 67 & buf[3] == 77) {
            this.testMetaStorage();
            this.testStorage = 128;
            return;
        }
        this.testStorage = 64;
        this.testEncoding = 1;
        this.testStructure = 8;
        this.binStream.mark(512);
        buf = new byte[16];
        this.readData(buf);
        this.binStream.reset();
        if (buf[0] == 0 & buf[1] != 0) {
            this.testEncoding = 2;
        }
        if (buf[6] == 0 & buf[7] == 0 && buf[4] == 79 & buf[5] == 66 | buf[4] == 79 & buf[5] == 87 | buf[4] == 83 & buf[5] == 81 | buf[4] == 85 & buf[5] == 78) {
            this.testStructure = 16;
            return;
        }
        if (buf[4] >= 65 & buf[5] >= 65) {
            this.testStructure = 16;
        }
    }

    private void testMetaStorage() throws Exception {
        this.binStream.mark(2048);
        byte[] buf = new byte[140];
        this.readData(buf);
        buf = new byte[4];
        this.readData(buf);
        this.binStream.reset();
        long lmib = (long)buf[0] & 0xFFL | ((long)buf[1] & 0xFFL) << 8 | ((long)buf[2] & 0xFFL) << 16 | ((long)buf[3] & 0xFFL) << 24;
        buf = new byte[132];
        this.readData(buf);
        buf = new byte[(int)(lmib += 12L)];
        this.readData(buf);
        this.binStream.reset();
        DcmInputStream dis = new DcmInputStream(new BufferedInputStream(new ByteArrayInputStream(buf)));
        this.metaInfoDDO = dis.readDDO(1, 16, 64);
        String transferUID = this.metaInfoDDO.getString(1394);
        if (transferUID.compareTo("1.2.840.10008.1.2") == 0) {
            this.testEncoding = 1;
            this.testStructure = 8;
        }
        if (transferUID.compareTo("1.2.840.10008.1.2.1") == 0) {
            this.testEncoding = 1;
            this.testStructure = 16;
        }
        if (transferUID.compareTo("1.2.840.10008.1.2.2") == 0) {
            this.testEncoding = 2;
            this.testStructure = 16;
        }
        buf = new byte[132 + (int)lmib];
        this.readData(buf);
    }
}

