/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.lang.reflect.Method;
import java.util.ResourceBundle;
import jigl.image.ComplexImage;
import jigl.image.Image;
import jigl.image.RealGrayImage;
import jigl.image.utils.FFT;
import virtual.tools.ImagePlus;

public class FFTTools {
    public static ComplexImage forwardFFT(Image img) {
        ComplexImage fourImage = null;
        FFT fft = new FFT();
        try {
            Method m = fft.getClass().getDeclaredMethod("inverse", Image.class);
            m = fft.getClass().getDeclaredMethod("forward", Image.class);
            fourImage = (ComplexImage)m.invoke(null, img);
            m = null;
        }
        catch (Exception e1) {
            try {
                Method m = fft.getClass().getDeclaredMethod("forward", Image.class);
                fourImage = (ComplexImage)m.invoke((Object)fft, img);
                m = null;
            }
            catch (Exception e2) {
                System.out.println(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("ffttools.exception.notfound.forward"));
            }
        }
        fft = null;
        return fourImage;
    }

    public static ComplexImage reverseFFT(Image img) {
        ComplexImage compImage = null;
        FFT fft = new FFT();
        try {
            Method m = fft.getClass().getDeclaredMethod("inverse", Image.class);
            compImage = (ComplexImage)m.invoke(null, img);
            m = null;
        }
        catch (Exception e1) {
            try {
                Method m = fft.getClass().getDeclaredMethod("reverse", Image.class);
                compImage = (ComplexImage)m.invoke((Object)fft, img);
                m = null;
            }
            catch (Exception e2) {
                System.out.println(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("ffttools.exception.notfound.inverse"));
            }
        }
        fft = null;
        return compImage;
    }

    private static int[] getShiftedFFTImageSource(float[][] imageReal, float[][] imageImag) {
        float[][] shiftedImgRe = FFTTools.shift(imageReal, 128, 128);
        float[][] shiftedImgIm = FFTTools.shift(imageImag, 128, 128);
        float[][] magImage = FFTTools.magnitude(shiftedImgRe, shiftedImgIm);
        float[][] magscaleImage = FFTTools.scaleMagnitude(magImage);
        int[][] windowedImg = FFTTools.autoWindow(magscaleImage);
        int[] magnitudeImage = FFTTools.convertIntArrayToImage(windowedImg);
        return magnitudeImage;
    }

    public static int[] getShiftedFFTImageSource(ImagePlus ip) {
        float[][] imageReal = ip.getFFTImageReal();
        float[][] imageImag = ip.getFFTImageImag();
        return FFTTools.getShiftedFFTImageSource(imageReal, imageImag);
    }

    public static float[][] getReshiftedIFFT(float[][] imgReal, float[][] imgImag) {
        float[][] re = FFTTools.shift(imgReal, 128, 128);
        float[][] im = FFTTools.shift(imgImag, 128, 128);
        int size = imgReal.length;
        ComplexImage comImg = new ComplexImage(size, size);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                comImg.setReal(x, y, re[x][y]);
                comImg.setImag(x, y, im[x][y]);
            }
        }
        ComplexImage origImage = null;
        origImage = FFTTools.reverseFFT(comImg);
        float[][] origImageReal = new float[size][size];
        float[][] origImageImag = new float[size][size];
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                origImageReal[x][y] = origImage.getReal(x, y);
                origImageImag[x][y] = origImage.getImag(x, y);
            }
        }
        float[][] magImage = FFTTools.magnitude(origImageReal, origImageImag);
        return magImage;
    }

    public static int[] getReshiftedIFFTImageSource(float[][] imgReal, float[][] imgImag) {
        float[][] reshiftedIFFT = FFTTools.getReshiftedIFFT(imgReal, imgImag);
        int[][] windowedImage = FFTTools.autoWindow(reshiftedIFFT);
        int[] finalImage = FFTTools.convertIntArrayToImage(windowedImage);
        return finalImage;
    }

    public static int[] convertTo8BitImageSrc(float[][] origImg) {
        int[][] windowedImage = FFTTools.autoWindow(origImg);
        int[] finalImage = FFTTools.convertIntArrayToImage(windowedImage);
        return finalImage;
    }

    public static float[][] shift(float[][] img, int offx, int offy) {
        int size = img.length;
        float[][] shiftedImage = new float[size][size];
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                shiftedImage[(x + offx) % size][(y + offy) % size] = img[x][y];
            }
        }
        return shiftedImage;
    }

    public static ComplexImage shift(ComplexImage img, int offx, int offy) {
        int size = 256;
        ComplexImage shiftedImage = new ComplexImage(256, 256);
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                shiftedImage.set((x + offx) % size, (y + offy) % size, img.getReal(x, y), img.getImag(x, y));
            }
        }
        return shiftedImage;
    }

    public static float[][] magnitude(float[][] re, float[][] im) {
        int size = re.length;
        float[][] result = new float[size][size];
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                result[x][y] = (float)Math.sqrt(re[x][y] * re[x][y] + im[x][y] * im[x][y]);
            }
        }
        return result;
    }

    public static float[][] calcPhase(float[][] re, float[][] im) {
        float[][] result = new float[256][256];
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                result[x][y] = (float)Math.atan(im[x][y] / re[x][y]);
            }
        }
        return result;
    }

    public static float[][] scaleMagnitude(float[][] img) {
        int size = img.length;
        float[][] result = new float[size][size];
        float max = 0.0f;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                result[x][y] = (float)(30.0 * Math.log(1.0f + img[x][y]) / Math.log(1.1));
                if (!(result[x][y] > max)) continue;
                max = result[x][y];
            }
        }
        return result;
    }

    public static int[][] autoWindow(float[][] img) {
        int y;
        int x;
        int size = img.length;
        long min = 999999999L;
        long max = 0L;
        int[][] windowedImage = new int[size][size];
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                if ((long)img[x][y] > max) {
                    max = (long)img[x][y];
                }
                if ((long)img[x][y] >= min) continue;
                min = (long)img[x][y];
            }
        }
        double step = (double)(max - min) / 256.0;
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                int val;
                windowedImage[x][y] = val = (int)((double)(img[x][y] - (float)min) / step);
            }
        }
        return windowedImage;
    }

    public static int[] convertIntArrayToImage(int[][] source) {
        int size = source.length;
        int[] intArray = new int[size * size];
        for (int i = 0; i < size * size; ++i) {
            int hlp = source[i / size][i % size];
            intArray[i] = 0xFF000000 | (hlp &= 0xFF) << 16 | hlp << 8 | hlp;
        }
        return intArray;
    }

    public static float[][] getReal(ComplexImage ci) {
        int X = 256;
        int Y = 256;
        float[][] re = new float[256][256];
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                re[x][y] = ci.getReal(x, y);
            }
        }
        return re;
    }

    public static float[][] getImag(ComplexImage ci) {
        int X = 256;
        int Y = 256;
        float[][] im = new float[256][256];
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                im[x][y] = ci.getImag(x, y);
            }
        }
        return im;
    }

    public static RealGrayImage makeRealGrayImage(int[][] img) {
        RealGrayImage rg = new RealGrayImage(img.length, img[0].length);
        for (int x = 0; x < img.length; ++x) {
            for (int y = 0; y < img[0].length; ++y) {
                rg.set(x, y, img[x][y]);
            }
        }
        return rg;
    }

    public static RealGrayImage makeRealGrayImage(float[][] img) {
        RealGrayImage rg = new RealGrayImage(img.length, img[0].length);
        for (int x = 0; x < img.length; ++x) {
            for (int y = 0; y < img[0].length; ++y) {
                rg.set(x, y, img[x][y]);
            }
        }
        return rg;
    }

    public static RealGrayImage makeRealGrayImage(int dimX, int dimY, short[] img) {
        RealGrayImage rg = new RealGrayImage(dimX, dimY);
        for (int x = 0; x < dimX; ++x) {
            for (int y = 0; y < dimY; ++y) {
                rg.set(x, y, img[y * dimX + x]);
            }
        }
        return rg;
    }
}

