/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.StringTokenizer;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;
import rad.dicom.ima.GeneralImageIOD;

public class DcmImage {
    public static final String SOP_CT_IMAGE_STORAGE = "1.2.840.10008.5.1.4.1.1.2";
    public static final String SOP_MR_IMAGE_STORAGE = "1.2.840.10008.5.1.4.1.1.4";
    public static final int PI_UNSUPPORTED = 0;
    public static final int PI_MONOCHROME1 = 1;
    public static final int PI_MONOCHROME2 = 2;
    public static final int PI_PALETTE_COLOR = 3;
    public static final int IOD_UNKNOWN_IMAGE = 0;
    public static final int IOD_CT_IMAGE = 1;
    public static final int IOD_MR_IMAGE = 2;
    public static final int CW_FILE = 0;
    public static final int CW_AUTO = 1;
    public MemoryImageSource imgSource = null;
    public short[] pixel16 = null;
    public ColorModel cModel;
    public int imageIOD = 0;
    public int samplesPPixel;
    public int photometricInterpretation = 0;
    public int rows;
    public int columns;
    public int bitsAllocated;
    public int bitsStored;
    public int highBit;
    public boolean unsignedPixel;
    public boolean bytePixel;
    public boolean isCenterWidth = false;
    public int windowCenter;
    public int windowWidth;
    public String classUID;
    public String instanceUID;
    public int rescaleIntercept;
    public int rescaleSlope;
    public String scanningSequence;
    public String scanningVariant;
    public double pixelSpacingRow;
    public double pixelSpacingColumn;
    public double sliceThickness;
    public double sliceLocation;
    private int maxPixelValue16;
    private int minPixelValue;
    private int maxPixelValue;
    private int autoCenter;
    private int autoWidth;
    private int theCenter;
    private int theWidth;
    int numupdate;

    public DcmImage(DcmDataObject ddo) throws Exception {
        if (ddo == null) {
            throw new Exception("No DcmDataObject specified");
        }
        this.extractImageValues(ddo);
        if (this.samplesPPixel != 1) {
            throw new Exception("Only one image plane supported");
        }
        if (this.bitsAllocated != 8 & this.bitsAllocated != 16) {
            throw new Exception("Only 8 or 16 bit/pixel supported");
        }
        if (this.photometricInterpretation == 0) {
            throw new Exception("Photometric Interpretation not supported");
        }
        this.maxPixelValue16 = (int)Math.pow(2.0, this.bitsStored) - 1;
        if (this.unsignedPixel) {
            this.minPixelValue = 0;
            this.maxPixelValue = (int)Math.pow(2.0, this.bitsStored) - 1;
        } else {
            this.minPixelValue = -((int)Math.pow(2.0, this.bitsStored)) / 2;
            this.maxPixelValue = (int)Math.pow(2.0, this.bitsStored) / 2 - 1;
        }
        this.extractPixels(ddo);
        switch (this.photometricInterpretation) {
            case 1: {
                this.setMonochrome1ColorModel();
                break;
            }
            case 2: {
                this.setMonochrome2ColorModel();
                break;
            }
            case 3: {
                this.extractLUT(ddo);
            }
        }
        this.updateAWTImage();
    }

    public DcmImage(GeneralImageIOD gi) throws Exception {
        if (gi == null) {
            throw new Exception("No DcmDataObject specified");
        }
        this.extractImageValues(gi.headerDDO);
        if (this.samplesPPixel != 1) {
            throw new Exception("Only one image plane supported");
        }
        if (this.bitsAllocated != 8 & this.bitsAllocated != 16) {
            throw new Exception("Only 8 or 16 bit/pixel supported");
        }
        if (this.photometricInterpretation == 0) {
            throw new Exception("Photometric Interpretation not supported");
        }
        this.maxPixelValue16 = (int)Math.pow(2.0, this.bitsStored) - 1;
        if (this.unsignedPixel) {
            this.minPixelValue = 0;
            this.maxPixelValue = (int)Math.pow(2.0, this.bitsStored) - 1;
        } else {
            this.minPixelValue = -((int)Math.pow(2.0, this.bitsStored)) / 2;
            this.maxPixelValue = (int)Math.pow(2.0, this.bitsStored) / 2 - 1;
        }
        this.pixel16 = new short[gi.pixel16.length];
        System.arraycopy(gi.pixel16, 0, this.pixel16, 0, gi.pixel16.length);
        switch (this.photometricInterpretation) {
            case 1: {
                this.setMonochrome1ColorModel();
                break;
            }
            case 2: {
                this.setMonochrome2ColorModel();
                break;
            }
            case 3: {
                this.extractLUT(gi.headerDDO);
            }
        }
        this.updateAWTImage();
    }

    public void updateAWTImage() {
        if (this.pixel16 != null) {
            this.calcAutomaticCW();
            if (!this.isCenterWidth) {
                this.windowCenter = this.autoCenter;
                this.windowWidth = this.autoWidth;
            }
            this.theCenter = this.windowCenter;
            this.theWidth = this.windowWidth;
            this.updateImageSource();
        }
    }

    public void setCW(int type) {
        switch (type) {
            case 0: {
                this.theCenter = this.windowCenter;
                this.theWidth = this.windowWidth;
                break;
            }
            case 1: {
                this.theCenter = this.autoCenter;
                this.theWidth = this.autoWidth;
            }
        }
        this.updateImageSource();
    }

    public void setCW(int wCenter, int wWidth) {
        this.theCenter = wCenter;
        this.theWidth = wWidth;
        this.updateImageSource();
    }

    public void setCenter(int c) {
        this.theCenter = c;
        this.updateImageSource();
    }

    public void setWindow(int w) {
        this.theWidth = w;
        this.updateImageSource();
    }

    public int getCenter() {
        return this.theCenter;
    }

    public int getWidth() {
        return this.theWidth;
    }

    private void extractImageValues(DcmDataObject ddo) throws Exception {
        block13: {
            try {
                this.samplesPPixel = ddo.getUS(477);
                String pi = ddo.getString(478);
                this.rows = ddo.getUS(482);
                this.columns = ddo.getUS(483);
                this.bitsAllocated = ddo.getUS(491);
                this.bytePixel = this.bitsAllocated == 8;
                this.bitsStored = ddo.getUS(492);
                this.highBit = ddo.getUS(493);
                this.unsignedPixel = ddo.getUS(494) == 0;
                String[] sa = DcmValue.str2StringArray(ddo.getString(486), "\\");
                this.pixelSpacingRow = 0.0;
                this.pixelSpacingColumn = 0.0;
                if (sa.length > 0) {
                    this.pixelSpacingRow = DcmValue.str2Double(sa[0], 0.0);
                }
                if (sa.length > 1) {
                    this.pixelSpacingColumn = DcmValue.str2Double(sa[1], 0.0);
                }
                this.sliceThickness = DcmValue.str2Double(ddo.getString(162), 1.0);
                this.sliceLocation = DcmValue.str2Double(ddo.getString(467), 0.0);
                if (pi.compareTo("MONOCHROME1") == 0) {
                    this.photometricInterpretation = 1;
                }
                if (pi.compareTo("MONOCHROME2") == 0) {
                    this.photometricInterpretation = 2;
                }
                if (pi.compareTo("PALETTE COLOR") == 0) {
                    this.photometricInterpretation = 3;
                }
                this.classUID = ddo.getString(7);
                this.instanceUID = ddo.getString(8);
                if (this.classUID.compareTo(SOP_CT_IMAGE_STORAGE) == 0) {
                    this.imageIOD = 1;
                    this.rescaleIntercept = (int)DcmValue.str2Long(ddo.getString(508), 0L);
                    this.rescaleSlope = (int)DcmValue.str2Long(ddo.getString(509), 1L);
                }
                if (this.classUID.compareTo(SOP_MR_IMAGE_STORAGE) == 0) {
                    this.imageIOD = 2;
                    this.scanningSequence = ddo.getString(140);
                    this.scanningVariant = ddo.getString(141);
                }
            }
            catch (Exception e) {
                throw new Exception("Can't find/extract requiered data element");
            }
            try {
                String w = ddo.getString(506);
                if (w.length() == 0) break block13;
                try {
                    StringTokenizer st = new StringTokenizer(w, "\\");
                    String s = st.nextToken().trim();
                    this.windowCenter = Integer.parseInt(s);
                    w = ddo.getString(507);
                    st = new StringTokenizer(w, "\\");
                    s = st.nextToken().trim();
                    this.windowWidth = Integer.parseInt(s);
                    this.isCenterWidth = true;
                }
                catch (Exception e) {
                    throw new Exception("Can't find/extract Center/Width data elements");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void extractLUT(DcmDataObject ddo) throws Exception {
        DcmValue dcvDataBlue;
        DcmValue dcvDataGreen;
        DcmValue dcvDescBlue;
        DcmValue dcvDescGreen;
        DcmValue dcvDescRed = ddo.getDcmValue(513);
        if (dcvDescRed == null | (dcvDescGreen = ddo.getDcmValue(514)) == null | (dcvDescBlue = ddo.getDcmValue(515)) == null) {
            throw new Exception("GeneralImageIOD.extractLUT: Can't find LUT descriptors");
        }
        DcmValue dcvDataRed = ddo.getDcmValue(517);
        if (dcvDataRed == null | (dcvDataGreen = ddo.getDcmValue(518)) == null | (dcvDataBlue = ddo.getDcmValue(519)) == null) {
            throw new Exception("GeneralImageIOD.extractLUT: Can't find LUT data");
        }
        byte[] rTab = new byte[this.maxPixelValue + 1];
        byte[] gTab = new byte[this.maxPixelValue + 1];
        byte[] bTab = new byte[this.maxPixelValue + 1];
        this.setColorComponent(dcvDescRed, dcvDataRed, rTab);
        this.setColorComponent(dcvDescGreen, dcvDataGreen, gTab);
        this.setColorComponent(dcvDescBlue, dcvDataBlue, bTab);
        this.cModel = new IndexColorModel(this.bitsStored, rTab.length, rTab, gTab, bTab);
    }

    private void setColorComponent(DcmValue dcvDesc, DcmValue dcvData, byte[] cTab) throws Exception {
        int numEntries = DcmValue.bufToSS(dcvDesc.getData(), 0);
        short firstMappedPixel = DcmValue.bufToSS(dcvDesc.getData(), 2);
        short numBits = DcmValue.bufToSS(dcvDesc.getData(), 4);
        if (firstMappedPixel < 0) {
            throw new Exception("GeneralImageIOD.setColorComponent: Only unsigned integer pixel values supported");
        }
        if (numBits > 8) {
            throw new Exception("GeneralImageIOD.setColorComponent: Max. 8 bit/color component supported");
        }
        int lutMask = (int)Math.pow(2.0, numBits) - 1;
        int lastMappedPixel = firstMappedPixel + numEntries - 1;
        int idxLast = cTab.length - 1;
        if (lastMappedPixel > idxLast) {
            lastMappedPixel = idxLast;
            numEntries = lastMappedPixel - firstMappedPixel + 1;
        }
        for (int i = 0; i <= idxLast; ++i) {
            cTab[i] = (byte)(DcmValue.bufToUS(dcvData.getData(), i * 2) & lutMask);
        }
        this.isCenterWidth = true;
        this.windowWidth = numEntries;
        this.windowCenter = (lastMappedPixel - firstMappedPixel) / 2;
    }

    private void extractPixels(DcmDataObject ddo) throws Exception {
        if (!ddo.hasValue(1388)) {
            return;
        }
        int nPixel = this.rows * this.columns;
        DcmValue dcv = ddo.getDcmValue(1388);
        byte[] data = dcv.getData();
        if (this.bytePixel ? data.length < nPixel : data.length < 2 * nPixel) {
            throw new Exception("GeneralImageIOD.extractPixels: Not enough pixel data");
        }
        this.pixel16 = new short[nPixel];
        int numShift = this.bitsAllocated - this.bitsStored;
        int bitMask = (int)Math.pow(2.0, this.bitsStored) - 1;
        int i = 0;
        int p = 0;
        if (this.bytePixel) {
            while (p < nPixel) {
                if (this.unsignedPixel) {
                    this.pixel16[p++] = (short)(data[i++] & bitMask);
                    continue;
                }
                short v = data[i++];
                this.pixel16[p++] = (short)(v << numShift >> numShift);
            }
        } else {
            while (p < nPixel) {
                short v = (short)(data[i++] & 0xFF | (data[i++] & 0xFF) << 8);
                if (this.unsignedPixel) {
                    this.pixel16[p++] = (short)(v & bitMask);
                    continue;
                }
                this.pixel16[p++] = (short)(v << numShift >> numShift);
            }
        }
    }

    public void calcAutomaticCW() {
        int i;
        int sum = 0;
        int nPixel = this.rows * this.columns;
        int[] histogram = new int[this.maxPixelValue16 + 1];
        int l = this.pixel16.length;
        for (i = 0; i < nPixel; ++i) {
            int pixelValue = this.pixel16[i];
            if (pixelValue < 0) {
                pixelValue = 0;
            }
            if (pixelValue > this.maxPixelValue16) {
                pixelValue = this.maxPixelValue16;
            }
            int n = pixelValue;
            histogram[n] = histogram[n] + 1;
        }
        sum = 0;
        for (i = 0; i <= this.maxPixelValue16; ++i) {
            sum += histogram[i];
        }
        int s = 0;
        int min = 0;
        for (i = 0; i <= this.maxPixelValue16; ++i) {
            if ((s += histogram[i]) <= sum / 10) continue;
            min = i;
            break;
        }
        s = 0;
        int max = 0;
        for (i = this.maxPixelValue16; i >= 0; --i) {
            if ((s += histogram[i]) <= sum / 10) continue;
            max = i;
            break;
        }
        if (!this.unsignedPixel) {
            if (this.bytePixel) {
                min -= 128;
                max -= 128;
            } else {
                min -= 32768;
                max -= 32768;
            }
        }
        if (this.imageIOD == 1) {
            min = this.rescaleSlope * min + this.rescaleIntercept;
            max = this.rescaleSlope * max + this.rescaleIntercept;
        }
        this.autoCenter = (min + max) / 2;
        this.autoWidth = max - min;
    }

    private void setMonochrome1ColorModel() {
        byte[] cTab = new byte[256];
        for (int i = 0; i < 256; ++i) {
            cTab[i] = (byte)(256 - i);
        }
        this.cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
    }

    private void setMonochrome2ColorModel() {
        byte[] cTab = new byte[256];
        for (int i = 0; i < 256; ++i) {
            cTab[i] = (byte)i;
        }
        this.cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
    }

    public void updateImageSource() {
        int maxImageValue;
        int minImageValue;
        if (this.imageIOD == 1) {
            int ce = (this.theCenter - this.rescaleIntercept) / this.rescaleSlope;
            int wi = this.theWidth / this.rescaleSlope;
            if (ce > this.maxPixelValue) {
                ce = this.maxPixelValue;
            }
            if (ce < this.minPixelValue) {
                ce = this.minPixelValue;
            }
            if (wi > this.maxPixelValue) {
                wi = this.maxPixelValue;
            }
            if (wi < 1) {
                wi = 1;
            }
            this.theCenter = this.rescaleSlope * ce + this.rescaleIntercept;
            this.theWidth = this.rescaleSlope * wi;
            minImageValue = ce - wi / 2;
            maxImageValue = ce + wi / 2;
        } else {
            if (this.theCenter > this.maxPixelValue) {
                this.theCenter = this.maxPixelValue;
            }
            if (this.theCenter < this.minPixelValue) {
                this.theCenter = this.minPixelValue;
            }
            if (this.theWidth > this.maxPixelValue) {
                this.theWidth = this.maxPixelValue;
            }
            if (this.theWidth < 1) {
                this.theWidth = 1;
            }
            minImageValue = this.theCenter - this.theWidth / 2;
            maxImageValue = this.theCenter + this.theWidth / 2;
        }
        if (minImageValue < this.minPixelValue) {
            minImageValue = this.minPixelValue;
        }
        if (maxImageValue > this.maxPixelValue) {
            maxImageValue = this.maxPixelValue;
        }
        double step = (double)((IndexColorModel)this.cModel).getMapSize() / (double)(maxImageValue - minImageValue + 1);
        byte[] pixel8 = new byte[this.pixel16.length];
        for (int i = 0; i < this.pixel16.length; ++i) {
            int value = this.unsignedPixel ? (this.bytePixel ? this.pixel16[i] & 0xFF : this.pixel16[i] & 0xFFFF) : this.pixel16[i];
            value = this.pixel16[i] - minImageValue;
            if (value < 0) {
                value = 0;
            }
            if ((value = (int)((double)value * step)) > 255) {
                value = 255;
            }
            pixel8[i] = (byte)(value & 0xFF);
        }
        if (this.imgSource == null) {
            this.imgSource = new MemoryImageSource(this.columns, this.rows, this.cModel, pixel8, 0, this.columns);
        } else {
            this.imgSource.newPixels(pixel8, this.cModel, 0, this.columns);
        }
    }
}

