/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import virtual.mrt.sequences.Pulsesequence;

public class InversionRecovery
extends Pulsesequence {
    final double DELTAB = 1.95E-8;
    final double GYRO = 42.6;
    private int trTime;
    private int tiTime;

    protected void addSequenceParameterToImage() {
        this.ResultIP.setTR(this.trTime);
        this.ResultIP.setTI(this.tiTime);
        this.ResultIP.setSequence("IR");
    }

    public void calculate() {
        for (int x = 0; x < this.PDMatrix.length; ++x) {
            this.progressBar.setValue(x);
            try {
                if (x % 10 == 0) {
                    InversionRecovery.sleep(5L);
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            try {
                int nex = this.myUIClass.pNEX.getValue();
                long remainingtime = this.trTime * (256 - x) * nex;
                this.myUIClass.displayRemainingTime(remainingtime);
                InversionRecovery.sleep((long)((double)this.iTimeFactor / 100.0 * (double)this.trTime));
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int y = 0; y < this.PDMatrix[0].length; ++y) {
                if (this.T1Matrix[x][y] == 0) {
                    this.T1Matrix[x][y] = 1;
                }
                this.IntensityMatrix[x][y] = (int)Math.abs((double)this.PDMatrix[x][y] * (1.0 - 2.0 * Math.exp((double)(-this.tiTime) / (double)this.T1Matrix[x][y]) + Math.exp((double)(-this.trTime) / (double)this.tiTime)));
            }
        }
        super.calculate();
    }

    public void setTRTime(int tr) {
        this.trTime = tr;
    }

    public void setTITime(int ti) {
        this.tiTime = ti;
    }

    public int getTRTime() {
        return this.trTime;
    }

    public int getTITime() {
        return this.tiTime;
    }
}

