/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class CaseInfoFrame
extends JFrame {
    ResourceBundle frameRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_frame");
    final Dimension defaultSize = new Dimension(500, 560);
    JScrollPane textScrollPane = new JScrollPane();
    JEditorPane textEditorPane = new JEditorPane();
    BorderLayout borderLayout1 = new BorderLayout();

    public CaseInfoFrame() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(this.defaultSize);
        Dimension si = this.getSize();
        Dimension scrRes = this.getToolkit().getScreenSize();
        this.setLocation((scrRes.width - si.width) / 2, (scrRes.height - si.height) / 2);
        this.getContentPane().setLayout(this.borderLayout1);
        this.textScrollPane.setPreferredSize(this.defaultSize);
        this.textEditorPane.setPreferredSize(this.defaultSize);
        this.textEditorPane.setMinimumSize(new Dimension(256, 256));
        this.textEditorPane.setEditable(false);
        this.getContentPane().add((Component)this.textScrollPane, "Center");
        this.textScrollPane.getViewport().add((Component)this.textEditorPane, null);
    }

    public void setInfo(URL infoFileURL, String title) {
        this.setTitle(this.frameRsrc.getString("caseinfoframe.dialog.info.title") + " " + title);
        try {
            this.textEditorPane = new JEditorPane(infoFileURL);
        }
        catch (Exception e) {
            System.out.println("URL: " + infoFileURL + " not found.");
        }
        this.textScrollPane.getViewport().removeAll();
        this.textScrollPane.getViewport().add((Component)this.textEditorPane, null);
        this.validate();
    }
}

