/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import virtual.mrt.VMRTFrame;
import virtual.mrt.artefacts.ArtefactUI;

public class ArtefactsCombo
extends JComboBox {
    ResourceBundle artefactsRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_artefacts");
    ResourceBundle frameRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_frame");
    private Vector artefactClasses;
    private VMRTFrame mainFrame;
    private JPanel pArtefactUIPanel;
    private int oldindex;

    public ArtefactsCombo(VMRTFrame frame, JPanel seqSetPanel) {
        this.mainFrame = frame;
        this.pArtefactUIPanel = seqSetPanel;
        this.artefactClasses = new Vector(10, 5);
    }

    public void getArtefacts() {
        for (int i = 1; i <= 20; ++i) {
            String s = "Manipulator_Class_" + i;
            String w = null;
            String artName = null;
            try {
                w = this.artefactsRsrc.getString(s);
                w = w.replace('\"', ' ');
                w = w.trim();
                try {
                    artName = this.artefactsRsrc.getString("Manipulator_Name_" + i);
                }
                catch (Exception e) {
                    artName = w;
                }
                artName = artName.replace('\"', ' ');
                artName = artName.trim();
                String strArtefactUI = "virtual.mrt.artefacts." + w + "UI";
                Object myArtefact = null;
                Class<?> art = null;
                try {
                    art = Class.forName(strArtefactUI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    myArtefact = art.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ArtefactUI artefact = myArtefact;
                artefact.setMainFrame(this.mainFrame);
                artefact.setUIPanel(this.pArtefactUIPanel);
                this.mainFrame.repaint();
                this.artefactClasses.addElement(artefact);
            }
            catch (Exception e) {
                break;
            }
            this.addItem(artName);
        }
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ArtefactsCombo.this.cb_itemStateChanged(e);
            }
        });
        this.oldindex = 0;
    }

    private void cb_itemStateChanged(ItemEvent e) {
        int index;
        ArtefactUI art;
        this.pArtefactUIPanel.removeAll();
        this.pArtefactUIPanel.repaint();
        try {
            art = (ArtefactUI)this.artefactClasses.elementAt(this.oldindex);
            art.setValues();
        }
        catch (Exception err) {
            // empty catch block
        }
        this.oldindex = index = this.getSelectedIndex();
        try {
            art = (ArtefactUI)this.artefactClasses.elementAt(index);
        }
        catch (Exception err) {
            return;
        }
        art.fillPanel();
        art.getValues();
        this.mainFrame.setStatusBar(this.frameRsrc.getString("statusbar.note.start"));
        this.mainFrame.setStatusBar(this.mainFrame.getStatusText() + " ");
    }

    public ArtefactUI getSelectedArtefactUI() {
        int index = this.getSelectedIndex();
        try {
            return (ArtefactUI)this.artefactClasses.elementAt(index);
        }
        catch (Exception err) {
            return null;
        }
    }
}

