/*
 * Decompiled with CFR 0.152.
 */
package virtual.dv;

import java.io.File;
import javax.swing.JProgressBar;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmInputStream;
import rad.dicom.dcm.DcmValue;
import rad.dicom.ima.GeneralImageIOD;
import rad.ijplugin.dcm.ImportData;
import rad.ijplugin.util.Util;
import virtual.dv.ViewerFrame;
import virtual.tools.DcmImage;
import virtual.tools.ImagePlus;

public class SeriesLoader
extends Thread {
    private ViewerFrame mainFrame;
    private GeneralImageIOD refIOD;
    private ImportData imda;
    private JProgressBar pBar;

    public SeriesLoader(ViewerFrame mf, GeneralImageIOD ri, ImportData id) {
        this.mainFrame = mf;
        this.refIOD = ri;
        this.imda = id;
        this.pBar = this.mainFrame.getProgressBar();
    }

    public void run() {
        GeneralImageIOD[] gil = null;
        gil = this.imda.isMultiImage ? this.getGeneralImageIODList(this.refIOD, this.imda) : new GeneralImageIOD[]{this.refIOD};
        this.pBar.setValue(0);
        this.mainFrame.statusBar.setText("Lade Bilder...");
        for (int i = 0; i < gil.length; ++i) {
            this.pBar.setValue(i * 100 / gil.length);
            this.loadDcmImage(gil[i]);
        }
        this.pBar.setValue(0);
        this.mainFrame.statusBar.setText("Bereit.");
    }

    private GeneralImageIOD[] getGeneralImageIODList(GeneralImageIOD refGI, ImportData imda) {
        int k;
        File parent = new File(imda.theFile.getParent());
        String[] fNameList = parent.list();
        Util.bubbleSortStrings(fNameList);
        this.pBar.setValue(0);
        this.mainFrame.statusBar.setText("Analysiere Bildserie...");
        GeneralImageIOD[] aktGIL = new GeneralImageIOD[fNameList.length];
        int i = 0;
        for (k = 0; k < fNameList.length; ++k) {
            this.pBar.setValue(k * 100 / fNameList.length);
            File f = new File(parent + File.separator + fNameList[k]);
            if (!f.isFile()) continue;
            try {
                DcmDataObject ddo;
                GeneralImageIOD aktGI;
                if (!DcmInputStream.isDicomStream(f) || !this.isValidImage(refGI, aktGI = new GeneralImageIOD(ddo = DcmInputStream.loadDDO(f), imda.allowACRNema), imda)) continue;
                aktGIL[i++] = aktGI;
                continue;
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        this.pBar.setValue(0);
        this.mainFrame.statusBar.setText("Bereit.");
        GeneralImageIOD[] retGIL = new GeneralImageIOD[i];
        for (k = 0; k < i; ++k) {
            retGIL[k] = aktGIL[k];
        }
        return retGIL;
    }

    private boolean isValidImage(GeneralImageIOD refGI, GeneralImageIOD aktGI, ImportData imda) {
        if (refGI.patientName.compareTo(aktGI.patientName) == 0) {
            int i = aktGI.imageNumber;
            return imda.multiImageList.contains(new Integer(i));
        }
        return false;
    }

    public void loadDcmImage(GeneralImageIOD gi) {
        int windowWidth;
        int windowCenter;
        DcmDataObject ddo = null;
        DcmImage di = null;
        ddo = gi.headerDDO.getCopyOfMe();
        ddo.push(new DcmValue(1388, new byte[4]));
        try {
            di = new DcmImage(gi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ImagePlus ip = this.mainFrame.pCanvas.createNewImage(di);
        ip.setDDO(ddo);
        if (ddo.isAvailable(506) & ddo.hasValue(506)) {
            String[] sa = DcmValue.str2StringArray(ddo.getString(506), "\\");
            windowCenter = (int)DcmValue.str2Long(sa[0], 2048L);
            sa = DcmValue.str2StringArray(ddo.getString(507), "\\");
            windowWidth = (int)DcmValue.str2Long(sa[0], 4096L);
        } else {
            windowCenter = 2048;
            windowWidth = 4096;
        }
        this.mainFrame.pCenter.setValue(windowCenter);
        this.mainFrame.pWindow.setValue(windowWidth);
    }
}

