/*
 * Decompiled with CFR 0.152.
 */
package jigl.image;

import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jigl.image.DummyObserver;
import jigl.image.Image;
import jigl.image.ROI;
import jigl.image.RealGrayImage;

public class RealColorImage
implements Image {
    protected RealGrayImage[] plane = new RealGrayImage[3];
    protected int X;
    protected int Y;
    public static final int RGB = 0;
    public static final int CMY = 1;
    public static final int YIQ = 2;
    public static final int HSV = 3;
    public static final int HLS = 4;
    protected int colorModel = 0;

    public RealColorImage() {
        this.X = 0;
        this.Y = 0;
        this.plane[0] = null;
        this.plane[1] = null;
        this.plane[2] = null;
    }

    public RealColorImage(int x, int y) {
        this.X = x;
        this.Y = y;
        this.plane[0] = new RealGrayImage(this.X, this.Y);
        this.plane[1] = new RealGrayImage(this.X, this.Y);
        this.plane[2] = new RealGrayImage(this.X, this.Y);
    }

    public RealColorImage(RealColorImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.plane[0] = img.plane(1);
        this.plane[1] = img.plane(2);
        this.plane[2] = img.plane(3);
    }

    public RealColorImage(java.awt.Image img) {
        int w = img.getWidth(DummyObserver.dummy);
        int h = img.getHeight(DummyObserver.dummy);
        this.X = w;
        this.Y = h;
        this.plane[0] = new RealGrayImage(this.X, this.Y);
        this.plane[1] = new RealGrayImage(this.X, this.Y);
        this.plane[2] = new RealGrayImage(this.X, this.Y);
        this.InitFromImage(img, 0, 0, w, h);
    }

    public Image copy() {
        RealColorImage c = new RealColorImage(this.X, this.Y);
        c.setColorModel(this.colorModel);
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                c.plane[0].set(x, y, this.plane[0].get(x, y));
                c.plane[1].set(x, y, this.plane[1].get(x, y));
                c.plane[2].set(x, y, this.plane[2].get(x, y));
            }
        }
        return c;
    }

    public final int X() {
        return this.X;
    }

    public final int Y() {
        return this.Y;
    }

    public final int getColorModel() {
        return this.colorModel;
    }

    public final void setColorModel(int cm) {
        this.colorModel = cm;
    }

    public final RealGrayImage plane(int p) {
        return this.plane[p];
    }

    public final void setPlane(int p, RealGrayImage pl) {
        this.plane[p] = pl;
    }

    private void InitFromImage(java.awt.Image img, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        int index = 0;
        for (int iy = 0; iy < this.Y; ++iy) {
            for (int ix = 0; ix < this.X; ++ix) {
                red = 0xFF & pixels[index] >> 16;
                green = 0xFF & pixels[index] >> 8;
                blue = 0xFF & pixels[index];
                this.plane[0].set(ix, iy, (short)red);
                this.plane[1].set(ix, iy, (short)green);
                this.plane[2].set(ix, iy, (short)blue);
                ++index;
            }
        }
    }

    public final float[] get(int x, int y) {
        float[] color = new float[]{this.plane[0].get(x, y), this.plane[1].get(x, y), this.plane[2].get(x, y)};
        return color;
    }

    public final void set(int x, int y, float[] v) {
        this.plane[0].set(x, y, v[0]);
        this.plane[1].set(x, y, v[1]);
        this.plane[2].set(x, y, v[2]);
    }

    public final void add(int x, int y, float[] value) {
        this.plane[0].add(x, y, value[0]);
        this.plane[1].add(x, y, value[1]);
        this.plane[2].add(x, y, value[2]);
    }

    public final void add(int x, int y, float val0, float val1, float val2) {
        this.plane[0].add(x, y, val0);
        this.plane[1].add(x, y, val1);
        this.plane[2].add(x, y, val2);
    }

    public final void subtract(int x, int y, float[] value) {
        this.plane[0].subtract(x, y, value[0]);
        this.plane[1].subtract(x, y, value[1]);
        this.plane[2].subtract(x, y, value[2]);
    }

    public final void subtract(int x, int y, float val0, float val1, float val2) {
        this.plane[0].subtract(x, y, val0);
        this.plane[1].subtract(x, y, val1);
        this.plane[2].subtract(x, y, val2);
    }

    public final void multiply(int x, int y, float[] value) {
        this.plane[0].multiply(x, y, value[0]);
        this.plane[1].multiply(x, y, value[1]);
        this.plane[2].multiply(x, y, value[2]);
    }

    public final void multiply(int x, int y, float val0, float val1, float val2) {
        this.plane[0].multiply(x, y, val0);
        this.plane[1].multiply(x, y, val1);
        this.plane[2].multiply(x, y, val2);
    }

    public final void divide(int x, int y, float[] value) {
        this.plane[0].divide(x, y, value[0]);
        this.plane[1].divide(x, y, value[1]);
        this.plane[2].divide(x, y, value[2]);
    }

    public final void divide(int x, int y, float val0, float val1, float val2) {
        this.plane[0].divide(x, y, val0);
        this.plane[1].divide(x, y, val1);
        this.plane[2].divide(x, y, val2);
    }

    public final float min() {
        float min = Float.MAX_VALUE;
        float m1 = this.plane[0].min();
        float m2 = this.plane[1].min();
        float m3 = this.plane[2].min();
        if (m1 < min) {
            min = m1;
        }
        if (m2 < min) {
            min = m2;
        }
        if (m3 < min) {
            min = m3;
        }
        return min;
    }

    public final float min(int p) {
        return this.plane[p].min();
    }

    public final float max() {
        float max = Float.MIN_VALUE;
        float m1 = this.plane[0].max();
        float m2 = this.plane[1].max();
        float m3 = this.plane[2].max();
        if (m1 > max) {
            max = m1;
        }
        if (m2 > max) {
            max = m2;
        }
        if (m3 > max) {
            max = m3;
        }
        return max;
    }

    public final float max(int p) {
        return this.plane[p].max();
    }

    public final float[] addSum() {
        float[] sum = new float[]{this.plane(0).addSum(), this.plane(1).addSum(), this.plane(2).addSum()};
        return sum;
    }

    public final float[] absSum() {
        float[] sum = new float[]{this.plane(0).absSum(), this.plane(1).absSum(), this.plane(2).absSum()};
        return sum;
    }

    public final double[] sqrSum() {
        double[] sum = new double[]{this.plane(0).sqrSum(), this.plane(1).sqrSum(), this.plane(2).sqrSum()};
        return sum;
    }

    public final RealColorImage add(float val0, float val1, float val2) {
        this.plane[0] = this.plane[0].add(val0);
        this.plane[1] = this.plane[1].add(val1);
        this.plane[2] = this.plane[2].add(val2);
        return this;
    }

    public final RealColorImage add(float[] v) {
        this.plane[0] = this.plane[0].add(v[0]);
        this.plane[1] = this.plane[1].add(v[1]);
        this.plane[2] = this.plane[2].add(v[2]);
        return this;
    }

    public final RealColorImage add(int p, float v) {
        this.plane[p] = this.plane[p].add(v);
        return this;
    }

    public final RealColorImage subtract(float val0, float val1, float val2) {
        this.plane[0] = this.plane[0].subtract(val0);
        this.plane[1] = this.plane[1].subtract(val1);
        this.plane[2] = this.plane[2].subtract(val2);
        return this;
    }

    public final RealColorImage subtract(float[] v) {
        this.plane[0] = this.plane[0].subtract(v[0]);
        this.plane[1] = this.plane[1].subtract(v[1]);
        this.plane[2] = this.plane[2].subtract(v[2]);
        return this;
    }

    public final RealColorImage subtract(int p, float v) {
        this.plane[p] = this.plane[p].subtract(v);
        return this;
    }

    public final RealColorImage multiply(float[] v) {
        this.plane[0] = this.plane[0].multiply(v[0]);
        this.plane[1] = this.plane[1].multiply(v[1]);
        this.plane[2] = this.plane[2].multiply(v[2]);
        return this;
    }

    public final RealColorImage multiply(float val0, float val1, float val2) {
        this.plane[0] = this.plane[0].multiply(val0);
        this.plane[1] = this.plane[1].multiply(val1);
        this.plane[2] = this.plane[2].multiply(val2);
        return this;
    }

    public final RealColorImage multiply(int p, float v) {
        this.plane[p] = this.plane[p].multiply(v);
        return this;
    }

    public final RealColorImage divide(float[] v) {
        this.plane[0] = this.plane[0].divide(v[0]);
        this.plane[1] = this.plane[1].divide(v[1]);
        this.plane[2] = this.plane[2].divide(v[2]);
        return this;
    }

    public final RealColorImage divide(float val0, float val1, float val2) {
        this.plane[0] = this.plane[0].divide(val0);
        this.plane[1] = this.plane[1].divide(val1);
        this.plane[2] = this.plane[2].divide(val2);
        return this;
    }

    public final RealColorImage divide(int p, float v) {
        this.plane[p] = this.plane[p].divide(v);
        return this;
    }

    public final RealColorImage add(RealColorImage im) {
        this.plane[0] = this.plane[0].add(im.plane(0));
        this.plane[1] = this.plane[1].add(im.plane(1));
        this.plane[2] = this.plane[2].add(im.plane(2));
        return this;
    }

    public final RealColorImage subtract(RealColorImage im) {
        this.plane[0] = this.plane[0].subtract(im.plane(0));
        this.plane[1] = this.plane[1].subtract(im.plane(1));
        this.plane[2] = this.plane[2].subtract(im.plane(2));
        return this;
    }

    public final RealColorImage diff(RealColorImage im) {
        this.plane[0] = this.plane[0].diff(im.plane(0));
        this.plane[1] = this.plane[1].diff(im.plane(1));
        this.plane[2] = this.plane[2].diff(im.plane(1));
        return this;
    }

    public final RealColorImage multiply(RealColorImage im) {
        this.plane[0] = this.plane[0].multiply(im.plane(0));
        this.plane[1] = this.plane[1].multiply(im.plane(1));
        this.plane[2] = this.plane[2].multiply(im.plane(2));
        return this;
    }

    public final RealColorImage divide(RealColorImage im) {
        this.plane[0] = this.plane[0].divide(im.plane(0));
        this.plane[1] = this.plane[1].divide(im.plane(1));
        this.plane[2] = this.plane[2].divide(im.plane(2));
        return this;
    }

    public final String toString() {
        String str = "";
        str = str + this.plane[0].toString();
        str = str + this.plane[1].toString();
        str = str + this.plane[2].toString();
        return str;
    }

    public final ImageProducer getJavaImage() {
        double min = this.min();
        double max = this.max();
        if (min >= 0.0 && max <= 255.0) {
            min = 0.0;
            max = 255.0;
        }
        double range = max - min;
        int[] pix = new int[this.X * this.Y];
        int index = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        float[] color = new float[3];
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                color = this.get(x, y);
                red = (int)(255.0 / range * ((double)color[0] - min));
                green = (int)(255.0 / range * ((double)color[1] - min));
                blue = (int)(255.0 / range * ((double)color[2] - min));
                red = 0xFF & red;
                green = 0xFF & green;
                blue = 0xFF & blue;
                pix[index] = 0xFF000000 | red << 16 | green << 8 | blue;
                ++index;
            }
        }
        return new MemoryImageSource(this.X, this.Y, pix, 0, this.X);
    }

    public void byteSize() {
        double min = this.min();
        double max = this.max();
        double range = max - min;
        int red = 0;
        int green = 0;
        int blue = 0;
        float[] color = new float[3];
        for (int y = 0; y < this.Y; ++y) {
            for (int x = 0; x < this.X; ++x) {
                color = this.get(x, y);
                red = (int)(255.0 / range * ((double)color[0] - min));
                green = (int)(255.0 / range * ((double)color[1] - min));
                blue = (int)(255.0 / range * ((double)color[2] - min));
                red = 0xFF & red;
                green = 0xFF & green;
                blue = 0xFF & blue;
                color[0] = red;
                color[1] = green;
                color[2] = blue;
                this.set(x, y, color);
            }
        }
    }

    public final void clip(int min, int max) {
        this.plane[0].clip(min, max);
        this.plane[1].clip(min, max);
        this.plane[2].clip(min, max);
    }

    public Image copy(ROI r) {
        RealColorImage c = new RealColorImage(this.X, this.Y);
        c.setColorModel(this.colorModel);
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.lx(); ++x) {
                c.plane[0].set(x, y, this.plane[0].get(x, y));
                c.plane[1].set(x, y, this.plane[1].get(x, y));
                c.plane[2].set(x, y, this.plane[2].get(x, y));
            }
        }
        return c;
    }

    public final float[] get(int x, int y, ROI r) {
        float[] color = new float[]{this.plane[0].get(x + r.ux(), y + r.uy()), this.plane[1].get(x + r.ux(), y + r.uy()), this.plane[2].get(x + r.ux(), y + r.uy())};
        return color;
    }

    public final void set(int x, int y, int[] v, ROI r) {
        this.plane[0].set(x, y, v[0], r);
        this.plane[1].set(x, y, v[1], r);
        this.plane[2].set(x, y, v[2], r);
    }

    public final void add(int x, int y, float val0, float val1, float val2, ROI r) {
        this.plane[0].set(x, y, val0, r);
        this.plane[1].set(x, y, val1, r);
        this.plane[2].set(x, y, val2, r);
    }

    public final void add(int x, int y, float[] value, ROI r) {
        this.plane[0].add(x, y, value[0], r);
        this.plane[1].add(x, y, value[1], r);
        this.plane[2].add(x, y, value[2], r);
    }

    public final void subtract(int x, int y, float val0, float val1, float val2, ROI r) {
        this.plane[0].subtract(x, y, val0, r);
        this.plane[1].subtract(x, y, val1, r);
        this.plane[2].subtract(x, y, val2, r);
    }

    public final void subtract(int x, int y, float[] value, ROI r) {
        this.plane[0].subtract(x, y, value[0], r);
        this.plane[1].subtract(x, y, value[1], r);
        this.plane[2].subtract(x, y, value[2], r);
    }

    public final void multiply(int x, int y, float val0, float val1, float val2, ROI r) {
        this.plane[0].multiply(x, y, val0, r);
        this.plane[1].multiply(x, y, val1, r);
        this.plane[2].multiply(x, y, val2, r);
    }

    public final void multiply(int x, int y, float[] value, ROI r) {
        this.plane[0].multiply(x, y, value[0], r);
        this.plane[1].multiply(x, y, value[1], r);
        this.plane[2].multiply(x, y, value[2], r);
    }

    public final void divide(int x, int y, float[] value, ROI r) {
        this.plane[0].divide(x, y, value[0], r);
        this.plane[1].divide(x, y, value[1], r);
        this.plane[2].divide(x, y, value[2], r);
    }

    public final void divide(int x, int y, float val0, float val1, float val2, ROI r) {
        this.plane[0].divide(x, y, val0, r);
        this.plane[1].divide(x, y, val1, r);
        this.plane[2].divide(x, y, val2, r);
    }

    public final float min(ROI r) {
        float min = Float.MAX_VALUE;
        float m1 = this.plane[0].min(r);
        float m2 = this.plane[1].min(r);
        float m3 = this.plane[2].min(r);
        if (m1 < min) {
            min = m1;
        }
        if (m2 < min) {
            min = m2;
        }
        if (m3 < min) {
            min = m3;
        }
        return min;
    }

    public final float min(int p, ROI r) {
        return this.plane[p].min(r);
    }

    public final float max(ROI r) {
        float max = Float.MIN_VALUE;
        float m1 = this.plane[0].max(r);
        float m2 = this.plane[1].max(r);
        float m3 = this.plane[2].max(r);
        if (m1 > max) {
            max = m1;
        }
        if (m2 > max) {
            max = m2;
        }
        if (m3 > max) {
            max = m3;
        }
        return max;
    }

    public final float max(int p, ROI r) {
        return this.plane[p].max(r);
    }

    public final RealColorImage add(float[] v, ROI r) {
        this.plane[0] = this.plane[0].add(v[0], r);
        this.plane[1] = this.plane[1].add(v[1], r);
        this.plane[2] = this.plane[2].add(v[2], r);
        return this;
    }

    public final RealColorImage add(float val0, float val1, float val2, ROI r) {
        this.plane[0] = this.plane[0].add(val0, r);
        this.plane[1] = this.plane[1].add(val1, r);
        this.plane[2] = this.plane[2].add(val2, r);
        return this;
    }

    public final RealColorImage add(int p, float v, ROI r) {
        this.plane[p] = this.plane[p].add(v, r);
        return this;
    }

    public final RealColorImage subtract(float[] v, ROI r) {
        this.plane[0] = this.plane[0].subtract(v[0], r);
        this.plane[1] = this.plane[1].subtract(v[1], r);
        this.plane[2] = this.plane[2].subtract(v[2], r);
        return this;
    }

    public final RealColorImage subtract(float val0, float val1, float val2, ROI r) {
        this.plane[0] = this.plane[0].subtract(val0, r);
        this.plane[1] = this.plane[1].subtract(val1, r);
        this.plane[2] = this.plane[2].subtract(val2, r);
        return this;
    }

    public final RealColorImage subtract(int p, float v, ROI r) {
        this.plane[p] = this.plane[p].subtract(v, r);
        return this;
    }

    public final RealColorImage multiply(float[] v, ROI r) {
        this.plane[0] = this.plane[0].multiply(v[0], r);
        this.plane[1] = this.plane[1].multiply(v[1], r);
        this.plane[2] = this.plane[2].multiply(v[2], r);
        return this;
    }

    public final RealColorImage multiply(float val0, float val1, float val2, ROI r) {
        this.plane[0] = this.plane[0].multiply(val0, r);
        this.plane[1] = this.plane[1].multiply(val1, r);
        this.plane[2] = this.plane[2].multiply(val2, r);
        return this;
    }

    public final RealColorImage multiply(int p, float v, ROI r) {
        this.plane[p] = this.plane[p].multiply(v, r);
        return this;
    }

    public final RealColorImage divide(float[] v, ROI r) {
        this.plane[0] = this.plane[0].divide(v[0], r);
        this.plane[1] = this.plane[1].divide(v[1], r);
        this.plane[2] = this.plane[2].divide(v[2], r);
        return this;
    }

    public final RealColorImage divide(float val0, float val1, float val2, ROI r) {
        this.plane[0] = this.plane[0].divide(val0, r);
        this.plane[1] = this.plane[1].divide(val1, r);
        this.plane[2] = this.plane[2].divide(val2, r);
        return this;
    }

    public final RealColorImage divide(int p, float v, ROI r) {
        this.plane[p] = this.plane[p].divide(v, r);
        return this;
    }

    public final RealColorImage add(RealColorImage im, ROI sourceImage, ROI destImage) {
        this.plane[0] = this.plane[0].add(im.plane(0), sourceImage, destImage);
        this.plane[1] = this.plane[1].add(im.plane(1), sourceImage, destImage);
        this.plane[2] = this.plane[2].add(im.plane(2), sourceImage, destImage);
        return this;
    }

    public final RealColorImage subtract(RealColorImage im, ROI sourceImage, ROI destImage) {
        this.plane[0] = this.plane[0].subtract(im.plane(0), sourceImage, destImage);
        this.plane[1] = this.plane[1].subtract(im.plane(1), sourceImage, destImage);
        this.plane[2] = this.plane[2].subtract(im.plane(2), sourceImage, destImage);
        return this;
    }

    public final RealColorImage multiply(RealColorImage im, ROI sourceImage, ROI destImage) {
        this.plane[0] = this.plane[0].multiply(im.plane(0), sourceImage, destImage);
        this.plane[1] = this.plane[1].multiply(im.plane(1), sourceImage, destImage);
        this.plane[2] = this.plane[2].multiply(im.plane(2), sourceImage, destImage);
        return this;
    }

    public final RealColorImage divide(RealColorImage im, ROI sourceImage, ROI destImage) {
        this.plane[0] = this.plane[0].divide(im.plane(0), sourceImage, destImage);
        this.plane[1] = this.plane[1].divide(im.plane(1), sourceImage, destImage);
        this.plane[2] = this.plane[2].divide(im.plane(2), sourceImage, destImage);
        return this;
    }

    public final String toString(ROI r) {
        String str = "";
        str = str + this.plane[0].toString(r);
        str = str + this.plane[1].toString(r);
        str = str + this.plane[2].toString(r);
        return str;
    }

    public void byteSize(ROI r) {
        double min = this.min();
        double max = this.max();
        double range = max - min;
        int red = 0;
        int green = 0;
        int blue = 0;
        float[] color = new float[3];
        for (int y = r.uy(); y < r.ly(); ++y) {
            for (int x = r.ux(); x < r.ly(); ++x) {
                color = this.get(x, y);
                red = (int)(255.0 / range * ((double)color[0] - min));
                green = (int)(255.0 / range * ((double)color[1] - min));
                blue = (int)(255.0 / range * ((double)color[2] - min));
                red = 0xFF & red;
                green = 0xFF & green;
                blue = 0xFF & blue;
                color[0] = red;
                color[1] = green;
                color[2] = blue;
                this.set(x, y, color);
            }
        }
    }

    public final void clear(float v) {
        this.plane[0].clear(v);
        this.plane[1].clear(v);
        this.plane[2].clear(v);
    }

    public final void clip(int min, int max, ROI r) {
        this.plane[0].clip(min, max, r);
        this.plane[1].clip(min, max, r);
        this.plane[2].clip(min, max, r);
    }
}

