/*
 * Decompiled with CFR 0.152.
 */
package rad.ijplugin.dcm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rad.dicom.dcm.DcmValue;
import rad.ijplugin.dcm.GridBagConstraints2;
import rad.ijplugin.dcm.ImportData;

public class FileListPanel
extends JPanel {
    private ImportData imda;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel imageListL = new JLabel();
    JTextField imageListT = new JTextField();
    JCheckBox multiChecBox = new JCheckBox();
    JCheckBox inclStrChecBox = new JCheckBox();
    JCheckBox inclDDOChecBox = new JCheckBox();
    JCheckBox onlyFirstChecBox = new JCheckBox();
    JLabel headerL = new JLabel();

    public FileListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void intWithDataBlock(ImportData id) {
        this.imda = id;
        this.inclStrChecBox.setSelected(this.imda.isIncludeStringHeader);
        this.inclDDOChecBox.setSelected(this.imda.isIncludeBinHeader);
        this.onlyFirstChecBox.setSelected(this.imda.isIncludeOnlyFirstHeader);
        this.multiChecBox.setSelected(this.imda.isMultiImage);
        if (this.imda.isMultiImage) {
            this.imageListT.setText(this.imda.multiImageIDList);
        }
    }

    public void updateDataBlock() {
        this.imda.isMultiImage = this.multiChecBox.isSelected();
        if (this.imda.isMultiImage) {
            this.getImageRange();
        }
        this.imda.isIncludeStringHeader = this.inclStrChecBox.isSelected();
        this.imda.isIncludeBinHeader = this.inclDDOChecBox.isSelected();
        this.imda.isIncludeOnlyFirstHeader = this.onlyFirstChecBox.isSelected();
    }

    private void getImageRange() {
        this.imda.multiImageList = new Vector();
        String list = this.imageListT.getText();
        if (list.startsWith("-")) {
            list = "1" + list;
        }
        if (list.endsWith("-")) {
            list = list + "999";
        }
        StringTokenizer itemst = new StringTokenizer(list, ",");
        block4: while (true) {
            try {
                int i;
                String item = itemst.nextToken().trim();
                if (item.indexOf(45) == -1) {
                    i = (int)DcmValue.str2Long((String)item, (long)0L);
                    if (!(i > 0 & i < 1000)) continue;
                    this.imda.multiImageList.addElement(new Integer(i));
                    continue;
                }
                StringTokenizer imast = new StringTokenizer(item, "-");
                int imax = 0;
                int imin = 0;
                try {
                    imin = (int)DcmValue.str2Long((String)imast.nextToken(), (long)0L);
                    imax = (int)DcmValue.str2Long((String)imast.nextToken(), (long)0L);
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                if (imin > 0 & imin < 1000 & imax > 0 & imax < 1000) {
                    if (imin > imax) {
                        i = imin;
                        imin = imax;
                        imax = i;
                    }
                    i = imin;
                    while (true) {
                        if (i > imax) continue block4;
                        this.imda.multiImageList.addElement(new Integer(i));
                        ++i;
                    }
                }
                if (imin > 0 && imin < 1000) {
                    this.imda.multiImageList.addElement(new Integer(imin));
                }
                if (imax <= 0 || imax >= 1000) continue;
                this.imda.multiImageList.addElement(new Integer(imax));
            }
            catch (NoSuchElementException e) {
                return;
            }
        }
    }

    void multiChecBox_itemStateChanged(ItemEvent e) {
        this.setMultiChecBox();
    }

    private void setMultiChecBox() {
        if (this.multiChecBox.isSelected()) {
            this.imageListT.setEnabled(true);
            this.imageListT.setBackground(Color.white);
        } else {
            this.imageListT.setEnabled(false);
            this.imageListT.setBackground(Color.lightGray);
        }
        this.repaint();
    }

    void inclStrChecBox_itemStateChanged(ItemEvent e) {
        this.setInclChecBox();
    }

    void inclDDOChecBox_itemStateChanged(ItemEvent e) {
        this.setInclChecBox();
    }

    private void setInclChecBox() {
        if (this.inclStrChecBox.isSelected() | this.inclDDOChecBox.isSelected()) {
            this.onlyFirstChecBox.setEnabled(true);
        } else {
            this.onlyFirstChecBox.setEnabled(false);
        }
        this.repaint();
    }

    private void jbInit() throws Exception {
        this.onlyFirstChecBox.setActionCommand("Only for first image");
        this.onlyFirstChecBox.setText("only for first image");
        this.inclStrChecBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FileListPanel.this.inclStrChecBox_itemStateChanged(e);
            }
        });
        this.inclStrChecBox.setText("as String");
        this.inclStrChecBox.setSelected(false);
        this.multiChecBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FileListPanel.this.multiChecBox_itemStateChanged(e);
            }
        });
        this.multiChecBox.setForeground(Color.black);
        this.multiChecBox.setText("Load multiple images");
        this.multiChecBox.setSelected(false);
        this.imageListT.setBackground(Color.lightGray);
        this.imageListT.setEnabled(false);
        this.imageListT.setMinimumSize(new Dimension(60, 20));
        this.imageListT.setPreferredSize(new Dimension(60, 20));
        this.imageListL.setPreferredSize(new Dimension(110, 15));
        this.imageListL.setText("Image list e.g. [3,5-7,9] or [-4,9] or [1,4-] or [-]:");
        this.setMultiChecBox();
        this.setInclChecBox();
        this.setLayout(this.gridBagLayout2);
        this.headerL.setText("Include DICOM header:");
        this.inclDDOChecBox.setText("as DataObject");
        this.inclDDOChecBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FileListPanel.this.inclDDOChecBox_itemStateChanged(e);
            }
        });
        this.add((Component)this.imageListT, new GridBagConstraints2(2, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.headerL, new GridBagConstraints2(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.multiChecBox, new GridBagConstraints2(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.imageListL, new GridBagConstraints2(0, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.onlyFirstChecBox, new GridBagConstraints2(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.inclStrChecBox, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.inclDDOChecBox, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

