/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriteParam;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Encoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibJPEGImageWriter
extends CLibImageWriter {
    private Encoder encoder;

    private static BufferedImage convertTo3BandRGB(RenderedImage im) {
        BufferedImage dst;
        Raster src;
        if (im == null) {
            throw new IllegalArgumentException("im == null");
        }
        ColorModel cm = im.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("!(im.getColorModel() instanceof IndexColorModel)");
        }
        if (im.getNumXTiles() == 1 && im.getNumYTiles() == 1) {
            src = im.getTile(im.getMinTileX(), im.getMinTileY());
            if (src.getWidth() != im.getWidth() || src.getHeight() != im.getHeight()) {
                src = src.createChild(src.getMinX(), src.getMinY(), im.getWidth(), im.getHeight(), src.getMinX(), src.getMinY(), null);
            }
        } else {
            src = im.getData();
        }
        if ((dst = ((IndexColorModel)cm).convertToIntDiscrete(src, false)).getSampleModel().getNumBands() == 4) {
            WritableRaster rgbaRas = dst.getRaster();
            WritableRaster rgbRas = rgbaRas.createWritableChild(0, 0, dst.getWidth(), dst.getHeight(), 0, 0, new int[]{0, 1, 2});
            PackedColorModel pcm = (PackedColorModel)dst.getColorModel();
            int bits = pcm.getComponentSize(0) + pcm.getComponentSize(1) + pcm.getComponentSize(2);
            DirectColorModel dcm = new DirectColorModel(bits, pcm.getMask(0), pcm.getMask(1), pcm.getMask(2));
            dst = new BufferedImage(dcm, rgbRas, false, null);
        }
        return dst;
    }

    CLibJPEGImageWriter(ImageWriterSpi originatingProvider) throws IOException {
        super(originatingProvider);
        try {
            this.encoder = new Encoder();
            this.encoder.setExtend(0);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibJPEGImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int[] nArray;
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter stream = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        stream = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = image.getRenderedImage();
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            renderedImage = CLibJPEGImageWriter.convertTo3BandRGB(renderedImage);
        }
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        int bitDepth = renderedImage.getColorModel().getComponentSize(0);
        if ((param == null || param.getCompressionMode() == 2 && !param.isCompressionLossless()) && bitDepth > 12) {
            throw new IIOException("JPEG baseline encoding is limited to 12 bits: " + this);
        }
        if (param != null && param.getCompressionMode() == 2) {
            if (param.isCompressionLossless()) {
                try {
                    if (bitDepth >= 2 && bitDepth <= 16 && bitDepth % 8 != 0) {
                        this.encoder.setDepth(bitDepth);
                    }
                    if (param.getCompressionType().equalsIgnoreCase("JPEG-LOSSLESS")) {
                        this.encoder.setMode(1);
                    }
                    this.encoder.setMode(2);
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
            } else {
                try {
                    this.encoder.setMode(0);
                    this.encoder.setQuality((int)(param.getCompressionQuality() * 100.0f));
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
            }
        } else {
            try {
                this.encoder.setMode(0);
                this.encoder.setQuality(75);
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
        }
        if (param == null || param.getCompressionMode() == 2 && !param.isCompressionLossless()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 2;
            nArray2[1] = 4;
            nArray = nArray2;
            nArray2[2] = 3;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArray = nArray3;
            nArray3[1] = 3;
        }
        int[] supportedFormats = nArray;
        mediaLibImage mlibImage = this.getMediaLibImage(renderedImage, param, false, supportedFormats);
        try {
            this.encoder.encode((OutputStream)stream, mlibImage);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
    }
}

