/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.SimpleCMYKColorSpace;
import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Decoder;
import java.awt.color.ColorSpace;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

final class CLibJPEGImageReader
extends CLibImageReader {
    private static final boolean DEBUG = false;
    private mediaLibImage infoImage = null;
    private int infoImageIndex = -1;
    private HashMap imageTypes = new HashMap();
    private int bitDepth;

    CLibJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected final synchronized mediaLibImage decode(InputStream stream) throws IOException {
        mediaLibImage mlImage = null;
        Decoder decoder = null;
        try {
            if (stream instanceof InputStreamAdapter) {
                ImageInputStream iis = ((InputStreamAdapter)stream).getWrappedStream();
                decoder = new Decoder(iis);
            } else {
                decoder = new Decoder(stream);
            }
            mlImage = decoder.decode(null);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        if (mlImage == null) {
            throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
        }
        try {
            this.bitDepth = decoder.getDepth();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        decoder.dispose();
        return mlImage;
    }

    private synchronized mediaLibImage getInfoImage(int imageIndex) throws IOException {
        if (this.infoImage == null || imageIndex != this.infoImageIndex) {
            if (imageIndex == this.getImageIndex()) {
                this.infoImage = this.getImage(imageIndex);
                this.infoImageIndex = imageIndex;
                return this.infoImage;
            }
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            ImageInputStream iis = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            iis = (ImageInputStream)this.input;
            this.seekToImage(imageIndex);
            iis.mark();
            Decoder decoder = null;
            try {
                decoder = new Decoder(iis);
                this.infoImage = decoder.getSize();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            if (this.infoImage == null || this.infoImage.getFormat() == 0 && (this.infoImage = this.getImage(imageIndex)) == null) {
                throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
            }
            this.infoImageIndex = imageIndex;
            try {
                this.bitDepth = decoder.getDepth();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            iis.reset();
            decoder.dispose();
        }
        return this.infoImage;
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.getInfoImage(imageIndex).getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.getInfoImage(imageIndex).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        ArrayList types = null;
        HashMap hashMap = this.imageTypes;
        synchronized (hashMap) {
            Integer key = new Integer(imageIndex);
            if (this.imageTypes.containsKey(key)) {
                types = (ArrayList)this.imageTypes.get(key);
            } else {
                types = new ArrayList();
                mediaLibImage mlImage = this.getInfoImage(imageIndex);
                if (mlImage.getFormat() == 11) {
                    ColorSpace cmyk = SimpleCMYKColorSpace.getInstance();
                    types.add(CLibJPEGImageReader.createImageType(mlImage, cmyk, this.bitDepth, null, null, null, null));
                } else {
                    types.add(CLibJPEGImageReader.createImageType(mlImage, null, this.bitDepth, null, null, null, null));
                }
            }
        }
        return types.iterator();
    }

    protected void resetLocal() {
        this.infoImage = null;
        this.infoImageIndex = -1;
        this.imageTypes.clear();
        super.resetLocal();
    }
}

