
#version 110

uniform vec4 axialClipPlane;
uniform vec4 coronalClipPlane;
uniform vec4 sagittalClipPlane;

uniform int axialClipPlaneUse;
uniform int coronalClipPlaneUse;
uniform int sagittalClipPlaneUse;

uniform int transparentUse;
uniform int baseSurfaceUse;

varying vec4 pos;
varying vec3 N;
varying vec4 vertColor;

void main(void) 
{	
	int cutPlaneUse = axialClipPlaneUse + coronalClipPlaneUse + sagittalClipPlaneUse;
    
	if ( (cutPlaneUse > 0) && (transparentUse == 0) && (baseSurfaceUse == 1)
		&&	((axialClipPlaneUse == 0) || (dot(pos, axialClipPlane) < 0.0)) 
		&& 	((coronalClipPlaneUse == 0) || (dot(pos, coronalClipPlane) < 0.0)) 
		&& 	((sagittalClipPlaneUse == 0) || (dot(pos, sagittalClipPlane) < 0.0))	) {
		discard;
	} else {
	   	vec4 sceneColor;
    	vec4 ambient;
    	vec4 diffuse;
    	vec4 specular;
    	float shininess;
    	float alpha;
    	vec3 normal;
    
    	if (gl_FrontFacing) {
    		normal = N;
        	sceneColor = gl_FrontLightModelProduct.sceneColor;
        	ambient = gl_FrontLightProduct[0].ambient;
        	diffuse = gl_FrontLightProduct[0].diffuse;
        	specular = gl_FrontLightProduct[0].specular;
        	shininess = gl_FrontMaterial.shininess;
        	alpha = gl_FrontLightProduct[0].diffuse.a;
    	} else { // back face
        	normal = -N;
        	sceneColor = gl_BackLightModelProduct.sceneColor;
        	ambient = gl_BackLightProduct[1].ambient;
        	diffuse = gl_BackLightProduct[1].diffuse;
        	specular = gl_BackLightProduct[1].specular;
        	shininess = gl_BackMaterial.shininess;
        	alpha = clamp(gl_FrontLightProduct[0].diffuse.a * 1.1, 0.0, 1.0);
   		}
    
    	if ((alpha == 1.0) && (vertColor.a < 1.0)) {
    		alpha = vertColor.a;
    	}
    
   		vec4 ambientComp = ambient;    
   		vec4 diffuseComp = diffuse * max(dot(normal, normalize(gl_LightSource[0].position.xyz)), 0.0);
   		vec4 specularComp = specular * pow(max(dot(normal, gl_LightSource[0].halfVector.xyz), 0.0), shininess);
   		
   		gl_FragColor = vec4((vertColor * (sceneColor + ambientComp + diffuseComp + specularComp)).xyz, alpha);
	}
}