
package edu.uthscsa.ric.volume;

/**
 * A LabelManager stores a series of labels.
 * 
 * @author michaelmartinez
 *
 */
public interface LabelManager {

	/**
	 * Returns a label for the specified index.
	 * 
	 * @param index the series index
	 * @param defaultStr the default label to return if none is found
	 * @return the label
	 */
	String getLabel(int index, String defaultStr);



	/**
	 * Returns a serialized byte array of label data.
	 * 
	 * @return a serialized byte array of label data
	 */
	byte[] getLabelData();



	/**
	 * Returns the label model.
	 * 
	 * @return the label model
	 */
	String[] getLabelModel();



	/**
	 * Returns true if labels are found.
	 * 
	 * @return true if labels are found, false otherwise
	 */
	boolean hasLabels();



	/**
	 * Notifies listener that labels have changed.
	 */
	void labelChanged();



	/**
	 * Sets the specified label at the specified index.
	 * 
	 * @param index the series index
	 * @param label the label
	 */
	void setLabel(int index, String label);



	/**
	 * Sets the specified label at the specified index.
	 * 
	 * @param index the series index
	 * @param label the label
	 * @param notify true to notify any listeners, false otherwise
	 */
	void setLabel(final int index, final String label, final boolean notify);



	/**
	 * Sets the label data.
	 * 
	 * @param data a serialized byte array of label data
	 */
	void setLabelData(byte[] data);
}
