
package edu.uthscsa.ric.volume;

/**
 * ImageTransform provides access to volume transform.
 */
public interface ImageTransform {

	int PREFERRED_ROTATION_CENTER = 0;
	int PREFERRED_ROTATION_CURRENT = 2;
	int PREFERRED_ROTATION_ORIGIN = 1;



	/**
	 * Returns a copy of the 4x4 image transformation matrix.
	 * 
	 * @return transformation matrix as a 4x4 two-dimensional array
	 */
	double[][] getMatrixCopy();



	/**
	 * Load a different transform.
	 * 
	 * @param matNew the 4x4 transform matrix
	 * @param preferredOrigin PREFERRED_ROTATION_CENTER, PREFERRED_ROTATION_ORIGIN, PREFERRED_ROTATION_CURRENT
	 * @param coor the rotation origin if PREFERRED_ROTATION_CURRENT
	 */
	void loadTransform(double[][] matNew, int preferredOrigin, Coordinate coor);



	/**
	 * Transforms the coordinate.
	 * 
	 * @param coor the coordinate to transform
	 * @return the parameter coordinate
	 */
	Coordinate transform(Coordinate coor);



	/**
	 * Transforms the coordinate.
	 * 
	 * @param coor the coordinate to transform
	 * @return the parameter coordinate
	 */
	Coordinate transformNative(Coordinate coor);



	/**
	 * Update the transform.
	 * 
	 * @param matNew the 4x4 transform matrix
	 */
	void updateTransform(double[][] matNew);
}
