
package edu.uthscsa.ric.visualization.surface.primitives;

import edu.uthscsa.ric.visualization.surface.io.FloatIterator;
import edu.uthscsa.ric.visualization.surface.io.IndexIterator;


/**
 * A surface.
 * 
 * @author michaelmartinez
 *
 */
public interface Surface {

	float[] DEFAULT_COLOR = { 1, 1, 1 };



	/**
	 * Returns the color components (one solid color) of this Surface.
	 * 
	 * @return an array of RGB components
	 */
	float[] getColor();



	/**
	 * Returns a colors iterator.
	 * 
	 * @return iterator
	 */
	FloatIterator getColorsIterator();



	/**
	 * Returns a description of this Surface.
	 * 
	 * @return a description of this Surface
	 */
	String getDescription();



	/**
	 * Returns a triangles iterator.
	 * 
	 * @return iterator
	 */
	IndexIterator getIndiciesIterator();



	/**
	 * Returns the name of this Surface.
	 * 
	 * @return the name of this Surface
	 */
	String getName();



	/**
	 * Returns a normals iterator.
	 * 
	 * @return iterator
	 */
	FloatIterator getNormalsIterator();



	/**
	 * Returns the number of points in this Surface.
	 * 
	 * @return the number of points
	 */
	int getNumPoints();



	/**
	 * Returns the number of triangles in this Surface.
	 * 
	 * @return the number of triangles
	 */
	int getNumTriangles();



	/**
	 * Returns an array of Overlay objects associated with this Surface.
	 * 
	 * @return an array of Overlay objects
	 */
	Overlay[] getOverlays();



	/**
	 * Returns a points iterator.
	 * 
	 * @return iterator
	 */
	FloatIterator getPointsIterator();



	/**
	 * Returns the threshold used to build this Surface.
	 * 
	 * @return the threhsold used to build this Surface
	 */
	float getThreshold();



	/**
	 * True if this Surface is the base surface, false otherwise.
	 * 
	 * @return true if base surface, false otherwise
	 */
	boolean isBaseSurface();



	/**
	 * Returns true if the surface is hidden.
	 * 
	 * @return true if the surface is hidden, false otherwise
	 */
	boolean isHidden();



	/**
	 * Returns whether the viewer transform is applied to the surface.
	 * 
	 * @return true if the viewer transform is applied to the surface
	 */
	boolean isUseTransform();



	/**
	 * Sets the surface description.
	 * 
	 * @param description the description
	 */
	void setDescription(String description);



	/**
	 * Sets the surface visibility.
	 * 
	 * @param hidden true to hide the surface, false to show it
	 */
	void setHidden(boolean hidden);



	/**
	 * Sets the surface threshold.
	 * 
	 * @param threshold the threshold
	 */
	void setThreshold(float threshold);



	/**
	 * Sets if the viewer transform is applied to the surface.
	 * 
	 * @param useTransform true to apply the viewer transform to the surface, false otherwise
	 */
	void setUseTransform(boolean useTransform);
}
