
package edu.uthscsa.ric.visualization.surface.primitives;

import java.nio.FloatBuffer;

import edu.uthscsa.ric.visualization.surface.io.FloatIterator;


/**
 * A surface overlay.
 * 
 * @author michaelmartinez
 *
 */
public interface Overlay {

	/**
	 * Returns the LUT name associated with this Overlay.
	 * 
	 * @return the LUT name
	 */
	String getColorTableName();



	/**
	 * Returns the LUT maximum.
	 * 
	 * @return the maximum
	 */
	float getMax();



	/**
	 * Returns the LUT minimum.
	 * 
	 * @return the minimum
	 */
	float getMin();



	/**
	 * Returns an array of scalar buffers.
	 * 
	 * @return an array of scalar buffers
	 */
	FloatBuffer[] getScalars();



	/**
	 * Returns the scalars iterator.
	 * 
	 * @return the scalars iterator
	 */
	FloatIterator getScalarsIterator();



	/**
	 * Returns the number of scalar values.
	 * 
	 * @return the number of scalar values
	 */
	int getScalarsSize();
}
