
package edu.uthscsa.ric.visualization.surface.io;

import java.io.File;
import java.util.Vector;

import javax.swing.JPanel;

import edu.uthscsa.ric.mango.MangoPluginType;
import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;


/**
 * A class that implements SurfaceFormat can be registered with Mango to extend the number of surface formats supported.
 */
public interface SurfaceFormat extends MangoPluginType {

	/**
	 * Returns options.
	 * 
	 * @return options
	 */
	String getOptions();



	@Deprecated
	JPanel getOptionsPanel(Surface[] data, Shape[] shapes, SurfaceController controller);



	/**
	 * Returns an option dialog.
	 * 
	 * @param data the surface data available to save
	 * @param shapes the shape data available to save
	 * @param manager the VolumeManager
	 * @return the dialog
	 */
	JPanel getOptionsPanel(Surface[] data, Shape[] shapes, VolumeManager manager);



	/**
	 * Returns the preferred file extension of this format.
	 * 
	 * @return the preferred file extension
	 */
	String getPreferredFileExtension();



	/**
	 * Used to determine if a file is of this format (e.g., read magic number, check file size, check file extension, etc).
	 * 
	 * @param file the file to read
	 * @return returns true if this file can be read by this format, false otherwise
	 */
	boolean isThisFormat(File file);



	/**
	 * Reads surface data from file. For returned data, if triangle data is in the form of strip counts, then normals data must be present. If triangle data is
	 * in the form of indices, then normals data may or may not be present.
	 * 
	 * @param file the file to read
	 * @param controller the ViewerController object can be used to access image dimensions, orientation, lookup tables, etc.
	 * @param shapes shape objects can be stored here
	 * @param baseSurface true if the viewer does not yet exist, false if you are loading shapes into an existing viewer
	 * @return the read surface data; the first index in the return array specifies the base image surface.
	 * @throws SurfaceFormatException surface format exception
	 * @deprecated
	 */
	@Deprecated
	Surface[] readSurfaceFile(File file, ViewerController controller, Vector<Shape> shapes, boolean baseSurface) throws SurfaceFormatException;



	/**
	 * Reads surface data from file. For returned data, if triangle data is in the form of strip counts, then normals data must be present. If triangle data is
	 * in the form of indices, then normals data may or may not be present.
	 * 
	 * @param file the file to read
	 * @param manager the VolumeManager
	 * @param shapes shape objects can be stored here
	 * @param baseSurface true if the viewer does not yet exist, false if you are loading shapes into an existing viewer
	 * @return the read surface data; the first index in the return array specifies the base image surface.
	 * @throws SurfaceFormatException surface format exception
	 */
	Surface[] readSurfaceFile(File file, VolumeManager manager, Vector<Shape> shapes, boolean baseSurface) throws SurfaceFormatException;



	/**
	 * Reads surface header (meta data) from file.
	 * 
	 * @param file the file to read
	 * @param shapes shape objects can be stored here
	 * @return the read surface data; the first index in the return array specifies the base image surface.
	 * @throws SurfaceFormatException surface format exception
	 */
	Surface[] readSurfaceHeader(File file, Vector<Shape> shapes) throws SurfaceFormatException;



	/**
	 * Sets the options.
	 * 
	 * @param options the options
	 */
	void setOptions(String options);



	/**
	 * Writes surface data to file. Triangle data is always passed to this method as strip counts.
	 * 
	 * @param file the file to write
	 * @param surfaces an array of surfaces; the first index is the base surface
	 * @param shapes an array of shapes
	 * @param controller the SurfaceController
	 * @throws SurfaceFormatException surface format exception
	 * @deprecated
	 */
	@Deprecated
	void writeSurfaceFile(File file, Surface[] surfaces, Shape[] shapes, SurfaceController controller) throws SurfaceFormatException;



	/**
	 * Writes surface data to file. Triangle data is always passed to this method as strip counts.
	 * 
	 * @param file the file to write
	 * @param surfaces an array of surfaces; the first index is the base surface
	 * @param shapes an array of shapes
	 * @param manager the VolumeManager
	 * @throws SurfaceFormatException surface format exception
	 */
	void writeSurfaceFile(File file, Surface[] surfaces, Shape[] shapes, VolumeManager manager) throws SurfaceFormatException;
}
