
package edu.uthscsa.ric.visualization.surface.io;

import java.nio.IntBuffer;


/**
 * An iterator of surface index data.
 * 
 * @author michaelmartinez
 *
 */
public class IndexIterator {

	private final IntBuffer[] buffers;
	private final int[] counts;

	private int currentBufferIndex;
	private int currentCount;



	/**
	 * Constructor.
	 * 
	 * @param buffers the buffers
	 * @param counts the counts
	 */
	public IndexIterator(final IntBuffer[] buffers, final int[] counts) {
		this.buffers = buffers;
		this.counts = counts;

		if (buffers != null) {
			for (final IntBuffer buffer : buffers) {
				buffer.clear();
			}
		}
	}



	/**
	 * Returns true if there is more data.
	 * 
	 * @return true if there is more data, false otherwise.
	 */
	public boolean hasNext() {
		if (this.buffers == null) {
			return false;
		} else if (this.buffers[this.currentBufferIndex].hasRemaining()) {
			return true;
		} else {
			this.currentCount += this.counts[this.currentBufferIndex];
			this.currentBufferIndex++;

			if (this.currentBufferIndex < this.buffers.length) {
				return hasNext();
			} else {
				return false;
			}
		}
	}



	/**
	 * Returns the next float element.
	 * 
	 * @return float
	 */
	public int next() {
		final int val = this.buffers[this.currentBufferIndex].get() + this.currentCount;
		return val;
	}
}
