
package edu.uthscsa.ric.visualization.surface;

import com.jogamp.opengl.GLAutoDrawable;

import edu.uthscsa.ric.mango.MangoPluginType;


/**
 * A class which implements SurfacePlugin can be registered with Mango and have access to surface-related data. Compiling a SurfacePlugin will require JOGL
 * libraries to be in your classpath. These libraries are included with the application and can found where the application is installed.
 * 
 * @see <a href="https://jogamp.org/jogl/www/">https://jogamp.org/jogl/www/</a>
 */
public interface SurfacePlugin extends MangoPluginType {

	/**
	 * After calling addToDisplay() from a SurfaceController, this method will be called at the end of each drawing loop.
	 * 
	 * @param drawable the JOGL draw instance
	 */
	void display(GLAutoDrawable drawable);



	/**
	 * This is the method which Mango executes when a plugin is chosen.
	 * 
	 * @param controller a SurfaceController provided to the plugin
	 */
	void doOperation(SurfaceController controller);
}
