
package edu.uthscsa.ric.roi;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;


/**
 * Intended only as an interface so that the implementation of LOISpecialManager can be hidden. (Used for plugins.)
 */
public interface ShapesSpecialManager {

	Shape addImmutableShape(Shape shape, int slice, Color color, Stroke stroke);



	Shape addShape(Shape shape, int slice, Color color, Stroke stroke);



	Shape addStaticShape(Shape shape, Color color, Stroke stroke);



	Shape[] getShapes(int slice, Color color);



	Shape[] getStaticShapes(Color color);



	void removeShape(Shape shape);



	void setShapeHighlightState(Shape shape, boolean highlight);
}
