
package edu.uthscsa.ric.roi;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Vector;


/**
 * A ROI line can consist of two or more points.
 * 
 * @author michaelmartinez
 *
 */
public interface Line extends ROI {

	/**
	 * Returns the points in this line.
	 * 
	 * @return the points
	 */
	Vector<Point> getPoints();



	/**
	 * The slice direction of this line (see VolumeManager constants).
	 * 
	 * @return the slice direction
	 */
	int getSliceDirection();



	/**
	 * The slice number of this line.
	 * 
	 * @return the slice number
	 */
	int getSliceNum();



	/**
	 * Creates a list of points of all intersected voxels.
	 * 
	 * @return a list of points
	 */
	Vector<Point2D> makeInterpolatedPoints();



	/**
	 * Creates a list of points at a specified interval.
	 * 
	 * @param step the interval
	 * @return a list of points
	 */
	Vector<Point2D> makeInterpolatedPointsMM(final double step);
}
