
package edu.uthscsa.ric.roi;

/**
 * Manages ROI color data.
 * 
 * @author michaelmartinez
 *
 */
public interface ColorManager {

	/**
	 * Returns the current maximum number of colors.
	 * 
	 * @return the current maximum number of colors
	 */
	int getMaximumColors();



	/**
	 * Returns true if the specified color is currently selected.
	 * 
	 * @param color the ROI color index
	 * @return true if the specified color is currently selected
	 */
	boolean isSelected(int color);



	/**
	 * Returns true if the specified color is currently used.
	 * 
	 * @param color the ROI color index
	 * @return true if the specified color is currently used
	 */
	boolean isUsed(int color);
}
