
package edu.uthscsa.ric.mango;

/**
 * A SliceListener can be registered with a viewer and will be notified any time the slice position has been changed via the keyboard or mouse. This can be used
 * in conjuction with makePluginOverlay() in ViewerController to create a dynamic overlay graphic.
 */
public interface SliceListener {

	/**
	 * Notifies that a slice has changed.
	 * 
	 * @param slicePosition the new slice position
	 * @param sliceDirection the slice direction
	 * @param main true if the slice is the main (upper) slice, false otherwise
	 */
	void sliceChanged(int slicePosition, int sliceDirection, boolean main);
}
