
package edu.uthscsa.ric.mango;

/**
 * A meter that can be used to provide feedback to users about the progress of a process. The progress meter will appear in the application toolbox.
 */
public interface ProgressMeter {

	/**
	 * Returns the current value.
	 * 
	 * @return the current value
	 */
	int getCurrent();



	/**
	 * Returns the maximum value.
	 * 
	 * @return the maximum value
	 */
	int getMax();



	/**
	 * Returns the minimum value.
	 * 
	 * @return the minimum value
	 */
	int getMin();



	/**
	 * Sets the text of the progress meter.
	 * 
	 * @param des the text
	 */
	void setDescription(String des);



	/**
	 * Sets the indeterminate state (progress meter with no current value).
	 * 
	 * @param bool if true, the meter will be set to indeterminate state, false otherwise
	 */
	void setIndeterminateMode(boolean bool);



	/**
	 * Sets the current value of the meter. The meter will automatically end when the value is greater than or equal to getMax(). It is recommended that
	 * meter.setValue(meter.getMax()) is placed in a "finally" block to ensure the meter will always be quit.
	 * 
	 * @param val the current value of the meter
	 */
	void setValue(int val);



	/**
	 * Starts the progress meter. The meter will not appear until setValue() has been called at least once after approximately 100ms have elapsed. It may not
	 * appear at all if the duration is to be very short-lived.
	 * 
	 * @param min the minimum value of the meter
	 * @param current the current value of the meter
	 * @param max the maximum value of the meter
	 */
	void start(int min, int current, int max);



	/**
	 * Starts the progress meter. The meter will not appear until setValue() has been called at least once after approximately 100ms have elapsed. It may not
	 * appear at all if the duration is to be very short-lived.
	 * 
	 * @param min the minimum value of the meter
	 * @param current the current value of the meter
	 * @param max the maximum value of the meter
	 * @param forceStart starts immediately
	 */
	void start(int min, int current, int max, boolean forceStart);
}
