
package edu.uthscsa.ric.mango;

import java.net.URL;


public interface MangoPluginType {

	/**
	 * Returns the minimum version of Mango that will support this plugin (e.g., "2.5").
	 * 
	 * @return the minimum version
	 */
	String getMinimumVersionSupported();



	/**
	 * Returns the name of this plugin.
	 * 
	 * @return name of this plugin
	 */
	String getPluginName();



	/**
	 * Returns a URL to download this plugin.
	 * 
	 * @return a URL
	 */
	URL getPluginURL();



	/**
	 * Returns the version of this plugin (e.g., "1.0").
	 * 
	 * @return the version of this plugin
	 */
	String getVersion();



	/**
	 * Returns true if a newer version of this plugin exists. This method could, for example, check a database or web resource.
	 * 
	 * @return true if a newer version of this plugin exists
	 */
	boolean hasNewerVersion();
}
