
package edu.uthscsa.ric.mango;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;


/**
 * A MangoPlugin can extend the functionality of Mango.
 */
public interface MangoPlugin extends MangoPluginType {

	/**
	 * This is the method which Mango executes when a plugin is selected.
	 * 
	 * @param mango the application
	 * @param viewer the viewer
	 */
	void doOperation(MangoContext mango, VolumeManager viewer);



	/**
	 * This is the method which Mango executes when a plugin is selected.
	 * 
	 * @param data a MangoData provided to the plugin (contains image and ROI data)
	 * @param controller a ViewerController provided to the plugin (provides access to viewer and toolbox methods and settings)
	 * @deprecated
	 */
	@Deprecated
	void doOperation(MangoData data, ViewerController controller);
}
