
package edu.uthscsa.ric.mango;

import java.io.File;

import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.VoxelDimensions;


public class MangoImage {

	private final Coordinate nativeOrigin;
	private final Coordinate origin;
	private final File loadedFile;
	private final ImageDescription imageDescription;
	private final ImageDimensions imageDim;
	private final ImageRange imageRange;
	private final ImageTransform[] indexTransforms;
	private final ImageType imageType;
	private final ImageVolume image;
	private final ScreenImage screenImage;
	private final String description;
	private final String orientation;
	private final VoxelDimensions voxelDim;



	@Deprecated
	public MangoImage(final ImageVolume im, final ImageDimensions id, final VoxelDimensions vd, final ImageType it, final ImageRange ir,
			final ImageDescription in, final String des, final Coordinate origin, final Coordinate nativeOrigin, final ImageTransform[] ijk,
			final ScreenImage si, final File f, final String orientation) {
		this.image = im;
		this.imageDim = id;
		this.voxelDim = vd;
		this.imageType = it;
		this.imageRange = ir;
		this.imageDescription = in;
		this.description = des;
		this.origin = origin;
		this.nativeOrigin = nativeOrigin;
		this.indexTransforms = ijk;
		this.screenImage = si;
		this.loadedFile = f;
		this.orientation = orientation;
	}



	/**
	 * Returns a format-specific text description of the header data (a header dump).
	 * 
	 * @deprecated
	 * @return a format-specific text description of the header data (a header dump)
	 */
	@Deprecated
	public String getDescription() {
		return this.description;
	}



	/**
	 * Returns the ImageDescription.
	 * 
	 * @deprecated
	 * @return the ImageDescription
	 */
	@Deprecated
	public ImageDescription getImageDescription() {
		return this.imageDescription;
	}



	/**
	 * Returns the ImageDimensions.
	 * 
	 * @deprecated
	 * @return the ImageDimensions
	 */
	@Deprecated
	public ImageDimensions getImageDimensions() {
		return this.imageDim;
	}



	/**
	 * @deprecated Replaced by {@link #getTransforms()} Returns a ImageTransform array of all loaded image index transforms.
	 * @return a ImageTransform array of all loaded image index transforms
	 */
	@Deprecated
	public ImageTransform[] getImageIndexTransforms() {
		return this.indexTransforms;
	}



	/**
	 * Returns the ImageRange.
	 * 
	 * @deprecated
	 * @return the ImageRange
	 */
	@Deprecated
	public ImageRange getImageRange() {
		return this.imageRange;
	}



	/**
	 * Returns the ImageType.
	 * 
	 * @deprecated
	 * @return the ImageType
	 */
	@Deprecated
	public ImageType getImageType() {
		return this.imageType;
	}



	/**
	 * Returns the ImageVolume.
	 * 
	 * @deprecated
	 * @return the ImageVolume
	 */
	@Deprecated
	public ImageVolume getImageVolume() {
		return this.image;
	}



	/**
	 * @deprecated Replaced by {@link #getTransforms()} Returns a ImageTransform array of all loaded world transforms.
	 * @return a ImageTransform array of all loaded world transforms
	 */
	@Deprecated
	public ImageTransform[] getImageWorldTransforms() {
		return this.indexTransforms;
	}



	/**
	 * Returns the loaded file for this image.
	 * 
	 * @deprecated
	 * @return the loaded file for this image
	 */
	@Deprecated
	public File getLoadedFile() {
		return this.loadedFile;
	}



	/**
	 * Returns the origin in the image's native space.
	 * 
	 * @deprecated
	 * @return the origin
	 */
	@Deprecated
	public Coordinate getNativeOrigin() {
		return this.nativeOrigin;
	}



	/**
	 * Returns the orientation (e.g., XYZ+--)
	 * 
	 * @deprecated
	 * @return the orientation
	 */
	@Deprecated
	public String getOrientation() {
		return this.orientation;
	}



	/**
	 * Returns the origin Coordinate.
	 * 
	 * @deprecated
	 * @return the origin Coordinate
	 */
	@Deprecated
	public Coordinate getOrigin() {
		return this.origin;
	}



	/**
	 * Returns the ScreenImage.
	 * 
	 * @deprecated
	 * @return the ScreenImage
	 */
	@Deprecated
	public ScreenImage getScreenImage() {
		return this.screenImage;
	}



	/**
	 * Returns a ImageTransform array of all loaded transforms.
	 * 
	 * @deprecated
	 * @return a ImageTransform array of all loaded transforms
	 */
	@Deprecated
	public ImageTransform[] getTransforms() {
		return this.indexTransforms;
	}



	/**
	 * Returns the VoxelDimensions.
	 * 
	 * @deprecated
	 * @return the VoxelDimensions
	 */
	@Deprecated
	public VoxelDimensions getVoxelDimensions() {
		return this.voxelDim;
	}



	/**
	 * True if the image is being killed, false otherwise.
	 * 
	 * @deprecated
	 * @return was used to indicate volume was being deleted, now deprecated
	 */
	@Deprecated
	public boolean isBeingKilled() {
		return false;
	}
}
