
package edu.uthscsa.ric.mango;

import edu.uthscsa.ric.roi.ROIData;


/**
 * MangoData stores viewer image data. It provides access to base image data, overlays, and ROIs. If it is expected that viewer image data will change during
 * the execution of a plug-in (e.g., a user might load another overlay), an updated MangoData can be fetched via ViewerController. ViewerController can also be
 * used to fetch all currently open ViewerControllers, thereby giving access to MangoData from other viewers.
 */
public class MangoData {

	private final MangoImage baseImage;
	private final MangoImage[] overlays;
	private final ROIData roi;
	private final ScreenImage[] images;



	public MangoData(final MangoImage baseImage, final MangoImage[] overlays, final ScreenImage[] images, final ROIData roi) {
		this.baseImage = baseImage;
		this.overlays = overlays;
		this.images = images;
		this.roi = roi;
	}



	/**
	 * Returns the viewer base image (or first loaded image) as a MangoImage.
	 * 
	 * @deprecated
	 * @return the viewer base image
	 */
	@Deprecated
	public MangoImage getBaseImage() {
		return this.baseImage;
	}



	/**
	 * Returns the base ScreenImage. This is the same as getScreenImages()[0].
	 * 
	 * @return the base ScreenImage
	 */
	public ScreenImage getBaseScreenImage() {
		return this.images[0];
	}



	/**
	 * Returns a MangoImage array of loaded overlays.
	 * 
	 * @deprecated
	 * @return a MangoImage array of loaded overlays
	 */
	@Deprecated
	public MangoImage[] getOverlayImages() {
		return this.overlays;
	}



	/**
	 * Returns an array of overlay ScreenImages.
	 * 
	 * @return an array of overlay ScreenImages
	 */
	public ScreenImage[] getOverlayScreenImages() {
		if (this.images.length > 1) {
			final ScreenImage[] overlays = new ScreenImage[this.images.length - 1];
			for (int ctr = 1; ctr < this.images.length; ctr++) {
				overlays[ctr - 1] = this.images[ctr];
			}

			return overlays;
		}

		return new ScreenImage[0];
	}



	/**
	 * Returns the MangoROI associated with this viewer.
	 * 
	 * @deprecated
	 * @return the MangoROI associated with this viewer
	 */
	@Deprecated
	public MangoROI getROI() {
		return (MangoROI) this.roi;
	}



	/**
	 * Returns the ROIController associated with this viewer.
	 * 
	 * @return the ROIController associated with this viewer
	 */
	public ROIData getROIData() {
		return this.roi;
	}



	/**
	 * Returns the image stack, including base image and overlays.
	 * 
	 * @return the image stack
	 */
	public ScreenImage[] getScreenImages() {
		return this.images;
	}
}
