
package edu.uthscsa.ric.volume.formats.dicom;

import java.io.File;

import org.apache.commons.io.filefilter.IOFileFilter;

import edu.uthscsa.ric.utilities.CompressionUtilities;


public class DICOMFileFilter implements IOFileFilter {

	private final boolean allowDirectory;
	public static final String EXT_NIFTI = ".nii";
	public static final String EXT_NIFTI_GZ = ".nii.gz";
	public static final String EXT_AVW = ".hdr";
	public static final String EXT_DES = ".des";



	public DICOMFileFilter(final boolean allowDirectory) {
		this.allowDirectory = allowDirectory;
	}



	@Override
	public boolean accept(final File file) {
		if (file.isDirectory()) {
			if (allowDirectory) {
				return true;
			} else {
				return false;
			}
		}

		if (file.isHidden()) {
			return false;
		}

		final String name = file.getName().toLowerCase();

		if (name.startsWith(".")) {
			return false;
		}

		if (name.startsWith("_")) {
			return false;
		}

		if (name.equals("thumbs.db")) {
			return false;
		}

		if (name.endsWith(".zip")) {
			return false;
		}

		if (name.endsWith(".exe")) {
			return false;
		}

		if (name.endsWith(".dll")) {
			return false;
		}

		if (name.endsWith(".txt")) {
			return false;
		}

		if (name.endsWith(".inf")) {
			return false;
		}

		if (name.endsWith(CompressionUtilities.PREFERRED_GZIP_EXTENSION)) {
			return false;
		}

		if (name.endsWith(EXT_NIFTI)) {
			return false;
		}

		if (name.endsWith(EXT_NIFTI_GZ)) {
			return false;
		}

		if (name.endsWith(EXT_AVW)) {
			return false;
		}

		if (name.endsWith(EXT_DES)) {
			return false;
		}

		return true;
	}



	@Override
	public boolean accept(final File dir, final String name) {
		return accept(new File(dir, name));
	}
}
