
package edu.uthscsa.ric.utilities;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;


public final class SwingWidgetUtilities {

	private SwingWidgetUtilities() {}



	public static void colorBackgroundOfAllComponents(final Container con, final Color color) {
		colorBackgroundOfAllComponents(con, color, null);
	}



	public static void colorBackgroundOfAllComponents(final Container con, final Color color, final Class<?>[] excludeClasses) {
		if (con == null) {
			return;
		} else {
			if (excludeClasses == null) {
				con.setBackground(color);
			} else {
				boolean found = false;
				for (final Class<?> klass : excludeClasses) {
					if (klass.isInstance(con)) {
						found = true;
						break;
					}
				}

				if (!found) {
					con.setBackground(color);
				}
			}

			final Component[] children = con.getComponents();

			if ((children != null) && (children.length > 0)) {
				for (final Component element : children) {
					if (element instanceof Container) {
						colorBackgroundOfAllComponents((Container) element, color, excludeClasses);
					}
				}
			}
		}
	}



	public static void setFontOfAllComponents(final Container con, final Font font, final Class<?>[] excludeClasses) {
		if (con == null) {
			return;
		} else {
			if (excludeClasses == null) {
				con.setFont(font);
			} else {
				boolean found = false;
				for (final Class<?> klass : excludeClasses) {
					if (klass.isInstance(con)) {
						found = true;
						break;
					}
				}

				if (!found) {
					con.setFont(font);
				}
			}

			final Component[] children = con.getComponents();

			if ((children != null) && (children.length > 0)) {
				for (final Component element : children) {
					if (element instanceof Container) {
						setFontOfAllComponents((Container) element, font, excludeClasses);
					}
				}
			}
		}
	}



	public static void addMouseListenerToAllComponents(final Container con, final MouseListener ml) {
		if (con == null) {
			return;
		} else {
			if (con instanceof JComponent) {
				((JComponent) con).addMouseListener(ml);
			}

			final Component[] children = con.getComponents();

			if ((children != null) && (children.length > 0)) {
				for (final Component element : children) {
					if (element instanceof Container) {
						addMouseListenerToAllComponents((Container) element, ml);
					}
				}
			}
		}
	}



	public static Component findComponentOfType(final Component con, final Class<?> classType) {
		Component foundComp = null;

		if (con == null) {
			return null;
		} else {
			if (con instanceof Container) {
				final Component[] children = ((Container) con).getComponents();

				if ((children != null) && (children.length > 0)) {
					for (final Component element : children) {
						if (classType.isInstance(element)) {
							foundComp = element;
							break;
						} else {
							foundComp = findComponentOfType(element, classType);

							if (foundComp != null) {
								break;
							}
						}
					}
				}
			}
		}

		return foundComp;
	}



	public static void invokeAndWaitSafely(final Runnable runnable) {
		if (SwingUtilities.isEventDispatchThread()) {
			runnable.run();
		} else {
			try {
				SwingUtilities.invokeAndWait(runnable);
			} catch (final InterruptedException ex) {
				AppLogger.error(ex);
			} catch (final InvocationTargetException ex) {
				AppLogger.error(ex);
			}
		}
	}



	public static void invokeLaterSafely(final Runnable runnable) {
		if (SwingUtilities.isEventDispatchThread()) {
			runnable.run();
		} else {
			SwingUtilities.invokeLater(runnable);
		}
	}
}
