
package edu.uthscsa.ric.utilities;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;


public final class JVMUtilities {

	public static final String ADD_TO_CLASS_PATH_ERROR = "Error, could not add URL to system classloader";



	private JVMUtilities() {}



	public static void addFileToClassPath(final File file) throws IOException {
		addURLToClassPath(file.toURI().toURL());
	}



	// http://forum.java.sun.com/thread.jspa?threadID=707176
	public static void addLibraryDir(final String s) throws IOException {
		try {
			final Field field = ClassLoader.class.getDeclaredField("usr_paths");
			field.setAccessible(true);
			final String[] paths = (String[]) field.get(null);
			for (final String path : paths) {
				if (s.equals(path)) {
					return;
				}
			}

			final String[] tmp = new String[paths.length + 1];
			System.arraycopy(paths, 0, tmp, 0, paths.length);
			tmp[paths.length] = s;
			field.set(null, tmp);

			System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + s);
		} catch (final IllegalAccessException ex) {
			AppLogger.error(ex);
			throw new IOException("Failed to get permissions to set library path");
		} catch (final NoSuchFieldException ex) {
			AppLogger.error(ex);
			throw new IOException("Failed to get field handle to set library path");
		}
	}



	public static void clearGarbage() {
		System.gc(); // NOPMD
		System.gc(); // NOPMD
	}



	public static void forceExit() {
		System.exit(0);
	}



	// http://forum.java.sun.com/thread.jspa?threadID=300557
	private static void addURLToClassPath(final URL u) throws IOException {
		final URLClassLoader sysloader = (URLClassLoader) ClassLoader.getSystemClassLoader();
		final Class<URLClassLoader> sysclass = URLClassLoader.class;
		final Class<?>[] parameters = new Class[] { URL.class };

		try {
			final Method method = sysclass.getDeclaredMethod("addURL", parameters);
			method.setAccessible(true);
			method.invoke(sysloader, new Object[] { u });
		} catch (final InvocationTargetException ex) {
			AppLogger.error(ex);
			throw new IOException(ADD_TO_CLASS_PATH_ERROR);
		} catch (final IllegalArgumentException ex) {
			AppLogger.error(ex);
			throw new IOException(ADD_TO_CLASS_PATH_ERROR);
		} catch (final IllegalAccessException ex) {
			AppLogger.error(ex);
			throw new IOException(ADD_TO_CLASS_PATH_ERROR);
		} catch (final SecurityException ex) {
			AppLogger.error(ex);
			throw new IOException(ADD_TO_CLASS_PATH_ERROR);
		} catch (final NoSuchMethodException ex) {
			AppLogger.error(ex);
			throw new IOException(ADD_TO_CLASS_PATH_ERROR);
		}
	}
}
