
package edu.uthscsa.ric.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;


// http://www.avajava.com/tutorials/lessons/how-do-i-encrypt-and-decrypt-files-using-des.html
public class DesEncrypter {

	private final String passkey;



	public DesEncrypter(final String key) {
		passkey = key;
	}



	public void decrypt(final InputStream is, final OutputStream os) throws Throwable {
		encryptOrDecrypt(passkey, Cipher.DECRYPT_MODE, is, os);
	}



	public void encrypt(final InputStream is, final OutputStream os) throws Throwable {
		encryptOrDecrypt(passkey, Cipher.ENCRYPT_MODE, is, os);
	}



	private void doCopy(final InputStream is, final OutputStream os) throws IOException {
		final byte[] bytes = new byte[64];
		int numBytes;
		while ((numBytes = is.read(bytes)) != -1) {
			os.write(bytes, 0, numBytes);
		}
		os.flush();
		os.close();
		is.close();
	}



	private void encryptOrDecrypt(final String key, final int mode, final InputStream is, final OutputStream os) throws Throwable {
		final DESKeySpec dks = new DESKeySpec(key.getBytes());
		final SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
		final SecretKey desKey = skf.generateSecret(dks);
		final Cipher cipher = Cipher.getInstance("DES"); // DES/ECB/PKCS5Padding for SunJCE

		if (mode == Cipher.ENCRYPT_MODE) {
			cipher.init(Cipher.ENCRYPT_MODE, desKey);
			final CipherInputStream cis = new CipherInputStream(is, cipher);
			doCopy(cis, os);
		} else if (mode == Cipher.DECRYPT_MODE) {
			cipher.init(Cipher.DECRYPT_MODE, desKey);
			final CipherOutputStream cos = new CipherOutputStream(os, cipher);
			doCopy(is, cos);
		}
	}
}
