
package edu.uthscsa.ric.utilities;

//--------------------------------------
//Systematically generate combinations.
//--------------------------------------

/*
 * 	String[] elements = {"a", "b", "c", "d", "e", "f", "g"};
 int[] indices;
 CombinationGenerator x = new CombinationGenerator (elements.length, 3);
 StringBuffer combination;
 while (x.hasMore ()) {
 combination = new StringBuffer ();
 indices = x.getNext ();
 for (int i = 0; i < indices.length; i++) {
 combination.append (elements[indices[i]]);
 }
 System.out.println (combination.toString ());
 }
 * 
 */
import java.math.BigInteger;


// http://webcache.googleusercontent.com/search?q=cache:Oeomv3U4usEJ:www.merriampark.com/comb.htm+java+every+combination&cd=1&hl=en&ct=clnk&gl=us&source=www.google.com
public class CombinationGenerator {

	private BigInteger numLeft;

	private final BigInteger total;
	private final int n;
	private final int r;
	private final int[] a;



	// ------------------
	// Compute factorial
	// ------------------
	private static BigInteger getFactorial(final int n) {
		BigInteger fact = BigInteger.ONE;
		for (int i = n; i > 1; i--) {
			fact = fact.multiply(new BigInteger(Integer.toString(i)));
		}
		return fact;
	}



	// ------------
	// Constructor
	// ------------
	public CombinationGenerator(final int n, final int r) {
		if (r > n) {
			throw new IllegalArgumentException();
		}
		if (n < 1) {
			throw new IllegalArgumentException();
		}
		this.n = n;
		this.r = r;
		a = new int[r];
		final BigInteger nFact = getFactorial(n);
		final BigInteger rFact = getFactorial(r);
		final BigInteger nminusrFact = getFactorial(n - r);
		total = nFact.divide(rFact.multiply(nminusrFact));
		reset();
	}



	// --------------------------------------------------------
	// Generate next combination (algorithm from Rosen p. 286)
	// --------------------------------------------------------
	public int[] getNext() {
		if (numLeft.equals(total)) {
			numLeft = numLeft.subtract(BigInteger.ONE);
			return a;
		}

		int i = r - 1;
		while (a[i] == ((n - r) + i)) {
			i--;
		}
		a[i] = a[i] + 1;
		for (int j = i + 1; j < r; j++) {
			a[j] = (a[i] + j) - i;
		}

		numLeft = numLeft.subtract(BigInteger.ONE);
		return a;
	}



	// ------------------------------------------------
	// Return number of combinations not yet generated
	// ------------------------------------------------
	public BigInteger getNumLeft() {
		return numLeft;
	}



	// ------------------------------------
	// Return total number of combinations
	// ------------------------------------
	public BigInteger getTotal() {
		return total;
	}



	// -----------------------------
	// Are there more combinations?
	// -----------------------------
	public boolean hasMore() {
		return numLeft.compareTo(BigInteger.ZERO) == 1;
	}



	// ------
	// Reset
	// ------
	private void reset() {
		for (int i = 0; i < a.length; i++) {
			a[i] = i;
		}
		numLeft = new BigInteger(total.toString());
	}
}
