
package edu.uthscsa.ric.utilities;

import java.awt.Color;


public final class ColorUtilities {

	private ColorUtilities() {}



	public static Color createNiceHighlightColor(final Color color) {
		final int red = color.getRed();
		final int green = color.getGreen();
		final int blue = color.getBlue();
		final float hsbVals[] = Color.RGBtoHSB(red, green, blue, null);

		if ((hsbVals[2] > .75) && (hsbVals[1] < .45)) {
			return Color.WHITE;
		} else {
			return Color.getHSBColor(hsbVals[0], hsbVals[1] * 0.5f, 0.5f * (1f + hsbVals[2]));
		}
	}



	public static Color createNiceShadowColor(final Color color) {
		final int red = color.getRed();
		final int green = color.getGreen();
		final int blue = color.getBlue();
		final float hsbVals[] = Color.RGBtoHSB(red, green, blue, null);

		if (hsbVals[2] < 0.5) {
			return Color.BLACK;
		} else {
			return Color.getHSBColor(hsbVals[0], hsbVals[1], 0.5f * hsbVals[2]);
		}
	}



	public static String getHexRepresentation(final Color color) {
		return "#" + Integer.toHexString(color.getRGB()).substring(2);
	}
}
