/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;

public class DataAtomInputStream
extends FilterInputStream {
    protected static final long MAC_TIMESTAMP_EPOCH = new GregorianCalendar(1904, 0, 1).getTimeInMillis();
    private byte[] readBuffer = new byte[8];

    public DataAtomInputStream(InputStream in) {
        super(in);
    }

    public final byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    public final int readUByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public final int readUShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final long readUInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final long skipBytes(long n) throws IOException {
        long total = 0L;
        long cur = 0L;
        while (total < n && (cur = (long)((int)this.in.skip(n - total))) > 0L) {
            total += cur;
        }
        return total;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public Date readMacTimestamp() throws IOException {
        long timestamp = (long)this.readInt() & 0xFFFFFFFFL;
        return new Date(MAC_TIMESTAMP_EPOCH + timestamp * 1000L);
    }

    public double readFixed16D16() throws IOException {
        int wholePart = this.readUShort();
        int fractionPart = this.readUShort();
        return new Double((double)wholePart + (double)fractionPart / 65536.0);
    }

    public double readFixed2D30() throws IOException {
        int fixed = this.readInt();
        int wholePart = fixed >>> 30;
        int fractionPart = fixed & 0x3FFFFFFF;
        return new Double((double)wholePart + (double)fractionPart / 1.073741823E9);
    }

    public double readFixed8D8() throws IOException {
        int fixed = this.readUShort();
        int wholePart = fixed >>> 8;
        int fractionPart = fixed & 0xFF;
        return new Double((float)wholePart + (float)fractionPart / 256.0f);
    }

    public String readType() throws IOException {
        int id = this.readInt();
        byte[] b = new byte[]{(byte)(id >>> 24 & 0xFF), (byte)(id >>> 16 & 0xFF), (byte)(id >>> 8 & 0xFF), (byte)(id & 0xFF)};
        try {
            return new String(b, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public String readPString() throws IOException {
        int size = this.in.read();
        if (size == 0) {
            size = this.in.read();
            this.in.read();
            this.in.read();
        }
        if (size < 0) {
            return "";
        }
        byte[] b = new byte[size];
        int n = 0;
        while (n < size) {
            int count = this.in.read(b, n, size - n);
            if (count < 0) {
                System.out.println("StructParser.PrimitiveSpecifier.read not enough bytes for pstring. Expected size:" + size + " actual size:" + n);
                break;
            }
            n += count;
        }
        try {
            return new String(b, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }
}

