/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.monte.media.AbstractVideoCodecCore;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ByteArrayImageOutputStream;
import org.monte.media.io.UncachedImageInputStream;

public class TechSmithCodecCore
extends AbstractVideoCodecCore {
    private ByteArrayImageOutputStream temp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
    private byte[] temp2;
    private int[] palette;

    public TechSmithCodecCore() {
        this.reset();
    }

    public void reset() {
        this.palette = null;
    }

    public int[] getPalette() {
        if (this.palette == null) {
            this.palette = new int[256];
            int i = 0;
            while (i < this.palette.length) {
                this.palette[i] = i | i << 8 | i << 16;
                ++i;
            }
        }
        return this.palette;
    }

    public void decodePalette(byte[] inDat, int off, int len) throws IOException {
        this.getPalette();
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(inDat, off, len, ByteOrder.LITTLE_ENDIAN);
        int firstEntry = in.readUnsignedByte();
        int numEntries = in.readUnsignedByte();
        if (numEntries == 0) {
            numEntries = 256;
        }
        int flags = in.readUnsignedShort();
        if (firstEntry + numEntries > 256) {
            throw new IOException("Illegal headers in pc chunk. firstEntry=" + firstEntry + ", numEntries=" + numEntries);
        }
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        int i = 0;
        while (i < numEntries) {
            int rgbf = in.readInt();
            this.palette[i + firstEntry] = rgbf >> 8;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode8(byte[] inDat, int off, int length, byte[] outDat, byte[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block12: {
            if (length <= 2) {
                return false;
            }
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)));
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                continue block7;
                            }
                            case 1: {
                                break block12;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                continue block7;
                            }
                            default: {
                                in.readFully(outDat, xy, opcode);
                                xy += opcode;
                                if ((opcode & 1) != 1 || (pad = in.readByte() & 255) == 0) continue block7;
                                throw new IOException("Illegal pad byte, pad=0x" + Integer.toHexString(pad));
                            }
                        }
                    }
                    v = in.readByte();
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode8(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block14: {
            if (length <= 2) {
                return false;
            }
            if (this.temp2 == null || this.temp2.length < 255) {
                this.temp2 = new byte[255];
            }
            this.getPalette();
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)));
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                continue block7;
                            }
                            case 1: {
                                break block14;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                continue block7;
                            }
                            default: {
                                in.readFully(this.temp2, 0, opcode);
                                i = 0;
                                while (i < opcode) {
                                    outDat[xy + i] = this.palette[this.temp2[i] & 255];
                                    ++i;
                                }
                                xy += opcode;
                                if ((opcode & 1) != 1 || (pad = in.readByte() & 255) == 0) continue block7;
                                throw new IOException("Illegal pad byte, pad=0x" + Integer.toHexString(pad));
                            }
                        }
                    }
                    v = this.palette[in.readUnsignedByte()];
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode24(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block12: {
            if (length <= 2) {
                return false;
            }
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)));
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                break;
                            }
                            case 1: {
                                break block12;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                break;
                            }
                            default: {
                                this.readInts24LE(in, outDat, xy, opcode);
                                xy += opcode;
                                break;
                            }
                        }
                        continue;
                    }
                    v = this.readInt24LE(in);
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode16(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) throws IOException {
        block13: {
            if (length <= 2) {
                if (outDat != prevDat) {
                    System.arraycopy(prevDat, 0, outDat, 0, width * height);
                }
                return false;
            }
            in = new UncachedImageInputStream(new InflaterInputStream(new ByteArrayInputStream(inDat, off, length)), ByteOrder.LITTLE_ENDIAN);
            offset = 0;
            scanlineStride = width;
            upsideDown = (height - 1) * scanlineStride + offset;
            verticalOffset = false;
            isKeyFrame = true;
            try {
                y = 0;
                xy = upsideDown;
                block7: while (true) {
                    if ((opcode = in.readUnsignedByte()) == 0) {
                        opcode = in.readUnsignedByte();
                        switch (opcode) {
                            case 0: {
                                xy = (height - 1 - ++y) * scanlineStride + offset;
                                break;
                            }
                            case 1: {
                                break block13;
                            }
                            case 2: {
                                isKeyFrame = false;
                                dx = in.readUnsignedByte();
                                dy = in.readUnsignedByte();
                                y += dy;
                                end = xy + dx - dy * scanlineStride;
                                if (prevDat != outDat) {
                                    System.arraycopy(prevDat, xy, outDat, xy, end - xy);
                                }
                                xy = end;
                                break;
                            }
                            default: {
                                this.readRGBs555to24(in, outDat, xy, opcode);
                                xy += opcode;
                                break;
                            }
                        }
                        continue;
                    }
                    v = this.readRGB555to24(in);
                    end = xy + opcode;
                    while (true) {
                        if (xy < end) ** break;
                        continue block7;
                        outDat[xy] = v;
                        ++xy;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException t) {
                t.printStackTrace();
            }
        }
        in.close();
        return isKeyFrame;
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block19: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl25
                ++verticalOffset;
                break block19;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl25:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl26:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block20: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl57
                        ++literalCount;
                        break block20;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.temp.write(data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            this.temp.write(data, xy - literalCount, literalRun);
                            if ((literalRun & 1) == 1) {
                                this.temp.write(0);
                            }
                            literalCount -= literalRun;
lbl57:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl58:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.temp.write(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.temp.write(data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    this.temp.write(data, xy - literalCount, literalRun);
                    if ((literalRun & 1) == 1) {
                        this.temp.write(0);
                    }
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta8to24(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block19: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl25
                ++verticalOffset;
                break block19;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl25:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl26:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block20: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl60
                        ++literalCount;
                        break block20;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.writeInt24LE(this.temp, this.palette[data[xy - literalCount] & 255]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            i = xy - literalCount;
                            end = xy - literalCount + literalRun;
                            while (i < end) {
                                this.writeInt24LE(this.temp, this.palette[data[i] & 255]);
                                ++i;
                            }
                            literalCount -= literalRun;
lbl60:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl61:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.writeInt24LE(this.temp, this.palette[v & 255]);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, this.palette[data[xy - literalCount]]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    i = xy - literalCount;
                    end = xy - literalCount + literalRun;
                    while (i < end) {
                        this.writeInt24LE(this.temp, this.palette[data[i] & 255]);
                        ++i;
                    }
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void encodeSameDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeSameDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeSameDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                byte v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.temp.write(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.temp.write(data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            this.temp.write(data, xy - literalCount, literalCount);
                            if ((literalCount & 1) == 1) {
                                this.temp.write(0);
                            }
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.temp.write(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.temp.write(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.write(data, xy - literalCount, literalCount);
                    if ((literalCount & 1) == 1) {
                        this.temp.write(0);
                    }
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    public void encodeKey8to24(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                int end;
                int i;
                byte v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        i = xy - literalCount + 1;
                        end = xy + 1;
                        while (i < end) {
                            this.writeInt24LE(this.temp, this.palette[data[i] & 0xFF]);
                            ++i;
                        }
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.writeInt24LE(this.temp, this.palette[data[xy - literalCount] & 0xFF]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            i = xy - literalCount;
                            end = xy;
                            while (i < end) {
                                this.writeInt24LE(this.temp, this.palette[data[i] & 0xFF]);
                                ++i;
                            }
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.writeInt24LE(this.temp, this.palette[v & 0xFF]);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, this.palette[data[xy - literalCount] & 0xFF]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    int i = xy - literalCount;
                    int end = xy;
                    while (i < end) {
                        this.writeInt24LE(this.temp, this.palette[data[i] & 0xFF]);
                        ++i;
                    }
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block17: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl25
                ++verticalOffset;
                break block17;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl25:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl26:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block18: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl55
                        ++literalCount;
                        break block18;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.temp.writeShort(data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            this.temp.writeShorts(data, xy - literalCount, literalRun);
                            literalCount -= literalRun;
lbl55:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl56:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.temp.writeShort(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.temp.writeShort(data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    this.temp.writeShorts(data, xy - literalCount, literalRun);
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void encodeKey24(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                int v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.writeInts24LE(this.temp, data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.writeInt24LE(this.temp, data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            this.writeInts24LE(this.temp, data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.writeInt24LE(this.temp, v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.writeInts24LE(this.temp, data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block17: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl25
                ++verticalOffset;
                break block17;
lbl-1000:
                // 1 sources

                {
                    this.temp.write(0);
                    this.temp.write(2);
                    this.temp.write(Math.min(255, skipCount));
                    this.temp.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl25:
                    // 2 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl26:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block18: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl55
                        ++literalCount;
                        break block18;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                this.temp.write(1);
                                this.writeInt24LE(this.temp, data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            this.temp.write(0);
                            this.temp.write(literalRun);
                            this.writeInts24LE(this.temp, data, xy - literalCount, literalRun);
                            literalCount -= literalRun;
lbl55:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl56:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                this.temp.write(0);
                                this.temp.write(2);
                                this.temp.write(Math.min(255, skipCount));
                                this.temp.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            this.temp.write(repeatCount);
                            this.writeInt24LE(this.temp, v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    this.temp.write(0);
                    this.temp.write(literalRun);
                    this.writeInts24LE(this.temp, data, xy - literalCount, literalRun);
                    literalCount -= literalRun;
                }
                this.temp.write(0);
                this.temp.write(0);
            }
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            defl = new DeflaterOutputStream(out);
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void encodeKey16(OutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                short v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.temp.writeShorts(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                this.temp.write(1);
                                this.temp.writeShort(data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            this.temp.write(0);
                            this.temp.write(literalCount);
                            this.temp.writeShorts(data, xy - literalCount, literalCount);
                            literalCount = 0;
                        }
                    }
                    this.temp.write(repeatCount);
                    this.temp.writeShort(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.temp.writeShort(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.writeShorts(data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
            y += scanlineStride;
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out);
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    public void setPalette(byte[] redValues, byte[] greenValues, byte[] blueValues) {
        if (this.palette == null) {
            this.palette = new int[256];
        }
        int i = 0;
        while (i < 256) {
            this.palette[i] = (redValues[i] & 0xFF) << 16 | (greenValues[i] & 0xFF) << 8 | (blueValues[i] & 0xFF) << 0;
            ++i;
        }
    }
}

