/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.subject;

import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.subject.WsdlBindingSubject;
import javax.xml.namespace.QName;

public class PolicyMapKeyConverter {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyMapKeyConverter.class);
    private final QName serviceName;
    private final QName portName;

    public PolicyMapKeyConverter(QName qName, QName qName2) {
        this.serviceName = qName;
        this.portName = qName2;
    }

    public PolicyMapKey getPolicyMapKey(WsdlBindingSubject wsdlBindingSubject) {
        LOGGER.entering(wsdlBindingSubject);
        PolicyMapKey policyMapKey = null;
        if (wsdlBindingSubject.isBindingSubject()) {
            policyMapKey = PolicyMap.createWsdlEndpointScopeKey(this.serviceName, this.portName);
        } else if (wsdlBindingSubject.isBindingOperationSubject()) {
            policyMapKey = PolicyMap.createWsdlOperationScopeKey(this.serviceName, this.portName, wsdlBindingSubject.getName());
        } else if (wsdlBindingSubject.isBindingMessageSubject()) {
            policyMapKey = wsdlBindingSubject.getMessageType() == WsdlBindingSubject.WsdlMessageType.FAULT ? PolicyMap.createWsdlFaultMessageScopeKey(this.serviceName, this.portName, wsdlBindingSubject.getParent().getName(), wsdlBindingSubject.getName()) : PolicyMap.createWsdlMessageScopeKey(this.serviceName, this.portName, wsdlBindingSubject.getParent().getName());
        }
        LOGGER.exiting(policyMapKey);
        return policyMapKey;
    }
}

