/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.output.ImgWriter;

public class ImgWriterPGX
extends ImgWriter {
    int maxVal;
    int minVal;
    int levShift;
    boolean isSigned;
    private int bitDepth;
    private RandomAccessFile out;
    private int offset;
    private DataBlkInt db = new DataBlkInt();
    private int fb;
    private int c;
    private int packBytes;
    private byte[] buf;

    public ImgWriterPGX(File file, BlkImgDataSrc blkImgDataSrc, int n, boolean bl) throws IOException {
        this.c = n;
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(file, "rw");
        this.isSigned = bl;
        this.src = blkImgDataSrc;
        this.w = this.src.getImgWidth();
        this.h = this.src.getImgHeight();
        this.fb = blkImgDataSrc.getFixedPoint(n);
        this.bitDepth = this.src.getNomRangeBits(this.c);
        if (this.bitDepth <= 0 || this.bitDepth > 31) {
            throw new IOException("PGX supports only bit-depth between 1 and 31");
        }
        this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
        String string = "PG ML " + (this.isSigned ? "- " : "+ ") + this.bitDepth + " " + this.w + " " + this.h + "\n";
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            this.out.write(byArray[i]);
        }
        this.offset = byArray.length;
        this.maxVal = this.isSigned ? (1 << this.src.getNomRangeBits(n) - 1) - 1 : (1 << this.src.getNomRangeBits(n)) - 1;
        this.minVal = this.isSigned ? -1 * (1 << this.src.getNomRangeBits(n) - 1) : 0;
        this.levShift = this.isSigned ? 0 : 1 << this.src.getNomRangeBits(n) - 1;
    }

    public ImgWriterPGX(String string, BlkImgDataSrc blkImgDataSrc, int n, boolean bl) throws IOException {
        this(new File(string), blkImgDataSrc, n, bl);
    }

    @Override
    public void close() throws IOException {
        if (this.out.length() != (long)(this.w * this.h * this.packBytes + this.offset)) {
            this.out.seek(this.out.length());
            for (int i = this.offset + this.w * this.h * this.packBytes - (int)this.out.length(); i > 0; --i) {
                this.out.writeByte(0);
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    @Override
    public void flush() throws IOException {
        this.buf = null;
    }

    @Override
    public void write(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.fb;
        this.db.ulx = n;
        this.db.uly = n2;
        this.db.w = n3;
        this.db.h = n4;
        int n6 = this.src.getCompULX(this.c) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(this.c));
        int n7 = this.src.getCompULY(this.c) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(this.c));
        if (this.db.data != null && this.db.data.length < n3 * n4) {
            this.db.data = null;
        }
        do {
            this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.c);
        } while (this.db.progressive);
        if (this.buf == null || this.buf.length < this.packBytes * n3) {
            this.buf = new byte[this.packBytes * n3];
        }
        switch (this.packBytes) {
            case 1: {
                for (int i = 0; i < n4; ++i) {
                    int n8;
                    int n9;
                    int n10;
                    this.out.seek(this.offset + this.w * (n2 + n7 + i) + n + n6);
                    if (n5 == 0) {
                        n10 = this.db.offset + i * this.db.scanw + n3 - 1;
                        n9 = n3 - 1;
                        while (n9 >= 0) {
                            n8 = this.db.data[n10] + this.levShift;
                            this.buf[n9--] = (byte)(n8 < this.minVal ? this.minVal : (n8 > this.maxVal ? this.maxVal : n8));
                            --n10;
                        }
                    } else {
                        n10 = this.db.offset + i * this.db.scanw + n3 - 1;
                        n9 = n3 - 1;
                        while (n9 >= 0) {
                            n8 = (this.db.data[n10] >>> n5) + this.levShift;
                            this.buf[n9--] = (byte)(n8 < this.minVal ? this.minVal : (n8 > this.maxVal ? this.maxVal : n8));
                            --n10;
                        }
                    }
                    this.out.write(this.buf, 0, n3);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n4; ++i) {
                    int n11;
                    int n12;
                    int n13;
                    this.out.seek(this.offset + 2 * (this.w * (n2 + n7 + i) + n + n6));
                    if (n5 == 0) {
                        n13 = this.db.offset + i * this.db.scanw + n3 - 1;
                        n12 = (n3 << 1) - 1;
                        while (n12 >= 0) {
                            n11 = this.db.data[n13] + this.levShift;
                            n11 = n11 < this.minVal ? this.minVal : (n11 > this.maxVal ? this.maxVal : n11);
                            this.buf[n12--] = (byte)n11;
                            this.buf[n12--] = (byte)(n11 >>> 8);
                            --n13;
                        }
                    } else {
                        n13 = this.db.offset + i * this.db.scanw + n3 - 1;
                        n12 = (n3 << 1) - 1;
                        while (n12 >= 0) {
                            n11 = (this.db.data[n13] >>> n5) + this.levShift;
                            n11 = n11 < this.minVal ? this.minVal : (n11 > this.maxVal ? this.maxVal : n11);
                            this.buf[n12--] = (byte)n11;
                            this.buf[n12--] = (byte)(n11 >>> 8);
                            --n13;
                        }
                    }
                    this.out.write(this.buf, 0, n3 << 1);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n4; ++i) {
                    int n14;
                    int n15;
                    int n16;
                    this.out.seek(this.offset + 4 * (this.w * (n2 + n7 + i) + n + n6));
                    if (n5 == 0) {
                        n16 = this.db.offset + i * this.db.scanw + n3 - 1;
                        n15 = (n3 << 2) - 1;
                        while (n15 >= 0) {
                            n14 = this.db.data[n16] + this.levShift;
                            n14 = n14 < this.minVal ? this.minVal : (n14 > this.maxVal ? this.maxVal : n14);
                            this.buf[n15--] = (byte)n14;
                            this.buf[n15--] = (byte)(n14 >>> 8);
                            this.buf[n15--] = (byte)(n14 >>> 16);
                            this.buf[n15--] = (byte)(n14 >>> 24);
                            --n16;
                        }
                    } else {
                        n16 = this.db.offset + i * this.db.scanw + n3 - 1;
                        n15 = (n3 << 2) - 1;
                        while (n15 >= 0) {
                            n14 = (this.db.data[n16] >>> n5) + this.levShift;
                            n14 = n14 < this.minVal ? this.minVal : (n14 > this.maxVal ? this.maxVal : n14);
                            this.buf[n15--] = (byte)n14;
                            this.buf[n15--] = (byte)(n14 >>> 8);
                            this.buf[n15--] = (byte)(n14 >>> 16);
                            this.buf[n15--] = (byte)(n14 >>> 24);
                            --n16;
                        }
                    }
                    this.out.write(this.buf, 0, n3 << 2);
                }
                break;
            }
            default: {
                throw new IOException("PGX supports only bit-depth between 1 and 31");
            }
        }
    }

    @Override
    public void write() throws IOException {
        int n = this.src.getTileIdx();
        int n2 = this.src.getTileCompWidth(n, this.c);
        int n3 = this.src.getTileCompHeight(n, this.c);
        for (int i = 0; i < n3; i += 64) {
            this.write(0, i, n2, n3 - i < 64 ? n3 - i : 64);
        }
    }

    public String toString() {
        return "ImgWriterPGX: WxH = " + this.w + "x" + this.h + ", Component = " + this.c + ", Bit-depth = " + this.bitDepth + ", signed = " + this.isSigned + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }
}

