/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.forwcomptransf;

import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class ForwCompTransf
extends ImgDataAdapter
implements BlkImgDataSrc {
    public static final int NONE = 0;
    public static final int FORW_RCT = 1;
    public static final int FORW_ICT = 2;
    private BlkImgDataSrc src;
    private CompTransfSpec cts;
    private AnWTFilterSpec wfs;
    private int transfType = 0;
    private int[] tdepth;
    private DataBlk outBlk;
    private DataBlkInt block0;
    private DataBlkInt block1;
    private DataBlkInt block2;
    public static final char OPT_PREFIX = 'M';
    private static final String[][] pinfo = new String[][]{{"Mct", "[<tile index>] [on|off] ...", "Specifies in which tiles to use a multiple component transform. Note that this multiple component transform can only be applied in tiles that contain at least three components and whose components are processed with the same wavelet filters and quantization type. If the wavelet transform is reversible (w5x3 filter), the Reversible Component Transformation (RCT) is applied. If not (w9x7 filter), the Irreversible Component Transformation (ICT) is used.", null}};

    public ForwCompTransf(BlkImgDataSrc blkImgDataSrc, EncoderSpecs encoderSpecs) {
        super(blkImgDataSrc);
        this.cts = encoderSpecs.cts;
        this.wfs = encoderSpecs.wfs;
        this.src = blkImgDataSrc;
    }

    @Override
    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public static int[] calcMixedBitDepths(int[] nArray, int n, int[] nArray2) {
        if (nArray.length < 3 && n != 0) {
            throw new IllegalArgumentException();
        }
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        switch (n) {
            case 0: {
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                break;
            }
            case 1: {
                if (nArray.length > 3) {
                    System.arraycopy(nArray, 3, nArray2, 3, nArray.length - 3);
                }
                nArray2[0] = MathUtil.log2((1 << nArray[0]) + (2 << nArray[1]) + (1 << nArray[2]) - 1) - 2 + 1;
                nArray2[1] = MathUtil.log2((1 << nArray[2]) + (1 << nArray[1]) - 1) + 1;
                nArray2[2] = MathUtil.log2((1 << nArray[0]) + (1 << nArray[1]) - 1) + 1;
                break;
            }
            case 2: {
                if (nArray.length > 3) {
                    System.arraycopy(nArray, 3, nArray2, 3, nArray.length - 3);
                }
                nArray2[0] = MathUtil.log2((int)Math.floor((double)(1 << nArray[0]) * 0.299072 + (double)(1 << nArray[1]) * 0.586914 + (double)(1 << nArray[2]) * 0.114014) - 1) + 1;
                nArray2[1] = MathUtil.log2((int)Math.floor((double)(1 << nArray[0]) * 0.168701 + (double)(1 << nArray[1]) * 0.331299 + (double)(1 << nArray[2]) * 0.5) - 1) + 1;
                nArray2[2] = MathUtil.log2((int)Math.floor((double)(1 << nArray[0]) * 0.5 + (double)(1 << nArray[1]) * 0.418701 + (double)(1 << nArray[2]) * 0.081299) - 1) + 1;
            }
        }
        return nArray2;
    }

    private void initForwRCT() {
        int n = this.getTileIdx();
        if (this.src.getNumComps() < 3) {
            throw new IllegalArgumentException();
        }
        if (this.src.getTileCompWidth(n, 0) != this.src.getTileCompWidth(n, 1) || this.src.getTileCompWidth(n, 0) != this.src.getTileCompWidth(n, 2) || this.src.getTileCompHeight(n, 0) != this.src.getTileCompHeight(n, 1) || this.src.getTileCompHeight(n, 0) != this.src.getTileCompHeight(n, 2)) {
            throw new IllegalArgumentException("Can not use RCT on components with different dimensions");
        }
        int[] nArray = new int[this.src.getNumComps()];
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = this.src.getNomRangeBits(i);
        }
        this.tdepth = ForwCompTransf.calcMixedBitDepths(nArray, 1, null);
    }

    private void initForwICT() {
        int n = this.getTileIdx();
        if (this.src.getNumComps() < 3) {
            throw new IllegalArgumentException();
        }
        if (this.src.getTileCompWidth(n, 0) != this.src.getTileCompWidth(n, 1) || this.src.getTileCompWidth(n, 0) != this.src.getTileCompWidth(n, 2) || this.src.getTileCompHeight(n, 0) != this.src.getTileCompHeight(n, 1) || this.src.getTileCompHeight(n, 0) != this.src.getTileCompHeight(n, 2)) {
            throw new IllegalArgumentException("Can not use ICT on components with different dimensions");
        }
        int[] nArray = new int[this.src.getNumComps()];
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = this.src.getNomRangeBits(i);
        }
        this.tdepth = ForwCompTransf.calcMixedBitDepths(nArray, 2, null);
    }

    public String toString() {
        switch (this.transfType) {
            case 1: {
                return "Forward RCT";
            }
            case 2: {
                return "Forward ICT";
            }
            case 0: {
                return "No component transformation";
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    @Override
    public int getNomRangeBits(int n) {
        switch (this.transfType) {
            case 1: 
            case 2: {
                return this.tdepth[n];
            }
            case 0: {
                return this.src.getNomRangeBits(n);
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    public boolean isReversible() {
        switch (this.transfType) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        if (n >= 3 || this.transfType == 0) {
            return this.src.getCompData(dataBlk, n);
        }
        return this.getInternCompData(dataBlk, n);
    }

    @Override
    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        switch (this.transfType) {
            case 0: {
                return this.src.getInternCompData(dataBlk, n);
            }
            case 1: {
                return this.forwRCT(dataBlk, n);
            }
            case 2: {
                return this.forwICT(dataBlk, n);
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part 1 component transformation for tile: " + this.tIdx);
    }

    private DataBlk forwRCT(DataBlk dataBlk, int n) {
        int n2 = dataBlk.w;
        int n3 = dataBlk.h;
        if (n >= 0 && n <= 2) {
            int[] nArray;
            if (dataBlk.getDataType() != 3) {
                if (this.outBlk == null || this.outBlk.getDataType() != 3) {
                    this.outBlk = new DataBlkInt();
                }
                this.outBlk.w = n2;
                this.outBlk.h = n3;
                this.outBlk.ulx = dataBlk.ulx;
                this.outBlk.uly = dataBlk.uly;
                dataBlk = this.outBlk;
            }
            if ((nArray = (int[])dataBlk.getData()) == null || nArray.length < n3 * n2) {
                nArray = new int[n3 * n2];
                dataBlk.setData(nArray);
            }
            if (this.block0 == null) {
                this.block0 = new DataBlkInt();
            }
            if (this.block1 == null) {
                this.block1 = new DataBlkInt();
            }
            if (this.block2 == null) {
                this.block2 = new DataBlkInt();
            }
            this.block1.w = this.block2.w = dataBlk.w;
            this.block0.w = this.block2.w;
            this.block1.h = this.block2.h = dataBlk.h;
            this.block0.h = this.block2.h;
            this.block1.ulx = this.block2.ulx = dataBlk.ulx;
            this.block0.ulx = this.block2.ulx;
            this.block1.uly = this.block2.uly = dataBlk.uly;
            this.block0.uly = this.block2.uly;
            this.block0 = (DataBlkInt)this.src.getInternCompData(this.block0, 0);
            int[] nArray2 = (int[])this.block0.getData();
            this.block1 = (DataBlkInt)this.src.getInternCompData(this.block1, 1);
            int[] nArray3 = (int[])this.block1.getData();
            this.block2 = (DataBlkInt)this.src.getInternCompData(this.block2, 2);
            int[] nArray4 = (int[])this.block2.getData();
            dataBlk.progressive = this.block0.progressive || this.block1.progressive || this.block2.progressive;
            dataBlk.offset = 0;
            dataBlk.scanw = n2;
            int n4 = n2 * n3 - 1;
            int n5 = this.block0.offset + (n3 - 1) * this.block0.scanw + n2 - 1;
            int n6 = this.block1.offset + (n3 - 1) * this.block1.scanw + n2 - 1;
            int n7 = this.block2.offset + (n3 - 1) * this.block2.scanw + n2 - 1;
            switch (n) {
                case 0: {
                    for (int i = n3 - 1; i >= 0; --i) {
                        int n8 = n4 - n2;
                        while (n4 > n8) {
                            nArray[n4] = nArray2[n4] + 2 * nArray3[n4] + nArray4[n4] >> 2;
                            --n4;
                            --n5;
                            --n6;
                            --n7;
                        }
                        n5 -= this.block0.scanw - n2;
                        n6 -= this.block1.scanw - n2;
                        n7 -= this.block2.scanw - n2;
                    }
                    break;
                }
                case 1: {
                    for (int i = n3 - 1; i >= 0; --i) {
                        int n9 = n4 - n2;
                        while (n4 > n9) {
                            nArray[n4] = nArray4[n7] - nArray3[n6];
                            --n4;
                            --n6;
                            --n7;
                        }
                        n6 -= this.block1.scanw - n2;
                        n7 -= this.block2.scanw - n2;
                    }
                    break;
                }
                case 2: {
                    for (int i = n3 - 1; i >= 0; --i) {
                        int n10 = n4 - n2;
                        while (n4 > n10) {
                            nArray[n4] = nArray2[n5] - nArray3[n6];
                            --n4;
                            --n5;
                            --n6;
                        }
                        n5 -= this.block0.scanw - n2;
                        n6 -= this.block1.scanw - n2;
                    }
                    break;
                }
            }
        } else {
            if (n >= 3) {
                return this.src.getInternCompData(dataBlk, n);
            }
            throw new IllegalArgumentException();
        }
        return dataBlk;
    }

    private DataBlk forwICT(DataBlk dataBlk, int n) {
        float[] fArray;
        int n2 = dataBlk.w;
        int n3 = dataBlk.h;
        if (dataBlk.getDataType() != 4) {
            if (this.outBlk == null || this.outBlk.getDataType() != 4) {
                this.outBlk = new DataBlkFloat();
            }
            this.outBlk.w = n2;
            this.outBlk.h = n3;
            this.outBlk.ulx = dataBlk.ulx;
            this.outBlk.uly = dataBlk.uly;
            dataBlk = this.outBlk;
        }
        if ((fArray = (float[])dataBlk.getData()) == null || fArray.length < n2 * n3) {
            fArray = new float[n3 * n2];
            dataBlk.setData(fArray);
        }
        if (n >= 0 && n <= 2) {
            if (this.block0 == null) {
                this.block0 = new DataBlkInt();
            }
            if (this.block1 == null) {
                this.block1 = new DataBlkInt();
            }
            if (this.block2 == null) {
                this.block2 = new DataBlkInt();
            }
            this.block1.w = this.block2.w = dataBlk.w;
            this.block0.w = this.block2.w;
            this.block1.h = this.block2.h = dataBlk.h;
            this.block0.h = this.block2.h;
            this.block1.ulx = this.block2.ulx = dataBlk.ulx;
            this.block0.ulx = this.block2.ulx;
            this.block1.uly = this.block2.uly = dataBlk.uly;
            this.block0.uly = this.block2.uly;
            this.block0 = (DataBlkInt)this.src.getInternCompData(this.block0, 0);
            int[] nArray = (int[])this.block0.getData();
            this.block1 = (DataBlkInt)this.src.getInternCompData(this.block1, 1);
            int[] nArray2 = (int[])this.block1.getData();
            this.block2 = (DataBlkInt)this.src.getInternCompData(this.block2, 2);
            int[] nArray3 = (int[])this.block2.getData();
            dataBlk.progressive = this.block0.progressive || this.block1.progressive || this.block2.progressive;
            dataBlk.offset = 0;
            dataBlk.scanw = n2;
            int n4 = n2 * n3 - 1;
            int n5 = this.block0.offset + (n3 - 1) * this.block0.scanw + n2 - 1;
            int n6 = this.block1.offset + (n3 - 1) * this.block1.scanw + n2 - 1;
            int n7 = this.block2.offset + (n3 - 1) * this.block2.scanw + n2 - 1;
            switch (n) {
                case 0: {
                    for (int i = n3 - 1; i >= 0; --i) {
                        int n8 = n4 - n2;
                        while (n4 > n8) {
                            fArray[n4] = 0.299f * (float)nArray[n5] + 0.587f * (float)nArray2[n6] + 0.114f * (float)nArray3[n7];
                            --n4;
                            --n5;
                            --n6;
                            --n7;
                        }
                        n5 -= this.block0.scanw - n2;
                        n6 -= this.block1.scanw - n2;
                        n7 -= this.block2.scanw - n2;
                    }
                    break;
                }
                case 1: {
                    for (int i = n3 - 1; i >= 0; --i) {
                        int n9 = n4 - n2;
                        while (n4 > n9) {
                            fArray[n4] = -0.16875f * (float)nArray[n5] - 0.33126f * (float)nArray2[n6] + 0.5f * (float)nArray3[n7];
                            --n4;
                            --n5;
                            --n6;
                            --n7;
                        }
                        n5 -= this.block0.scanw - n2;
                        n6 -= this.block1.scanw - n2;
                        n7 -= this.block2.scanw - n2;
                    }
                    break;
                }
                case 2: {
                    for (int i = n3 - 1; i >= 0; --i) {
                        int n10 = n4 - n2;
                        while (n4 > n10) {
                            fArray[n4] = 0.5f * (float)nArray[n5] - 0.41869f * (float)nArray2[n6] - 0.08131f * (float)nArray3[n7];
                            --n4;
                            --n5;
                            --n6;
                            --n7;
                        }
                        n5 -= this.block0.scanw - n2;
                        n6 -= this.block1.scanw - n2;
                        n7 -= this.block2.scanw - n2;
                    }
                    break;
                }
            }
        } else {
            if (n >= 3) {
                DataBlkInt dataBlkInt = new DataBlkInt(dataBlk.ulx, dataBlk.uly, n2, n3);
                this.src.getInternCompData(dataBlkInt, n);
                int[] nArray = (int[])dataBlkInt.getData();
                int n11 = n2 * n3 - 1;
                int n12 = dataBlkInt.offset + (n3 - 1) * dataBlkInt.scanw + n2 - 1;
                for (int i = n3 - 1; i >= 0; --i) {
                    int n13 = n11 - n2;
                    while (n11 > n13) {
                        fArray[n11] = nArray[n12];
                        --n11;
                        --n12;
                    }
                    n12 += dataBlkInt.w - n2;
                }
                dataBlk.progressive = dataBlkInt.progressive;
                dataBlk.offset = 0;
                dataBlk.scanw = n2;
                return dataBlk;
            }
            throw new IllegalArgumentException();
        }
        return dataBlk;
    }

    @Override
    public void setTile(int n, int n2) {
        this.src.setTile(n, n2);
        this.tIdx = this.getTileIdx();
        String string = (String)this.cts.getTileDef(this.tIdx);
        if (string.equals("none")) {
            this.transfType = 0;
        } else if (string.equals("rct")) {
            this.transfType = 1;
            this.initForwRCT();
        } else if (string.equals("ict")) {
            this.transfType = 2;
            this.initForwICT();
        } else {
            throw new IllegalArgumentException("Component transformation not recognized");
        }
    }

    @Override
    public void nextTile() {
        this.src.nextTile();
        this.tIdx = this.getTileIdx();
        String string = (String)this.cts.getTileDef(this.tIdx);
        if (string.equals("none")) {
            this.transfType = 0;
        } else if (string.equals("rct")) {
            this.transfType = 1;
            this.initForwRCT();
        } else if (string.equals("ict")) {
            this.transfType = 2;
            this.initForwICT();
        } else {
            throw new IllegalArgumentException("Component transformation not recognized");
        }
    }
}

