/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.decoder;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.ByteInputBuffer;
import jj2000.j2k.entropy.decoder.ByteToBitInput;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.entropy.decoder.MQDecoder;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class StdEntropyDecoder
extends EntropyDecoder
implements StdEntropyCoderOptions {
    private static final boolean DO_TIMING = false;
    private long[] time;
    private ByteToBitInput bin;
    private MQDecoder mq;
    private DecoderSpecs decSpec;
    private int options;
    private final boolean doer;
    private final boolean verber;
    private static final int ZC_LUT_BITS = 8;
    private static final int[] ZC_LUT_LH;
    private static final int[] ZC_LUT_HL;
    private static final int[] ZC_LUT_HH;
    private static final int SC_LUT_BITS = 9;
    private static final int[] SC_LUT;
    private static final int SC_LUT_MASK = 15;
    private static final int SC_SPRED_SHIFT = 31;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;
    private static final int MR_LUT_BITS = 9;
    private static final int[] MR_LUT;
    private static final int NUM_CTXTS = 19;
    private static final int RLC_CTXT = 1;
    private static final int UNIF_CTXT = 0;
    private static final int[] MQ_INIT;
    private static final int SEG_SYMBOL = 10;
    private final int[] state;
    private static final int STATE_SEP = 16;
    private static final int STATE_SIG_R1 = 32768;
    private static final int STATE_VISITED_R1 = 16384;
    private static final int STATE_NZ_CTXT_R1 = 8192;
    private static final int STATE_H_L_SIGN_R1 = 4096;
    private static final int STATE_H_R_SIGN_R1 = 2048;
    private static final int STATE_V_U_SIGN_R1 = 1024;
    private static final int STATE_V_D_SIGN_R1 = 512;
    private static final int STATE_PREV_MR_R1 = 256;
    private static final int STATE_H_L_R1 = 128;
    private static final int STATE_H_R_R1 = 64;
    private static final int STATE_V_U_R1 = 32;
    private static final int STATE_V_D_R1 = 16;
    private static final int STATE_D_UL_R1 = 8;
    private static final int STATE_D_UR_R1 = 4;
    private static final int STATE_D_DL_R1 = 2;
    private static final int STATE_D_DR_R1 = 1;
    private static final int STATE_SIG_R2 = Integer.MIN_VALUE;
    private static final int STATE_VISITED_R2 = 0x40000000;
    private static final int STATE_NZ_CTXT_R2 = 0x20000000;
    private static final int STATE_H_L_SIGN_R2 = 0x10000000;
    private static final int STATE_H_R_SIGN_R2 = 0x8000000;
    private static final int STATE_V_U_SIGN_R2 = 0x4000000;
    private static final int STATE_V_D_SIGN_R2 = 0x2000000;
    private static final int STATE_PREV_MR_R2 = 0x1000000;
    private static final int STATE_H_L_R2 = 0x800000;
    private static final int STATE_H_R_R2 = 0x400000;
    private static final int STATE_V_U_R2 = 0x200000;
    private static final int STATE_V_D_R2 = 0x100000;
    private static final int STATE_D_UL_R2 = 524288;
    private static final int STATE_D_UR_R2 = 262144;
    private static final int STATE_D_DL_R2 = 131072;
    private static final int STATE_D_DR_R2 = 65536;
    private static final int SIG_MASK_R1R2 = -2147450880;
    private static final int VSTD_MASK_R1R2 = 0x40004000;
    private static final int RLC_MASK_R1R2 = -536813568;
    private static final int ZC_MASK = 255;
    private static final int SC_SHIFT_R1 = 4;
    private static final int SC_SHIFT_R2 = 20;
    private static final int SC_MASK = 511;
    private static final int MR_MASK = 511;
    private DecLyrdCBlk srcblk;
    private int mQuit;

    public StdEntropyDecoder(CodedCBlkDataSrcDec codedCBlkDataSrcDec, DecoderSpecs decoderSpecs, boolean bl, boolean bl2, int n) {
        super(codedCBlkDataSrcDec);
        this.decSpec = decoderSpecs;
        this.doer = bl;
        this.verber = bl2;
        this.mQuit = n;
        this.state = new int[(decoderSpecs.cblks.getMaxCBlkWidth() + 2) * ((decoderSpecs.cblks.getMaxCBlkHeight() + 1) / 2 + 2)];
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public DataBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, DataBlk dataBlk) {
        boolean bl;
        int[] nArray;
        long l = 0L;
        ByteInputBuffer byteInputBuffer = null;
        this.srcblk = this.src.getCodeBlock(n, n2, n3, subbandSyn, 1, -1, this.srcblk);
        this.options = (Integer)this.decSpec.ecopts.getTileCompVal(this.tIdx, n);
        ArrayUtil.intArraySet(this.state, 0);
        if (dataBlk == null) {
            dataBlk = new DataBlkInt();
        }
        dataBlk.progressive = this.srcblk.prog;
        dataBlk.ulx = this.srcblk.ulx;
        dataBlk.uly = this.srcblk.uly;
        dataBlk.w = this.srcblk.w;
        dataBlk.h = this.srcblk.h;
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        int[] nArray2 = (int[])dataBlk.getData();
        if (nArray2 == null || nArray2.length < this.srcblk.w * this.srcblk.h) {
            nArray2 = new int[this.srcblk.w * this.srcblk.h];
            dataBlk.setData(nArray2);
        } else {
            ArrayUtil.intArraySet(nArray2, 0);
        }
        if (this.srcblk.nl <= 0 || this.srcblk.nTrunc <= 0) {
            return dataBlk;
        }
        int n4 = this.srcblk.tsLengths == null ? this.srcblk.dl : this.srcblk.tsLengths[0];
        int n5 = 0;
        int n6 = this.srcblk.nTrunc;
        if (this.mq == null) {
            byteInputBuffer = new ByteInputBuffer(this.srcblk.data, 0, n4);
            this.mq = new MQDecoder(byteInputBuffer, 19, MQ_INIT);
        } else {
            this.mq.nextSegment(this.srcblk.data, 0, n4);
            this.mq.resetCtxts();
        }
        boolean bl2 = false;
        if ((this.options & 1) != 0 && this.bin == null) {
            if (byteInputBuffer == null) {
                byteInputBuffer = this.mq.getByteInputBuffer();
            }
            this.bin = new ByteToBitInput(byteInputBuffer);
        }
        switch (subbandSyn.orientation) {
            case 1: {
                nArray = ZC_LUT_HL;
                break;
            }
            case 0: 
            case 2: {
                nArray = ZC_LUT_LH;
                break;
            }
            case 3: {
                nArray = ZC_LUT_HH;
                break;
            }
            default: {
                throw new Error("JJ2000 internal error");
            }
        }
        int n7 = 30 - this.srcblk.skipMSBP;
        if (this.mQuit != -1 && this.mQuit * 3 - 2 < n6) {
            n6 = this.mQuit * 3 - 2;
        }
        if (n7 >= 0 && n6 > 0) {
            bl = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP >= n7;
            bl2 = this.cleanuppass(dataBlk, this.mq, n7, this.state, nArray, bl);
            --n6;
            if (!bl2 || !this.doer) {
                --n7;
            }
        }
        if (!bl2 || !this.doer) {
            while (n7 >= 0 && n6 > 0) {
                if ((this.options & 1) != 0 && n7 < 27 - this.srcblk.skipMSBP) {
                    this.bin.setByteArray(null, -1, this.srcblk.tsLengths[++n5]);
                    bl = (this.options & 4) != 0;
                    bl2 = this.rawSigProgPass(dataBlk, this.bin, n7, this.state, bl);
                    if (--n6 <= 0 || bl2 && this.doer) break;
                    if ((this.options & 4) != 0) {
                        this.bin.setByteArray(null, -1, this.srcblk.tsLengths[++n5]);
                    }
                    bl = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP > n7;
                    bl2 = this.rawMagRefPass(dataBlk, this.bin, n7, this.state, bl);
                } else {
                    if ((this.options & 4) != 0) {
                        this.mq.nextSegment(null, -1, this.srcblk.tsLengths[++n5]);
                    }
                    bl = (this.options & 4) != 0;
                    bl2 = this.sigProgPass(dataBlk, this.mq, n7, this.state, nArray, bl);
                    if (--n6 <= 0 || bl2 && this.doer) break;
                    if ((this.options & 4) != 0) {
                        this.mq.nextSegment(null, -1, this.srcblk.tsLengths[++n5]);
                    }
                    bl = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP > n7;
                    bl2 = this.magRefPass(dataBlk, this.mq, n7, this.state, bl);
                }
                if (--n6 <= 0 || bl2 && this.doer) break;
                if ((this.options & 4) != 0 || (this.options & 1) != 0 && n7 < 27 - this.srcblk.skipMSBP) {
                    this.mq.nextSegment(null, -1, this.srcblk.tsLengths[++n5]);
                }
                bl = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP >= n7;
                bl2 = this.cleanuppass(dataBlk, this.mq, n7, this.state, nArray, bl);
                --n6;
                if (bl2 && this.doer) break;
                --n7;
            }
        }
        if (bl2 && this.doer) {
            if (this.verber) {
                FacilityManager.getMsgLogger().printmsg(2, "Error detected at bit-plane " + n7 + " in code-block (" + n2 + "," + n3 + "), sb_idx " + subbandSyn.sbandIdx + ", res. level " + subbandSyn.resLvl + ". Concealing...");
            }
            this.conceal(dataBlk, n7);
        }
        return dataBlk;
    }

    @Override
    public DataBlk getInternCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, DataBlk dataBlk) {
        return this.getCodeBlock(n, n2, n3, subbandSyn, dataBlk);
    }

    /*
     * Unable to fully structure code
     */
    private boolean sigProgPass(DataBlk var1_1, MQDecoder var2_2, int var3_3, int[] var4_4, int[] var5_5, boolean var6_6) {
        var11_7 = var1_1.scanw;
        var12_8 = var1_1.w + 2;
        var13_9 = var12_8 * 4 / 2 - var1_1.w;
        var14_10 = var11_7 * 4 - var1_1.w;
        var17_11 = 3 << var3_3 >> 1;
        var20_12 = (int[])var1_1.getData();
        var23_13 = (var1_1.h + 4 - 1) / 4;
        var22_14 = (this.options & 8) != 0;
        var25_15 = -var12_8 - 1;
        var26_16 = -var12_8 + 1;
        var27_17 = var12_8 + 1;
        var28_18 = var12_8 - 1;
        var10_19 = var1_1.offset;
        var8_20 = var12_8 + 1;
        var21_21 = var23_13 - 1;
        while (var21_21 >= 0) {
            var24_28 = var21_21 != 0 ? 4 : var1_1.h - (var23_13 - 1) * 4;
            var15_24 = var10_19 + var1_1.w;
            while (var10_19 < var15_24) {
                var7_22 = var8_20;
                var16_25 = var4_4[var7_22];
                if ((~var16_25 & var16_25 << 2 & -2147450880) == 0) ** GOTO lbl86
                var9_23 = var10_19;
                if ((var16_25 & 40960) == 8192) {
                    if (var2_2.decodeSymbol(var5_5[var16_25 & 255]) != 0) {
                        var19_27 = StdEntropyDecoder.SC_LUT[var16_25 >>> 4 & 511];
                        var18_26 = var2_2.decodeSymbol(var19_27 & 15) ^ var19_27 >>> 31;
                        var20_12[var9_23] = var18_26 << 31 | var17_11;
                        if (!var22_14) {
                            v0 = var7_22 + var25_15;
                            var4_4[v0] = var4_4[v0] | 0x20010000;
                            v1 = var7_22 + var26_16;
                            var4_4[v1] = var4_4[v1] | 0x20020000;
                        }
                        if (var18_26 != 0) {
                            var16_25 |= 606126080;
                            if (!var22_14) {
                                v2 = var7_22 - var12_8;
                                var4_4[v2] = var4_4[v2] | 0x22100000;
                            }
                            v3 = var7_22 + 1;
                            var4_4[v3] = var4_4[v3] | 537407616;
                            v4 = var7_22 - 1;
                            var4_4[v4] = var4_4[v4] | 537143360;
                        } else {
                            var16_25 |= 0x2020C000;
                            if (!var22_14) {
                                v5 = var7_22 - var12_8;
                                var4_4[v5] = var4_4[v5] | 0x20100000;
                            }
                            v6 = var7_22 + 1;
                            var4_4[v6] = var4_4[v6] | 0x20082080;
                            v7 = var7_22 - 1;
                            var4_4[v7] = var4_4[v7] | 0x20042040;
                        }
                    } else {
                        var16_25 |= 16384;
                    }
                }
                if (var24_28 < 2) {
                    var4_4[var7_22] = var16_25;
                } else {
                    if ((var16_25 & -1610612736) == 0x20000000) {
                        var9_23 += var11_7;
                        if (var2_2.decodeSymbol(var5_5[var16_25 >>> 16 & 255]) != 0) {
                            var19_27 = StdEntropyDecoder.SC_LUT[var16_25 >>> 20 & 511];
                            var18_26 = var2_2.decodeSymbol(var19_27 & 15) ^ var19_27 >>> 31;
                            var20_12[var9_23] = var18_26 << 31 | var17_11;
                            v8 = var7_22 + var28_18;
                            var4_4[v8] = var4_4[v8] | 8196;
                            v9 = var7_22 + var27_17;
                            var4_4[v9] = var4_4[v9] | 8200;
                            if (var18_26 != 0) {
                                var16_25 |= -1073733104;
                                v10 = var7_22 + var12_8;
                                var4_4[v10] = var4_4[v10] | 9248;
                                v11 = var7_22 + 1;
                                var4_4[v11] = var4_4[v11] | 813703170;
                                v12 = var7_22 - 1;
                                var4_4[v12] = var4_4[v12] | 675291137;
                            } else {
                                var16_25 |= -1073733616;
                                v13 = var7_22 + var12_8;
                                var4_4[v13] = var4_4[v13] | 8224;
                                v14 = var7_22 + 1;
                                var4_4[v14] = var4_4[v14] | 0x20802002;
                                v15 = var7_22 - 1;
                                var4_4[v15] = var4_4[v15] | 541073409;
                            }
                        } else {
                            var16_25 |= 0x40000000;
                        }
                    }
                    var4_4[var7_22] = var16_25;
lbl86:
                    // 2 sources

                    if (var24_28 >= 3 && (~(var16_25 = var4_4[var7_22 += var12_8]) & var16_25 << 2 & -2147450880) != 0) {
                        var9_23 = var10_19 + (var11_7 << 1);
                        if ((var16_25 & 40960) == 8192) {
                            if (var2_2.decodeSymbol(var5_5[var16_25 & 255]) != 0) {
                                var19_27 = StdEntropyDecoder.SC_LUT[var16_25 >>> 4 & 511];
                                var18_26 = var2_2.decodeSymbol(var19_27 & 15) ^ var19_27 >>> 31;
                                var20_12[var9_23] = var18_26 << 31 | var17_11;
                                v16 = var7_22 + var25_15;
                                var4_4[v16] = var4_4[v16] | 0x20010000;
                                v17 = var7_22 + var26_16;
                                var4_4[v17] = var4_4[v17] | 0x20020000;
                                if (var18_26 != 0) {
                                    var16_25 |= 606126080;
                                    v18 = var7_22 - var12_8;
                                    var4_4[v18] = var4_4[v18] | 0x22100000;
                                    v19 = var7_22 + 1;
                                    var4_4[v19] = var4_4[v19] | 537407616;
                                    v20 = var7_22 - 1;
                                    var4_4[v20] = var4_4[v20] | 537143360;
                                } else {
                                    var16_25 |= 0x2020C000;
                                    v21 = var7_22 - var12_8;
                                    var4_4[v21] = var4_4[v21] | 0x20100000;
                                    v22 = var7_22 + 1;
                                    var4_4[v22] = var4_4[v22] | 0x20082080;
                                    v23 = var7_22 - 1;
                                    var4_4[v23] = var4_4[v23] | 0x20042040;
                                }
                            } else {
                                var16_25 |= 16384;
                            }
                        }
                        if (var24_28 < 4) {
                            var4_4[var7_22] = var16_25;
                        } else {
                            if ((var16_25 & -1610612736) == 0x20000000) {
                                var9_23 += var11_7;
                                if (var2_2.decodeSymbol(var5_5[var16_25 >>> 16 & 255]) != 0) {
                                    var19_27 = StdEntropyDecoder.SC_LUT[var16_25 >>> 20 & 511];
                                    var18_26 = var2_2.decodeSymbol(var19_27 & 15) ^ var19_27 >>> 31;
                                    var20_12[var9_23] = var18_26 << 31 | var17_11;
                                    v24 = var7_22 + var28_18;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var7_22 + var27_17;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var18_26 != 0) {
                                        var16_25 |= -1073733104;
                                        v26 = var7_22 + var12_8;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var7_22 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var7_22 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var16_25 |= -1073733616;
                                        v29 = var7_22 + var12_8;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var7_22 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var7_22 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                } else {
                                    var16_25 |= 0x40000000;
                                }
                            }
                            var4_4[var7_22] = var16_25;
                        }
                    }
                }
                ++var10_19;
                ++var8_20;
            }
            --var21_21;
            var10_19 += var14_10;
            var8_20 += var13_9;
        }
        var29_29 = false;
        if (var6_6 && (this.options & 16) != 0) {
            var29_29 = var2_2.checkPredTerm();
        }
        if ((this.options & 2) != 0) {
            var2_2.resetCtxts();
        }
        return var29_29;
    }

    /*
     * Unable to fully structure code
     */
    private boolean rawSigProgPass(DataBlk var1_1, ByteToBitInput var2_2, int var3_3, int[] var4_4, boolean var5_5) {
        var10_6 = var1_1.scanw;
        var11_7 = var1_1.w + 2;
        var12_8 = var11_7 * 4 / 2 - var1_1.w;
        var13_9 = var10_6 * 4 - var1_1.w;
        var16_10 = 3 << var3_3 >> 1;
        var18_11 = (int[])var1_1.getData();
        var21_12 = (var1_1.h + 4 - 1) / 4;
        var20_13 = (this.options & 8) != 0;
        var23_14 = -var11_7 - 1;
        var24_15 = -var11_7 + 1;
        var25_16 = var11_7 + 1;
        var26_17 = var11_7 - 1;
        var9_18 = var1_1.offset;
        var7_19 = var11_7 + 1;
        var19_20 = var21_12 - 1;
        while (var19_20 >= 0) {
            var22_26 = var19_20 != 0 ? 4 : var1_1.h - (var21_12 - 1) * 4;
            var14_23 = var9_18 + var1_1.w;
            while (var9_18 < var14_23) {
                var6_21 = var7_19;
                var15_24 = var4_4[var6_21];
                if ((~var15_24 & var15_24 << 2 & -2147450880) == 0) ** GOTO lbl84
                var8_22 = var9_18;
                if ((var15_24 & 40960) == 8192) {
                    if (var2_2.readBit() != 0) {
                        var17_25 = var2_2.readBit();
                        var18_11[var8_22] = var17_25 << 31 | var16_10;
                        if (!var20_13) {
                            v0 = var6_21 + var23_14;
                            var4_4[v0] = var4_4[v0] | 0x20010000;
                            v1 = var6_21 + var24_15;
                            var4_4[v1] = var4_4[v1] | 0x20020000;
                        }
                        if (var17_25 != 0) {
                            var15_24 |= 606126080;
                            if (!var20_13) {
                                v2 = var6_21 - var11_7;
                                var4_4[v2] = var4_4[v2] | 0x22100000;
                            }
                            v3 = var6_21 + 1;
                            var4_4[v3] = var4_4[v3] | 537407616;
                            v4 = var6_21 - 1;
                            var4_4[v4] = var4_4[v4] | 537143360;
                        } else {
                            var15_24 |= 0x2020C000;
                            if (!var20_13) {
                                v5 = var6_21 - var11_7;
                                var4_4[v5] = var4_4[v5] | 0x20100000;
                            }
                            v6 = var6_21 + 1;
                            var4_4[v6] = var4_4[v6] | 0x20082080;
                            v7 = var6_21 - 1;
                            var4_4[v7] = var4_4[v7] | 0x20042040;
                        }
                    } else {
                        var15_24 |= 16384;
                    }
                }
                if (var22_26 < 2) {
                    var4_4[var6_21] = var15_24;
                } else {
                    if ((var15_24 & -1610612736) == 0x20000000) {
                        var8_22 += var10_6;
                        if (var2_2.readBit() != 0) {
                            var17_25 = var2_2.readBit();
                            var18_11[var8_22] = var17_25 << 31 | var16_10;
                            v8 = var6_21 + var26_17;
                            var4_4[v8] = var4_4[v8] | 8196;
                            v9 = var6_21 + var25_16;
                            var4_4[v9] = var4_4[v9] | 8200;
                            if (var17_25 != 0) {
                                var15_24 |= -1073733104;
                                v10 = var6_21 + var11_7;
                                var4_4[v10] = var4_4[v10] | 9248;
                                v11 = var6_21 + 1;
                                var4_4[v11] = var4_4[v11] | 813703170;
                                v12 = var6_21 - 1;
                                var4_4[v12] = var4_4[v12] | 675291137;
                            } else {
                                var15_24 |= -1073733616;
                                v13 = var6_21 + var11_7;
                                var4_4[v13] = var4_4[v13] | 8224;
                                v14 = var6_21 + 1;
                                var4_4[v14] = var4_4[v14] | 0x20802002;
                                v15 = var6_21 - 1;
                                var4_4[v15] = var4_4[v15] | 541073409;
                            }
                        } else {
                            var15_24 |= 0x40000000;
                        }
                    }
                    var4_4[var6_21] = var15_24;
lbl84:
                    // 2 sources

                    if (var22_26 >= 3 && (~(var15_24 = var4_4[var6_21 += var11_7]) & var15_24 << 2 & -2147450880) != 0) {
                        var8_22 = var9_18 + (var10_6 << 1);
                        if ((var15_24 & 40960) == 8192) {
                            if (var2_2.readBit() != 0) {
                                var17_25 = var2_2.readBit();
                                var18_11[var8_22] = var17_25 << 31 | var16_10;
                                v16 = var6_21 + var23_14;
                                var4_4[v16] = var4_4[v16] | 0x20010000;
                                v17 = var6_21 + var24_15;
                                var4_4[v17] = var4_4[v17] | 0x20020000;
                                if (var17_25 != 0) {
                                    var15_24 |= 606126080;
                                    v18 = var6_21 - var11_7;
                                    var4_4[v18] = var4_4[v18] | 0x22100000;
                                    v19 = var6_21 + 1;
                                    var4_4[v19] = var4_4[v19] | 537407616;
                                    v20 = var6_21 - 1;
                                    var4_4[v20] = var4_4[v20] | 537143360;
                                } else {
                                    var15_24 |= 0x2020C000;
                                    v21 = var6_21 - var11_7;
                                    var4_4[v21] = var4_4[v21] | 0x20100000;
                                    v22 = var6_21 + 1;
                                    var4_4[v22] = var4_4[v22] | 0x20082080;
                                    v23 = var6_21 - 1;
                                    var4_4[v23] = var4_4[v23] | 0x20042040;
                                }
                            } else {
                                var15_24 |= 16384;
                            }
                        }
                        if (var22_26 < 4) {
                            var4_4[var6_21] = var15_24;
                        } else {
                            if ((var15_24 & -1610612736) == 0x20000000) {
                                var8_22 += var10_6;
                                if (var2_2.readBit() != 0) {
                                    var17_25 = var2_2.readBit();
                                    var18_11[var8_22] = var17_25 << 31 | var16_10;
                                    v24 = var6_21 + var26_17;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var6_21 + var25_16;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var17_25 != 0) {
                                        var15_24 |= -1073733104;
                                        v26 = var6_21 + var11_7;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var6_21 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var6_21 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var15_24 |= -1073733616;
                                        v29 = var6_21 + var11_7;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var6_21 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var6_21 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                } else {
                                    var15_24 |= 0x40000000;
                                }
                            }
                            var4_4[var6_21] = var15_24;
                        }
                    }
                }
                ++var9_18;
                ++var7_19;
            }
            --var19_20;
            var9_18 += var13_9;
            var7_19 += var12_8;
        }
        var27_27 = false;
        if (var5_5 && (this.options & 16) != 0) {
            var27_27 = var2_2.checkBytePadding();
        }
        return var27_27;
    }

    /*
     * Unable to fully structure code
     */
    private boolean magRefPass(DataBlk var1_1, MQDecoder var2_2, int var3_3, int[] var4_4, boolean var5_5) {
        var10_6 = var1_1.scanw;
        var11_7 = var1_1.w + 2;
        var12_8 = var11_7 * 4 / 2 - var1_1.w;
        var13_9 = var10_6 * 4 - var1_1.w;
        var16_10 = 1 << var3_3 >> 1;
        var17_11 = -1 << var3_3 + 1;
        var19_12 = (int[])var1_1.getData();
        var21_13 = (var1_1.h + 4 - 1) / 4;
        var9_14 = var1_1.offset;
        var7_15 = var11_7 + 1;
        var20_16 = var21_13 - 1;
        while (var20_16 >= 0) {
            var22_22 = var20_16 != 0 ? 4 : var1_1.h - (var21_13 - 1) * 4;
            var14_19 = var9_14 + var1_1.w;
            while (var9_14 < var14_19) {
                var6_17 = var7_15;
                var15_20 = var4_4[var6_17];
                if ((var15_20 >>> 1 & ~var15_20 & 0x40004000) == 0) ** GOTO lbl38
                var8_18 = var9_14;
                if ((var15_20 & 49152) == 32768) {
                    var18_21 = var2_2.decodeSymbol(StdEntropyDecoder.MR_LUT[var15_20 & 511]);
                    v0 = var8_18;
                    var19_12[v0] = var19_12[v0] & var17_11;
                    v1 = var8_18;
                    var19_12[v1] = var19_12[v1] | (var18_21 << var3_3 | var16_10);
                    var15_20 |= 256;
                }
                if (var22_22 < 2) {
                    var4_4[var6_17] = var15_20;
                } else {
                    if ((var15_20 & -1073741824) == -2147483648) {
                        var18_21 = var2_2.decodeSymbol(StdEntropyDecoder.MR_LUT[var15_20 >>> 16 & 511]);
                        v2 = var8_18 += var10_6;
                        var19_12[v2] = var19_12[v2] & var17_11;
                        v3 = var8_18;
                        var19_12[v3] = var19_12[v3] | (var18_21 << var3_3 | var16_10);
                        var15_20 |= 0x1000000;
                    }
                    var4_4[var6_17] = var15_20;
lbl38:
                    // 2 sources

                    if (var22_22 >= 3 && ((var15_20 = var4_4[var6_17 += var11_7]) >>> 1 & ~var15_20 & 0x40004000) != 0) {
                        var8_18 = var9_14 + (var10_6 << 1);
                        if ((var15_20 & 49152) == 32768) {
                            var18_21 = var2_2.decodeSymbol(StdEntropyDecoder.MR_LUT[var15_20 & 511]);
                            v4 = var8_18;
                            var19_12[v4] = var19_12[v4] & var17_11;
                            v5 = var8_18;
                            var19_12[v5] = var19_12[v5] | (var18_21 << var3_3 | var16_10);
                            var15_20 |= 256;
                        }
                        if (var22_22 < 4) {
                            var4_4[var6_17] = var15_20;
                        } else {
                            if ((var4_4[var6_17] & -1073741824) == -2147483648) {
                                var18_21 = var2_2.decodeSymbol(StdEntropyDecoder.MR_LUT[var15_20 >>> 16 & 511]);
                                v6 = var8_18 += var10_6;
                                var19_12[v6] = var19_12[v6] & var17_11;
                                v7 = var8_18;
                                var19_12[v7] = var19_12[v7] | (var18_21 << var3_3 | var16_10);
                                var15_20 |= 0x1000000;
                            }
                            var4_4[var6_17] = var15_20;
                        }
                    }
                }
                ++var9_14;
                ++var7_15;
            }
            --var20_16;
            var9_14 += var13_9;
            var7_15 += var12_8;
        }
        var23_23 = false;
        if (var5_5 && (this.options & 16) != 0) {
            var23_23 = var2_2.checkPredTerm();
        }
        if ((this.options & 2) != 0) {
            var2_2.resetCtxts();
        }
        return var23_23;
    }

    private boolean rawMagRefPass(DataBlk dataBlk, ByteToBitInput byteToBitInput, int n, int[] nArray, boolean bl) {
        int n2 = dataBlk.scanw;
        int n3 = dataBlk.w + 2;
        int n4 = n3 * 4 / 2 - dataBlk.w;
        int n5 = n2 * 4 - dataBlk.w;
        int n6 = 1 << n >> 1;
        int n7 = -1 << n + 1;
        int[] nArray2 = (int[])dataBlk.getData();
        int n8 = (dataBlk.h + 4 - 1) / 4;
        int n9 = dataBlk.offset;
        int n10 = n3 + 1;
        int n11 = n8 - 1;
        while (n11 >= 0) {
            int n12 = n11 != 0 ? 4 : dataBlk.h - (n8 - 1) * 4;
            int n13 = n9 + dataBlk.w;
            while (n9 < n13) {
                block12: {
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    block11: {
                        n17 = n10;
                        n16 = nArray[n17];
                        if ((n16 >>> 1 & ~n16 & 0x40004000) == 0) break block11;
                        n15 = n9;
                        if ((n16 & 0xC000) == 32768) {
                            n14 = byteToBitInput.readBit();
                            int n18 = n15;
                            nArray2[n18] = nArray2[n18] & n7;
                            int n19 = n15;
                            nArray2[n19] = nArray2[n19] | (n14 << n | n6);
                        }
                        if (n12 < 2) break block12;
                        if ((n16 & 0xC0000000) == Integer.MIN_VALUE) {
                            n14 = byteToBitInput.readBit();
                            int n20 = n15 += n2;
                            nArray2[n20] = nArray2[n20] & n7;
                            int n21 = n15;
                            nArray2[n21] = nArray2[n21] | (n14 << n | n6);
                        }
                    }
                    if (n12 >= 3 && ((n16 = nArray[n17 += n3]) >>> 1 & ~n16 & 0x40004000) != 0) {
                        n15 = n9 + (n2 << 1);
                        if ((n16 & 0xC000) == 32768) {
                            n14 = byteToBitInput.readBit();
                            int n22 = n15;
                            nArray2[n22] = nArray2[n22] & n7;
                            int n23 = n15;
                            nArray2[n23] = nArray2[n23] | (n14 << n | n6);
                        }
                        if (n12 >= 4 && (nArray[n17] & 0xC0000000) == Integer.MIN_VALUE) {
                            n14 = byteToBitInput.readBit();
                            int n24 = n15 += n2;
                            nArray2[n24] = nArray2[n24] & n7;
                            int n25 = n15;
                            nArray2[n25] = nArray2[n25] | (n14 << n | n6);
                        }
                    }
                }
                ++n9;
                ++n10;
            }
            --n11;
            n9 += n5;
            n10 += n4;
        }
        boolean bl2 = false;
        if (bl && (this.options & 0x10) != 0) {
            bl2 = byteToBitInput.checkBytePadding();
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean cleanuppass(DataBlk var1_1, MQDecoder var2_2, int var3_3, int[] var4_4, int[] var5_5, boolean var6_6) {
        var11_7 = var1_1.scanw;
        var12_8 = var1_1.w + 2;
        var13_9 = var12_8 * 4 / 2 - var1_1.w;
        var14_10 = var11_7 * 4 - var1_1.w;
        var17_11 = 3 << var3_3 >> 1;
        var21_12 = (int[])var1_1.getData();
        var24_13 = (var1_1.h + 4 - 1) / 4;
        var23_14 = (this.options & 8) != 0;
        var26_15 = -var12_8 - 1;
        var27_16 = -var12_8 + 1;
        var28_17 = var12_8 + 1;
        var29_18 = var12_8 - 1;
        var10_19 = var1_1.offset;
        var8_20 = var12_8 + 1;
        var22_21 = var24_13 - 1;
        while (var22_21 >= 0) {
            var25_29 = var22_21 != 0 ? 4 : var1_1.h - (var24_13 - 1) * 4;
            var15_24 = var10_19 + var1_1.w;
            while (var10_19 < var15_24) {
                block34: {
                    block36: {
                        block37: {
                            block38: {
                                block33: {
                                    block35: {
                                        var7_22 = var8_20;
                                        var16_25 = var4_4[var7_22];
                                        if (var16_25 != 0 || var4_4[var7_22 + var12_8] != 0 || var25_29 != 4) break block33;
                                        if (var2_2.decodeSymbol(1) == 0) break block34;
                                        var19_27 = var2_2.decodeSymbol(0) << 1;
                                        var9_23 = var10_19 + (var19_27 |= var2_2.decodeSymbol(0)) * var11_7;
                                        if (var19_27 > 1) {
                                            var16_25 = var4_4[var7_22 += var12_8];
                                        }
                                        if ((var19_27 & 1) != 0) break block35;
                                        var20_28 = StdEntropyDecoder.SC_LUT[var16_25 >> 4 & 511];
                                        var18_26 = var2_2.decodeSymbol(var20_28 & 15) ^ var20_28 >>> 31;
                                        var21_12[var9_23] = var18_26 << 31 | var17_11;
                                        if (var19_27 != 0 || !var23_14) {
                                            v0 = var7_22 + var26_15;
                                            var4_4[v0] = var4_4[v0] | 0x20010000;
                                            v1 = var7_22 + var27_16;
                                            var4_4[v1] = var4_4[v1] | 0x20020000;
                                        }
                                        if (var18_26 != 0) {
                                            var16_25 |= 606126080;
                                            if (var19_27 != 0 || !var23_14) {
                                                v2 = var7_22 - var12_8;
                                                var4_4[v2] = var4_4[v2] | 0x22100000;
                                            }
                                            v3 = var7_22 + 1;
                                            var4_4[v3] = var4_4[v3] | 537407616;
                                            v4 = var7_22 - 1;
                                            var4_4[v4] = var4_4[v4] | 537143360;
                                        } else {
                                            var16_25 |= 0x2020C000;
                                            if (var19_27 != 0 || !var23_14) {
                                                v5 = var7_22 - var12_8;
                                                var4_4[v5] = var4_4[v5] | 0x20100000;
                                            }
                                            v6 = var7_22 + 1;
                                            var4_4[v6] = var4_4[v6] | 0x20082080;
                                            v7 = var7_22 - 1;
                                            var4_4[v7] = var4_4[v7] | 0x20042040;
                                        }
                                        if (var19_27 >> 1 == 0) break block33;
                                        break block36;
                                    }
                                    var20_28 = StdEntropyDecoder.SC_LUT[var16_25 >> 20 & 511];
                                    var18_26 = var2_2.decodeSymbol(var20_28 & 15) ^ var20_28 >>> 31;
                                    var21_12[var9_23] = var18_26 << 31 | var17_11;
                                    v8 = var7_22 + var29_18;
                                    var4_4[v8] = var4_4[v8] | 8196;
                                    v9 = var7_22 + var28_17;
                                    var4_4[v9] = var4_4[v9] | 8200;
                                    if (var18_26 != 0) {
                                        var16_25 |= -2147474928;
                                        v10 = var7_22 + var12_8;
                                        var4_4[v10] = var4_4[v10] | 9248;
                                        v11 = var7_22 + 1;
                                        var4_4[v11] = var4_4[v11] | 813703170;
                                        v12 = var7_22 - 1;
                                        var4_4[v12] = var4_4[v12] | 675291137;
                                    } else {
                                        var16_25 |= -2147475440;
                                        v13 = var7_22 + var12_8;
                                        var4_4[v13] = var4_4[v13] | 8224;
                                        v14 = var7_22 + 1;
                                        var4_4[v14] = var4_4[v14] | 0x20802002;
                                        v15 = var7_22 - 1;
                                        var4_4[v15] = var4_4[v15] | 541073409;
                                    }
                                    var4_4[var7_22] = var16_25;
                                    if (var19_27 >> 1 != 0) break block34;
                                    var16_25 = var4_4[var7_22 += var12_8];
                                    break block36;
                                }
                                if (((var16_25 >> 1 | var16_25) & 0x40004000) == 0x40004000) break block37;
                                var9_23 = var10_19;
                                if ((var16_25 & 49152) == 0 && var2_2.decodeSymbol(var5_5[var16_25 & 255]) != 0) {
                                    var20_28 = StdEntropyDecoder.SC_LUT[var16_25 >>> 4 & 511];
                                    var18_26 = var2_2.decodeSymbol(var20_28 & 15) ^ var20_28 >>> 31;
                                    var21_12[var9_23] = var18_26 << 31 | var17_11;
                                    if (!var23_14) {
                                        v16 = var7_22 + var26_15;
                                        var4_4[v16] = var4_4[v16] | 0x20010000;
                                        v17 = var7_22 + var27_16;
                                        var4_4[v17] = var4_4[v17] | 0x20020000;
                                    }
                                    if (var18_26 != 0) {
                                        var16_25 |= 606126080;
                                        if (!var23_14) {
                                            v18 = var7_22 - var12_8;
                                            var4_4[v18] = var4_4[v18] | 0x22100000;
                                        }
                                        v19 = var7_22 + 1;
                                        var4_4[v19] = var4_4[v19] | 537407616;
                                        v20 = var7_22 - 1;
                                        var4_4[v20] = var4_4[v20] | 537143360;
                                    } else {
                                        var16_25 |= 0x2020C000;
                                        if (!var23_14) {
                                            v21 = var7_22 - var12_8;
                                            var4_4[v21] = var4_4[v21] | 0x20100000;
                                        }
                                        v22 = var7_22 + 1;
                                        var4_4[v22] = var4_4[v22] | 0x20082080;
                                        v23 = var7_22 - 1;
                                        var4_4[v23] = var4_4[v23] | 0x20042040;
                                    }
                                }
                                if (var25_29 >= 2) break block38;
                                var4_4[var7_22] = var16_25 &= -1073758209;
                                break block34;
                            }
                            if ((var16_25 & -1073741824) == 0) {
                                var9_23 += var11_7;
                                if (var2_2.decodeSymbol(var5_5[var16_25 >>> 16 & 255]) != 0) {
                                    var20_28 = StdEntropyDecoder.SC_LUT[var16_25 >>> 20 & 511];
                                    var18_26 = var2_2.decodeSymbol(var20_28 & 15) ^ var20_28 >>> 31;
                                    var21_12[var9_23] = var18_26 << 31 | var17_11;
                                    v24 = var7_22 + var29_18;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var7_22 + var28_17;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var18_26 != 0) {
                                        var16_25 |= -1073733104;
                                        v26 = var7_22 + var12_8;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var7_22 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var7_22 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var16_25 |= -1073733616;
                                        v29 = var7_22 + var12_8;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var7_22 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var7_22 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                }
                            }
                        }
                        var4_4[var7_22] = var16_25 &= -1073758209;
                        if (var25_29 < 3) break block34;
                        var16_25 = var4_4[var7_22 += var12_8];
                    }
                    if (((var16_25 >> 1 | var16_25) & 0x40004000) == 0x40004000) ** GOTO lbl205
                    var9_23 = var10_19 + (var11_7 << 1);
                    if ((var16_25 & 49152) == 0 && var2_2.decodeSymbol(var5_5[var16_25 & 255]) != 0) {
                        var20_28 = StdEntropyDecoder.SC_LUT[var16_25 >> 4 & 511];
                        var18_26 = var2_2.decodeSymbol(var20_28 & 15) ^ var20_28 >>> 31;
                        var21_12[var9_23] = var18_26 << 31 | var17_11;
                        v32 = var7_22 + var26_15;
                        var4_4[v32] = var4_4[v32] | 0x20010000;
                        v33 = var7_22 + var27_16;
                        var4_4[v33] = var4_4[v33] | 0x20020000;
                        if (var18_26 != 0) {
                            var16_25 |= 606126080;
                            v34 = var7_22 - var12_8;
                            var4_4[v34] = var4_4[v34] | 0x22100000;
                            v35 = var7_22 + 1;
                            var4_4[v35] = var4_4[v35] | 537407616;
                            v36 = var7_22 - 1;
                            var4_4[v36] = var4_4[v36] | 537143360;
                        } else {
                            var16_25 |= 0x2020C000;
                            v37 = var7_22 - var12_8;
                            var4_4[v37] = var4_4[v37] | 0x20100000;
                            v38 = var7_22 + 1;
                            var4_4[v38] = var4_4[v38] | 0x20082080;
                            v39 = var7_22 - 1;
                            var4_4[v39] = var4_4[v39] | 0x20042040;
                        }
                    }
                    if (var25_29 < 4) {
                        var4_4[var7_22] = var16_25 &= -1073758209;
                    } else {
                        if ((var16_25 & -1073741824) == 0) {
                            var9_23 += var11_7;
                            if (var2_2.decodeSymbol(var5_5[var16_25 >>> 16 & 255]) != 0) {
                                var20_28 = StdEntropyDecoder.SC_LUT[var16_25 >>> 20 & 511];
                                var18_26 = var2_2.decodeSymbol(var20_28 & 15) ^ var20_28 >>> 31;
                                var21_12[var9_23] = var18_26 << 31 | var17_11;
                                v40 = var7_22 + var29_18;
                                var4_4[v40] = var4_4[v40] | 8196;
                                v41 = var7_22 + var28_17;
                                var4_4[v41] = var4_4[v41] | 8200;
                                if (var18_26 != 0) {
                                    var16_25 |= -1073733104;
                                    v42 = var7_22 + var12_8;
                                    var4_4[v42] = var4_4[v42] | 9248;
                                    v43 = var7_22 + 1;
                                    var4_4[v43] = var4_4[v43] | 813703170;
                                    v44 = var7_22 - 1;
                                    var4_4[v44] = var4_4[v44] | 675291137;
                                } else {
                                    var16_25 |= -1073733616;
                                    v45 = var7_22 + var12_8;
                                    var4_4[v45] = var4_4[v45] | 8224;
                                    v46 = var7_22 + 1;
                                    var4_4[v46] = var4_4[v46] | 0x20802002;
                                    v47 = var7_22 - 1;
                                    var4_4[v47] = var4_4[v47] | 541073409;
                                }
                            }
                        }
lbl205:
                        // 7 sources

                        var4_4[var7_22] = var16_25 &= -1073758209;
                    }
                }
                ++var10_19;
                ++var8_20;
            }
            --var22_21;
            var10_19 += var14_10;
            var8_20 += var13_9;
        }
        if ((this.options & 32) != 0) {
            var18_26 = var2_2.decodeSymbol(0) << 3;
            var18_26 |= var2_2.decodeSymbol(0) << 2;
            var18_26 |= var2_2.decodeSymbol(0) << 1;
            var30_30 = (var18_26 |= var2_2.decodeSymbol(0)) != 10;
        } else {
            var30_30 = false;
        }
        if (var6_6 && (this.options & 16) != 0) {
            var30_30 = var2_2.checkPredTerm();
        }
        if ((this.options & 2) != 0) {
            var2_2.resetCtxts();
        }
        return var30_30;
    }

    private void conceal(DataBlk dataBlk, int n) {
        int n2 = 1 << n;
        int n3 = -1 << n;
        int[] nArray = (int[])dataBlk.getData();
        int n4 = dataBlk.offset;
        for (int i = dataBlk.h - 1; i >= 0; --i) {
            int n5 = n4 + dataBlk.w;
            while (n4 < n5) {
                int n6 = nArray[n4];
                nArray[n4] = (n6 & n3 & Integer.MAX_VALUE) != 0 ? n6 & n3 | n2 : 0;
                ++n4;
            }
            n4 += dataBlk.scanw - dataBlk.w;
        }
    }

    static {
        int n;
        int n2;
        ZC_LUT_LH = new int[256];
        ZC_LUT_HL = new int[256];
        ZC_LUT_HH = new int[256];
        SC_LUT = new int[512];
        MR_LUT = new int[512];
        MQ_INIT = new int[]{46, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        StdEntropyDecoder.ZC_LUT_LH[0] = 2;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyDecoder.ZC_LUT_LH[n2] = 4;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            StdEntropyDecoder.ZC_LUT_LH[1 << n2] = 3;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            StdEntropyDecoder.ZC_LUT_LH[0x20 | n2] = 5;
            StdEntropyDecoder.ZC_LUT_LH[0x10 | n2] = 5;
            StdEntropyDecoder.ZC_LUT_LH[0x30 | n2] = 6;
        }
        StdEntropyDecoder.ZC_LUT_LH[128] = 7;
        StdEntropyDecoder.ZC_LUT_LH[64] = 7;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyDecoder.ZC_LUT_LH[0x80 | n2] = 8;
            StdEntropyDecoder.ZC_LUT_LH[0x40 | n2] = 8;
        }
        for (n2 = 1; n2 < 4; ++n2) {
            for (n = 0; n < 16; ++n) {
                StdEntropyDecoder.ZC_LUT_LH[0x80 | n2 << 4 | n] = 9;
                StdEntropyDecoder.ZC_LUT_LH[0x40 | n2 << 4 | n] = 9;
            }
        }
        for (n2 = 0; n2 < 64; ++n2) {
            StdEntropyDecoder.ZC_LUT_LH[0xC0 | n2] = 10;
        }
        StdEntropyDecoder.ZC_LUT_HL[0] = 2;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyDecoder.ZC_LUT_HL[n2] = 4;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            StdEntropyDecoder.ZC_LUT_HL[1 << n2] = 3;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            StdEntropyDecoder.ZC_LUT_HL[0x80 | n2] = 5;
            StdEntropyDecoder.ZC_LUT_HL[0x40 | n2] = 5;
            StdEntropyDecoder.ZC_LUT_HL[0xC0 | n2] = 6;
        }
        StdEntropyDecoder.ZC_LUT_HL[32] = 7;
        StdEntropyDecoder.ZC_LUT_HL[16] = 7;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyDecoder.ZC_LUT_HL[0x20 | n2] = 8;
            StdEntropyDecoder.ZC_LUT_HL[0x10 | n2] = 8;
        }
        for (n2 = 1; n2 < 4; ++n2) {
            for (n = 0; n < 16; ++n) {
                StdEntropyDecoder.ZC_LUT_HL[n2 << 6 | 0x20 | n] = 9;
                StdEntropyDecoder.ZC_LUT_HL[n2 << 6 | 0x10 | n] = 9;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 16; ++n) {
                StdEntropyDecoder.ZC_LUT_HL[n2 << 6 | 0x20 | 0x10 | n] = 10;
            }
        }
        int[] nArray = new int[]{3, 5, 6, 9, 10, 12};
        int[] nArray2 = new int[]{1, 2, 4, 8};
        int[] nArray3 = new int[]{3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15};
        int[] nArray4 = new int[]{7, 11, 13, 14, 15};
        StdEntropyDecoder.ZC_LUT_HH[0] = 2;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            StdEntropyDecoder.ZC_LUT_HH[nArray2[n2] << 4] = 3;
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            StdEntropyDecoder.ZC_LUT_HH[nArray3[n2] << 4] = 4;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            StdEntropyDecoder.ZC_LUT_HH[nArray2[n2]] = 5;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            for (n = 0; n < nArray2.length; ++n) {
                StdEntropyDecoder.ZC_LUT_HH[nArray2[n2] << 4 | nArray2[n]] = 6;
            }
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            for (n = 0; n < nArray2.length; ++n) {
                StdEntropyDecoder.ZC_LUT_HH[nArray3[n2] << 4 | nArray2[n]] = 7;
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            StdEntropyDecoder.ZC_LUT_HH[nArray[n2]] = 8;
        }
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 1; n2 < 16; ++n2) {
                StdEntropyDecoder.ZC_LUT_HH[n2 << 4 | nArray[n]] = 9;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < nArray4.length; ++n) {
                StdEntropyDecoder.ZC_LUT_HH[n2 << 4 | nArray4[n]] = 10;
            }
        }
        int[] nArray5 = new int[36];
        nArray5[18] = 15;
        nArray5[17] = 14;
        nArray5[16] = 13;
        nArray5[10] = 12;
        nArray5[9] = 11;
        nArray5[8] = -2147483636;
        nArray5[2] = -2147483635;
        nArray5[1] = -2147483634;
        nArray5[0] = -2147483633;
        for (n2 = 0; n2 < 511; ++n2) {
            int n3 = n2 & 1;
            int n4 = n2 >> 1 & 1;
            int n5 = n2 >> 2 & 1;
            int n6 = n2 >> 3 & 1;
            int n7 = n2 >> 5 & 1;
            int n8 = n2 >> 6 & 1;
            int n9 = n2 >> 8 & 1;
            int n10 = n2 >> 7 & 1;
            int n11 = n6 * (1 - 2 * n9) + n5 * (1 - 2 * n10);
            n11 = n11 >= -1 ? n11 : -1;
            n11 = n11 <= 1 ? n11 : 1;
            int n12 = n4 * (1 - 2 * n8) + n3 * (1 - 2 * n7);
            n12 = n12 >= -1 ? n12 : -1;
            n12 = n12 <= 1 ? n12 : 1;
            StdEntropyDecoder.SC_LUT[n2] = nArray5[n11 + 1 << 3 | n12 + 1];
        }
        nArray5 = null;
        StdEntropyDecoder.MR_LUT[0] = 16;
        for (n2 = 1; n2 < 256; ++n2) {
            StdEntropyDecoder.MR_LUT[n2] = 17;
        }
        while (n2 < 512) {
            StdEntropyDecoder.MR_LUT[n2] = 18;
            ++n2;
        }
    }
}

