/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.encoder;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.FileCodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;
import jj2000.j2k.codestream.writer.PktEncoder;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.fileformat.writer.FileFormatWriter;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.ImgDataJoiner;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.image.forwcomptransf.ForwCompTransf;
import jj2000.j2k.image.input.ImgReader;
import jj2000.j2k.image.input.ImgReaderPGM;
import jj2000.j2k.image.input.ImgReaderPGX;
import jj2000.j2k.image.input.ImgReaderPPM;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.CodestreamManipulator;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MsgLogger;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.ForwardWT;

public class Encoder
implements Runnable {
    private int exitCode;
    private ParameterList pl;
    private ParameterList defpl;
    public static final char[] vprfxs = new char[]{'M', 'F', 'W', 'Q', 'R', 'H', 'C', 'A', 'P'};
    private static final String[][] pinfo = new String[][]{{"debug", null, "Print debugging messages when an error is encountered.", "off"}, {"disable_jp2_extension", "[on|off]", "JJ2000 automatically adds .jp2 extension when using 'file_format'option. This option disables it when on.", "off"}, {"file_format", "[on|off]", "Puts the JPEG 2000 codestream in a JP2 file format wrapper.", "off"}, {"pph_tile", "[on|off]", "Packs the packet headers in the tile headers.", "off"}, {"pph_main", "[on|off]", "Packs the packet headers in the main header.", "off"}, {"pfile", "<filename of arguments file>", "Loads the arguments from the specified file. Arguments that are specified on the command line override the ones from the file.\nThe arguments file is a simple text file with one argument per line of the following form:\n  <argument name>=<argument value>\nIf the argument is of boolean type (i.e. its presence turns a feature on), then the 'on' value turns it on, while the 'off' value turns it off. The argument name does not include the '-' or '+' character. Long lines can be broken into several lines by terminating them with ''. Lines starting with '#' are considered as comments. This option is not recursive: any 'pfile' argument appearing in the file is ignored.", null}, {"tile_parts", "<packets per tile-part>", "This option specifies the maximum number of packets to have in one tile-part. 0 means include all packets in first tile-part of each tile", "0"}, {"tiles", "<nominal tile width> <nominal tile height>", "This option specifies the maximum tile dimensions to use. If both dimensions are 0 then no tiling is used.", "0 0"}, {"ref", "<x> <y>", "Sets the origin of the image in the canvas system. It sets the coordinate of the top-left corner of the image reference grid, with respect to the canvas origin", "0 0"}, {"tref", "<x> <y>", "Sets the origin of the tile partitioning on the reference grid, with respect to the canvas origin. The value of 'x' ('y') specified can not be larger than the 'x' one specified in the ref option.", "0 0"}, {"rate", "<output bitrate in bpp>", "This is the output bitrate of the codestream in bits per pixel. When equal to -1, no image information (beside quantization effects) is discarded during compression.\nNote: In the case where '-file_format' option is used, the resulting file may have a larger bitrate.", "-1"}, {"lossless", "[on|off]", "Specifies a lossless compression for the encoder. This options is equivalent to use reversible quantization ('-Qtype reversible') and 5x3 wavelet filters pair ('-Ffilters w5x3'). Note that this option cannot be used with '-rate'. When this option is off, the quantization type and the filters pair is defined by '-Qtype' and '-Ffilters' respectively.", "off"}, {"i", "<image file> [,<image file> [,<image file> ... ]]", "Mandatory argument. This option specifies the name of the input image files. If several image files are provided, they have to be separated by commas in the command line. Supported formats are PGM (raw), PPM (raw) and PGX, which is a simple extension of the PGM file format for single component data supporting arbitrary bitdepths. If the extension is '.pgm', PGM-raw file format is assumed, if the extension is '.ppm', PPM-raw file format is assumed, otherwise PGX file format is assumed. PGM and PPM files are assumed to be 8 bits deep. A multi-component image can be specified by either specifying several PPM and/or PGX files, or by specifying one PPM file.", null}, {"o", "<file name>", "Mandatory argument. This option specifies the name of the output file to which the codestream will be written.", null}, {"verbose", null, "Prints information about the obtained bit stream.", "on"}, {"v", "[on|off]", "Prints version and copyright information.", "off"}, {"u", "[on|off]", "Prints usage information. If specified all other arguments (except 'v') are ignored", "off"}};

    public Encoder(ParameterList parameterList) {
        this.pl = parameterList;
        this.defpl = parameterList.getDefaultParameterList();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            Object object;
            PostCompRateAllocator postCompRateAllocator;
            FileCodestreamWriter fileCodestreamWriter;
            EntropyCoder entropyCoder;
            ROIScaler rOIScaler;
            Quantizer quantizer;
            ForwardWT forwardWT;
            ForwCompTransf forwCompTransf;
            Tiler tiler;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Object object2;
            int n6;
            int n7;
            float f;
            boolean bl6;
            try {
                if (this.pl.getBooleanParameter("v")) {
                    this.printVersionAndCopyright();
                }
                if (this.pl.getParameter("u").equals("on")) {
                    this.printUsage();
                    return;
                }
                bl6 = this.pl.getBooleanParameter("verbose");
            }
            catch (StringFormatException stringFormatException) {
                this.error("An error occured while parsing the arguments:\n" + stringFormatException.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    stringFormatException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.error("An error occured while parsing the arguments:\n" + numberFormatException.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    numberFormatException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            if (this.pl.getParameter("i") == null) {
                this.error("Mandatory input file is missing (-i option)", 2);
                return;
            }
            if (this.pl.getParameter("o") == null) {
                this.error("Mandatory output file is missing (-o option)", 2);
                return;
            }
            String string = this.pl.getParameter("o");
            if (this.pl.getParameter("file_format").equals("on")) {
                bl = true;
                if (this.pl.getParameter("rate") != null && this.pl.getFloatParameter("rate") != this.defpl.getFloatParameter("rate")) {
                    this.warning("Specified bit-rate applies only on the codestream but not on the whole file.");
                }
            }
            if (bl) {
                String string2 = null;
                String string3 = string;
                if (string.lastIndexOf(46) != -1) {
                    string2 = string.substring(string.lastIndexOf(46), string.length());
                    string3 = string.substring(0, string.lastIndexOf(46));
                }
                if (!(string2 != null && string2.equalsIgnoreCase(".jp2") || this.pl.getBooleanParameter("disable_jp2_extension"))) {
                    FacilityManager.getMsgLogger().printmsg(1, "JPEG 2000 file names end with .jp2 extension when using the file format of part 1. This extension is automatically added by JJ2000. Use '-disable_jp2_extension' to disable it.");
                    string = string3 + ".jp2";
                }
            }
            if (this.pl.getParameter("tiles") == null) {
                this.error("No tiles option specified", 2);
                return;
            }
            if (this.pl.getParameter("pph_tile").equals("on")) {
                bl2 = true;
                if (this.pl.getParameter("Psop").equals("off")) {
                    this.pl.put("Psop", "on");
                    bl4 = true;
                }
                if (this.pl.getParameter("Peph").equals("off")) {
                    this.pl.put("Peph", "on");
                    bl5 = true;
                }
            }
            if (this.pl.getParameter("pph_main").equals("on")) {
                bl3 = true;
                if (this.pl.getParameter("Psop").equals("off")) {
                    this.pl.put("Psop", "on");
                    bl4 = true;
                }
                if (this.pl.getParameter("Peph").equals("off")) {
                    this.pl.put("Peph", "on");
                    bl5 = true;
                }
            }
            if (bl2 && bl3) {
                this.error("Can't have packed packet headers in both main and tile headers", 2);
            }
            if (this.pl.getBooleanParameter("lossless") && this.pl.getParameter("rate") != null && this.pl.getFloatParameter("rate") != this.defpl.getFloatParameter("rate")) {
                throw new IllegalArgumentException("Cannot use '-rate' and '-lossless' option at  the same time.");
            }
            if (this.pl.getParameter("rate") == null) {
                this.error("Target bitrate not specified", 2);
                return;
            }
            try {
                f = this.pl.getFloatParameter("rate");
                if (f == -1.0f) {
                    f = Float.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.error("Invalid value in 'rate' option: " + this.pl.getParameter("rate"), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    numberFormatException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                n7 = this.pl.getIntParameter("tile_parts");
                if (n7 != 0) {
                    if (this.pl.getParameter("Psop").equals("off")) {
                        this.pl.put("Psop", "on");
                        bl4 = true;
                    }
                    if (this.pl.getParameter("Peph").equals("off")) {
                        this.pl.put("Peph", "on");
                        bl5 = true;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.error("Invalid value in 'tile_parts' option: " + this.pl.getParameter("tile_parts"), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    numberFormatException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.pl.getParameter("i"), ",");
            int n8 = 0;
            boolean bl7 = false;
            Vector<ImgReader> vector = new Vector<ImgReader>();
            int n9 = stringTokenizer.countTokens();
            for (n6 = 0; n6 < n9; ++n6) {
                String string4 = stringTokenizer.nextToken();
                try {
                    if (vector.size() < n8) {
                        this.error("With PPM input format only 1 input file can be specified", 2);
                        return;
                    }
                    String string5 = string4.lastIndexOf(46) != -1 ? string4.substring(string4.lastIndexOf(46), string4.length()) : null;
                    if (".PGM".equalsIgnoreCase(string5)) {
                        vector.addElement(new ImgReaderPGM(string4));
                        ++n8;
                        continue;
                    }
                    if (".PPM".equalsIgnoreCase(string5)) {
                        if (n8 > 0) {
                            this.error("With PPM input format only 1 input file can be specified", 2);
                            return;
                        }
                        vector.addElement(new ImgReaderPPM(string4));
                        bl7 = true;
                        n8 += 3;
                        continue;
                    }
                    vector.addElement(new ImgReaderPGX(string4));
                    ++n8;
                    continue;
                }
                catch (IOException iOException) {
                    this.error("Could not open or read from file " + string4 + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 3);
                    if (this.pl.getParameter("debug").equals("on")) {
                        iOException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                finally {
                    if (this.exitCode != 0) {
                        while (vector.size() > 0) {
                            try {
                                ((ImgReader)vector.elementAt(vector.size() - 1)).close();
                                vector.removeElementAt(vector.size() - 1);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            Object[] objectArray = new ImgReader[vector.size()];
            vector.copyInto(objectArray);
            vector.removeAllElements();
            vector = null;
            boolean[] blArray = new boolean[n8];
            if (bl7 || n8 == 1) {
                object2 = objectArray[0];
                for (n5 = 0; n5 < n8; ++n5) {
                    blArray[n5] = ((ImgReader)objectArray[0]).isOrigSigned(n5);
                }
            } else {
                int[] nArray = new int[n8];
                for (n5 = 0; n5 < n8; ++n5) {
                    blArray[n5] = ((ImgReader)objectArray[n5]).isOrigSigned(0);
                }
                object2 = new ImgDataJoiner((BlkImgDataSrc[])objectArray, nArray);
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.pl.getParameter("tiles")));
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                this.error("An error occurred while parsing the tiles option: " + this.pl.getParameter("tiles"), 2);
                return;
            }
            int n10 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                this.error("An error occurred while parsing the tiles option: " + this.pl.getParameter("tiles"), 2);
                return;
            }
            int n11 = (int)streamTokenizer.nval;
            stringTokenizer = new StringTokenizer(this.pl.getParameter("ref"));
            try {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException("Error while parsing 'ref' option");
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid number type in 'ref' option");
            }
            if (n4 < 0 || n3 < 0) {
                throw new IllegalArgumentException("Invalid value in 'ref' option ");
            }
            stringTokenizer = new StringTokenizer(this.pl.getParameter("tref"));
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException("Error while parsing 'tref' option");
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid number type in 'tref' option");
            }
            if (n2 < 0 || n < 0 || n2 > n4 || n > n3) {
                throw new IllegalArgumentException("Invalid value in 'tref' option ");
            }
            try {
                tiler = new Tiler((BlkImgDataSrc)object2, n4, n3, n2, n, n10, n11);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not tile image" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            n6 = tiler.getNumTiles();
            EncoderSpecs encoderSpecs = new EncoderSpecs(n6, n8, (BlkImgDataSrc)object2, this.pl);
            if (bl7 && this.pl.getParameter("Mct") != null && this.pl.getParameter("Mct").equals("off")) {
                FacilityManager.getMsgLogger().printmsg(2, "Input image is RGB and no color transform has been specified. Compression performance and image quality might be greatly degraded. Use the 'Mct' option to specify a color transform");
            }
            try {
                forwCompTransf = new ForwCompTransf(tiler, encoderSpecs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate forward component transformation" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            ImgDataConverter imgDataConverter = new ImgDataConverter(forwCompTransf);
            try {
                forwardWT = ForwardWT.createInstance(imgDataConverter, this.pl, encoderSpecs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate wavelet transform" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                quantizer = Quantizer.createInstance(forwardWT, encoderSpecs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate quantizer" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                rOIScaler = ROIScaler.createInstance(quantizer, this.pl, encoderSpecs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate ROI scaler" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                entropyCoder = EntropyCoder.createInstance(rOIScaler, this.pl, encoderSpecs.cblks, encoderSpecs.pss, encoderSpecs.bms, encoderSpecs.mqrs, encoderSpecs.rts, encoderSpecs.css, encoderSpecs.sss, encoderSpecs.lcs, encoderSpecs.tts);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate entropy coder" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                fileCodestreamWriter = new FileCodestreamWriter(string, Integer.MAX_VALUE);
            }
            catch (IOException iOException) {
                this.error("Could not open output file" + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    iOException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                postCompRateAllocator = PostCompRateAllocator.createInstance(entropyCoder, this.pl, f, fileCodestreamWriter, encoderSpecs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate rate allocator" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            HeaderEncoder headerEncoder = new HeaderEncoder((ImgData)object2, blArray, forwardWT, tiler, encoderSpecs, rOIScaler, postCompRateAllocator, this.pl);
            postCompRateAllocator.setHeaderEncoder(headerEncoder);
            headerEncoder.encodeMainHeader();
            postCompRateAllocator.initialize();
            headerEncoder.reset();
            headerEncoder.encodeMainHeader();
            ((CodestreamWriter)fileCodestreamWriter).commitBitstreamHeader(headerEncoder);
            if (bl6 && this.pl.getFloatParameter("rate") != -1.0f) {
                FacilityManager.getMsgLogger().println("Target bitrate = " + f + " bpp (i.e. " + (int)(f * (float)object2.getImgWidth() * (float)object2.getImgHeight() / 8.0f) + " bytes)", 4, 6);
            }
            postCompRateAllocator.runAndWrite();
            ((CodestreamWriter)fileCodestreamWriter).close();
            int n12 = ((CodestreamWriter)fileCodestreamWriter).getLength();
            if (n7 > 0 || bl2 || bl3) {
                try {
                    object = new CodestreamManipulator(string, n6, n7, bl3, bl2, bl4, bl5);
                    n12 += ((CodestreamManipulator)object).doCodestreamManipulation();
                    String string6 = "";
                    if (n7 > 0) {
                        FacilityManager.getMsgLogger().println("Created tile-parts containing at most " + n7 + " packets per tile.", 4, 6);
                    }
                    if (bl2) {
                        FacilityManager.getMsgLogger().println("Moved packet headers to tile headers", 4, 6);
                    }
                    if (bl3) {
                        FacilityManager.getMsgLogger().println("Moved packet headers to main header", 4, 6);
                    }
                }
                catch (IOException iOException) {
                    this.error("Error while creating tileparts or packed packet headers" + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                    if (this.pl.getParameter("debug").equals("on")) {
                        iOException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
            }
            if (bl) {
                try {
                    int n13 = object2.getNumComps();
                    object = new int[n13];
                    for (int i = 0; i < n13; ++i) {
                        object[i] = object2.getNomRangeBits(i);
                    }
                    FileFormatWriter fileFormatWriter = new FileFormatWriter(string, object2.getImgHeight(), object2.getImgWidth(), n13, (int[])object, n12);
                    n12 += fileFormatWriter.writeFileFormat();
                }
                catch (IOException iOException) {
                    throw new Error("Error while writing JP2 file format");
                }
            }
            if (bl6) {
                FacilityManager.getMsgLogger().println("Achieved bitrate = " + 8.0f * (float)n12 / (float)(object2.getImgWidth() * object2.getImgHeight()) + " bpp (i.e. " + n12 + " bytes)", 4, 6);
                if (this.pl.getParameter("Rroi") != null && !bl && this.pl.getIntParameter("tile_parts") == 0) {
                    int n14 = ((CodestreamWriter)fileCodestreamWriter).getOffLastROIPkt();
                    FacilityManager.getMsgLogger().printmsg(1, "The Region Of Interest is encoded in the first " + n14 + " bytes of the codestream (i.e " + 8.0f * (float)n14 / (float)(object2.getImgWidth() * object2.getImgHeight()) + " bpp)");
                }
                FacilityManager.getMsgLogger().flush();
            }
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                ((ImgReader)objectArray[n5]).close();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error(illegalArgumentException.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                illegalArgumentException.printStackTrace();
            }
            return;
        }
        catch (Error error) {
            this.error("An uncaught error has occurred: " + error.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                error.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
        }
        catch (RuntimeException runtimeException) {
            this.error("An uncaught runtime exception has occurred: " + runtimeException.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                runtimeException.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
        }
        catch (Throwable throwable) {
            this.error("An unchecked exception has occurred: " + throwable.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                throwable.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public static String[][] getAllParameters() {
        int n;
        Vector<String[]> vector = new Vector<String[]>();
        String[][] stringArray = Encoder.getParameterInfo();
        if (stringArray != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = ForwCompTransf.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = AnWTFilter.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = ForwardWT.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = Quantizer.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = ROIScaler.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = EntropyCoder.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = HeaderEncoder.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = PostCompRateAllocator.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = PktEncoder.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = new String[vector.size()][4]) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                stringArray[n] = (String[])vector.elementAt(n);
            }
        }
        return stringArray;
    }

    private void error(String string, int n) {
        this.exitCode = n;
        FacilityManager.getMsgLogger().printmsg(3, string);
    }

    private void warning(String string) {
        FacilityManager.getMsgLogger().printmsg(2, string);
    }

    private void printVersionAndCopyright() {
        FacilityManager.getMsgLogger().println("JJ2000's JPEG 2000 Encoder\n", 2, 4);
        FacilityManager.getMsgLogger().println("Version: 5.1\n", 2, 4);
        FacilityManager.getMsgLogger().println("Copyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\n", 2, 4);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printUsage() {
        MsgLogger msgLogger = FacilityManager.getMsgLogger();
        msgLogger.println("Usage:", 0, 0);
        msgLogger.println("JJ2KEncoder args...\n", 10, 12);
        msgLogger.println("The exit code of the encoder is non-zero if an error occurs.\n", 2, 4);
        msgLogger.println("Note: Many encoder modules accept tile-component specific parameters. These parameters must be provided according to the pattern:\n \"[<tile-component idx>] <param>\" (repeated as many time as needed). ", 2, 4);
        msgLogger.println("\n<tile-component idx> respect the following policy according to the degree of priority: \n  (1) t<idx> c<idx> : Tile-component specification.\n  (2) t<idx> : Tile specification.\n  (3) c<idx> : Component specification\n  (4) <void> : Default specification.\n\nWhere the priorities of the specifications are:\n(1) > (2) > (3) > (4), ('>' means \"overrides\")\n", 2, 4);
        msgLogger.println("  <idx>: ',' separates indexes, '-' separates bounds of indexes list. (ex: 0,2-4 means indexes 0,2,3 and  4).\n", 2, 4);
        msgLogger.println("The following arguments are recognized:", 2, 4);
        this.printParamInfo(msgLogger, Encoder.getAllParameters());
        FacilityManager.getMsgLogger().println("\n\n", 0, 0);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printParamInfo(MsgLogger msgLogger, String[][] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.defpl.getParameter(stringArray[i][0]);
            if (string != null) {
                msgLogger.println("-" + stringArray[i][0] + (stringArray[i][1] != null ? " " + stringArray[i][1] + " " : " ") + "(default = " + string + ")", 4, 8);
            } else {
                msgLogger.println("-" + stringArray[i][0] + (stringArray[i][1] != null ? " " + stringArray[i][1] : ""), 4, 8);
            }
            if (stringArray[i][2] == null) continue;
            msgLogger.println(stringArray[i][2], 6, 6);
        }
    }
}

