/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class FileBitstreamReaderAgent
extends BitstreamReaderAgent
implements Markers,
ProgressionType,
StdEntropyCoderOptions {
    private boolean isPsotEqualsZero = true;
    public PktDecoder pktDec;
    private ParameterList pl;
    private RandomAccessIO in;
    private int[][] firstPackOff;
    private int[] nBytes;
    private boolean printInfo = false;
    private int[] baknBytes;
    private int[][] tilePartLen;
    private int[] totTileLen;
    private int[] totTileHeadLen;
    private int firstTilePartHeadLen;
    private double totAllTileLen;
    private int mainHeadLen;
    private int headLen = 0;
    private int[][] tilePartHeadLen;
    private Vector pktHL;
    private boolean isTruncMode;
    private int remainingTileParts;
    private int[] tilePartsRead;
    private int totTilePartsRead = 0;
    private int[] tileParts;
    private int curTilePart;
    private int[][] tilePartNum;
    private boolean isEOCFound = false;
    private HeaderInfo hi;
    private CBlkInfo[][][][][] cbI;
    private int lQuit;
    private boolean usePOCQuit = false;

    public int getNumTileParts(int n) {
        if (this.firstPackOff == null || this.firstPackOff[n] == null) {
            throw new Error("Tile " + n + " not found in input codestream.");
        }
        return this.firstPackOff[n].length;
    }

    public CBlkInfo[][][][][] getCBlkInfo() {
        return this.cbI;
    }

    public FileBitstreamReaderAgent(HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, DecoderSpecs decoderSpecs, ParameterList parameterList, boolean bl, HeaderInfo headerInfo) throws IOException {
        super(headerDecoder, decoderSpecs);
        int n;
        this.pl = parameterList;
        this.printInfo = bl;
        this.hi = headerInfo;
        String string = "Codestream elements information in bytes (offset, total length, header length):\n\n";
        this.usePOCQuit = parameterList.getBooleanParameter("poc_quit");
        boolean bl2 = parameterList.getBooleanParameter("parsing");
        try {
            this.trate = parameterList.getFloatParameter("rate");
            if (this.trate == -1.0f) {
                this.trate = Float.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Invalid value in 'rate' option: " + parameterList.getParameter("rate"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("'rate' option is missing");
        }
        try {
            this.tnbytes = parameterList.getIntParameter("nbytes");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Invalid value in 'nbytes' option: " + parameterList.getParameter("nbytes"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("'nbytes' option is missing");
        }
        ParameterList parameterList2 = parameterList.getDefaultParameterList();
        boolean bl3 = (float)this.tnbytes != parameterList2.getFloatParameter("nbytes");
        if (bl3) {
            this.trate = (float)this.tnbytes * 8.0f / (float)headerDecoder.getMaxCompImgWidth() / (float)headerDecoder.getMaxCompImgHeight();
        } else {
            this.tnbytes = (int)(this.trate * (float)headerDecoder.getMaxCompImgWidth() * (float)headerDecoder.getMaxCompImgHeight()) / 8;
        }
        this.isTruncMode = !parameterList.getBooleanParameter("parsing");
        try {
            n = parameterList.getIntParameter("ncb_quit");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Invalid value in 'ncb_quit' option: " + parameterList.getParameter("ncb_quit"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("'ncb_quit' option is missing");
        }
        if (n != -1 && !this.isTruncMode) {
            throw new Error("Cannot use -parsing and -ncb_quit condition at the same time.");
        }
        try {
            this.lQuit = parameterList.getIntParameter("l_quit");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Invalid value in 'l_quit' option: " + parameterList.getParameter("l_quit"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("'l_quit' option is missing");
        }
        this.in = randomAccessIO;
        this.pktDec = new PktDecoder(decoderSpecs, headerDecoder, randomAccessIO, this, this.isTruncMode, n);
        this.tileParts = new int[this.nt];
        this.totTileLen = new int[this.nt];
        this.tilePartLen = new int[this.nt][];
        this.tilePartNum = new int[this.nt][];
        this.firstPackOff = new int[this.nt][];
        this.tilePartsRead = new int[this.nt];
        this.totTileHeadLen = new int[this.nt];
        this.tilePartHeadLen = new int[this.nt][];
        this.nBytes = new int[this.nt];
        this.baknBytes = new int[this.nt];
        headerDecoder.nTileParts = new int[this.nt];
        this.isTruncMode = this.isTruncMode;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = headerDecoder.mainHeadOff;
        this.headLen = this.mainHeadLen = this.in.getPos() - n5;
        this.anbytes = n == -1 ? this.mainHeadLen : 0;
        string = string + "Main header length    : " + n5 + ", " + this.mainHeadLen + ", " + this.mainHeadLen + "\n";
        if (this.anbytes > this.tnbytes) {
            throw new Error("Requested bitrate is too small.");
        }
        boolean bl4 = false;
        boolean bl5 = false;
        this.totAllTileLen = 0.0;
        this.remainingTileParts = this.nt;
        int n6 = this.nt;
        try {
            while (this.remainingTileParts != 0) {
                int n7 = this.in.getPos();
                try {
                    n2 = this.readTilePartHeader();
                    if (this.isEOCFound) break;
                    n3 = this.tilePartsRead[n2];
                    if (this.isPsotEqualsZero) {
                        this.tilePartLen[n2][n3] = this.in.length() - 2 - n7;
                    }
                }
                catch (EOFException eOFException) {
                    this.firstPackOff[n2][n3] = this.in.length();
                    throw eOFException;
                }
                int n8 = this.in.getPos();
                if (this.isTruncMode && n == -1 && n8 - n5 > this.tnbytes) {
                    this.firstPackOff[n2][n3] = this.in.length();
                    bl4 = true;
                    break;
                }
                this.firstPackOff[n2][n3] = n8;
                this.tilePartHeadLen[n2][n3] = n8 - n7;
                string = string + "Tile-part " + n3 + " of tile " + n2 + " : " + n7 + ", " + this.tilePartLen[n2][n3] + ", " + this.tilePartHeadLen[n2][n3] + "\n";
                int n9 = n2;
                this.totTileLen[n9] = this.totTileLen[n9] + this.tilePartLen[n2][n3];
                int n10 = n2;
                this.totTileHeadLen[n10] = this.totTileHeadLen[n10] + this.tilePartHeadLen[n2][n3];
                this.totAllTileLen += (double)this.tilePartLen[n2][n3];
                if (this.isTruncMode) {
                    if (this.anbytes + this.tilePartLen[n2][n3] > this.tnbytes) {
                        this.anbytes += this.tilePartHeadLen[n2][n3];
                        this.headLen += this.tilePartHeadLen[n2][n3];
                        bl4 = true;
                        int n11 = n2;
                        this.nBytes[n11] = this.nBytes[n11] + (this.tnbytes - this.anbytes);
                        break;
                    }
                    this.anbytes += this.tilePartHeadLen[n2][n3];
                    this.headLen += this.tilePartHeadLen[n2][n3];
                    int n12 = n2;
                    this.nBytes[n12] = this.nBytes[n12] + (this.tilePartLen[n2][n3] - this.tilePartHeadLen[n2][n3]);
                } else {
                    if (this.anbytes + this.tilePartHeadLen[n2][n3] > this.tnbytes) break;
                    this.anbytes += this.tilePartHeadLen[n2][n3];
                    this.headLen += this.tilePartHeadLen[n2][n3];
                }
                if (n4 == 0) {
                    this.firstTilePartHeadLen = this.tilePartHeadLen[n2][n3];
                }
                int n13 = n2;
                this.tilePartsRead[n13] = this.tilePartsRead[n13] + 1;
                this.in.seek(n7 + this.tilePartLen[n2][n3]);
                --this.remainingTileParts;
                --n6;
                ++n4;
                if (!this.isPsotEqualsZero) continue;
                if (this.remainingTileParts != 0) {
                    FacilityManager.getMsgLogger().printmsg(2, "Some tile-parts have not been found. The codestream may be corrupted.");
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            if (this.printInfo) {
                FacilityManager.getMsgLogger().printmsg(1, string);
            }
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + n2);
            int n14 = this.in.length();
            if (n14 < this.tnbytes) {
                this.tnbytes = n14;
                this.trate = (float)this.tnbytes * 8.0f / (float)headerDecoder.getMaxCompImgWidth() / (float)headerDecoder.getMaxCompImgHeight();
            }
            if (!this.isTruncMode) {
                this.allocateRate();
            }
            if (parameterList.getParameter("res") == null) {
                this.targetRes = decoderSpecs.dls.getMin();
            } else {
                try {
                    this.targetRes = parameterList.getIntParameter("res");
                    if (this.targetRes < 0) {
                        throw new IllegalArgumentException("Specified negative resolution level index: " + this.targetRes);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid resolution level index ('-res' option) " + parameterList.getParameter("res"));
                }
            }
            int n15 = decoderSpecs.dls.getMin();
            if (this.targetRes > n15) {
                FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.targetRes + ") is larger" + " than the maximum value. Setting it to " + n15 + " (maximum value)");
                this.targetRes = n15;
            }
            for (int i = 0; i < this.nt; ++i) {
                this.baknBytes[i] = this.nBytes[i];
            }
            return;
        }
        this.remainingTileParts = 0;
        if (parameterList.getParameter("res") == null) {
            this.targetRes = decoderSpecs.dls.getMin();
        } else {
            try {
                this.targetRes = parameterList.getIntParameter("res");
                if (this.targetRes < 0) {
                    throw new IllegalArgumentException("Specified negative resolution level index: " + this.targetRes);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid resolution level index ('-res' option) " + parameterList.getParameter("res"));
            }
        }
        int n16 = decoderSpecs.dls.getMin();
        if (this.targetRes > n16) {
            FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.targetRes + ") is larger" + " than the maximum possible. Setting it to " + n16 + " (maximum possible)");
            this.targetRes = n16;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        if (!this.isEOCFound && !this.isPsotEqualsZero) {
            try {
                if (!bl4 && !this.isPsotEqualsZero && this.in.readShort() != -39) {
                    FacilityManager.getMsgLogger().printmsg(2, "EOC marker not found. Codestream is corrupted.");
                }
            }
            catch (EOFException eOFException) {
                FacilityManager.getMsgLogger().printmsg(2, "EOC marker is missing");
            }
        }
        if (!this.isTruncMode) {
            this.allocateRate();
        } else if (this.in.getPos() >= this.tnbytes) {
            this.anbytes += 2;
        }
        for (int i = 0; i < this.nt; ++i) {
            this.baknBytes[i] = this.nBytes[i];
            if (!this.printInfo) continue;
            FacilityManager.getMsgLogger().println("" + headerInfo.toStringTileHeader(i, this.tilePartLen[i].length), 2, 2);
        }
    }

    private void allocateRate() {
        int n;
        int n2 = this.tnbytes;
        this.anbytes += 2;
        if (this.anbytes > n2) {
            throw new Error("Requested bitrate is too small for parsing");
        }
        int n3 = n = n2 - this.anbytes;
        for (int i = this.nt - 1; i > 0; --i) {
            this.nBytes[i] = (int)((double)n3 * ((double)this.totTileLen[i] / this.totAllTileLen));
            n -= this.nBytes[i];
        }
        this.nBytes[0] = n;
    }

    private int readTilePartHeader() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        HeaderInfo.SOT sOT = this.hi.getNewSOT();
        short s = this.in.readShort();
        if (s != -112) {
            if (s == -39) {
                this.isEOCFound = true;
                return -1;
            }
            throw new CorruptedCodestreamException("SOT tag not found in tile-part start");
        }
        this.isEOCFound = false;
        sOT.lsot = n5 = this.in.readUnsignedShort();
        if (n5 != 10) {
            throw new CorruptedCodestreamException("Wrong length for SOT marker segment: " + n5);
        }
        sOT.isot = n4 = this.in.readUnsignedShort();
        if (n4 > 65534) {
            throw new CorruptedCodestreamException("Tile index too high in tile-part.");
        }
        sOT.psot = n3 = this.in.readInt();
        boolean bl = this.isPsotEqualsZero = n3 == 0;
        if (n3 < 0) {
            throw new NotImplementedError("Tile length larger than maximum supported");
        }
        sOT.tpsot = n2 = this.in.read();
        if (n2 != this.tilePartsRead[n4] || n2 < 0 || n2 > 254) {
            throw new CorruptedCodestreamException("Out of order tile-part");
        }
        sOT.tnsot = n = this.in.read();
        this.hi.sot.put("t" + n4 + "_tp" + n2, sOT);
        if (n == 0) {
            int n6;
            int n7;
            if (this.tileParts[n4] == 0 || this.tileParts[n4] == this.tilePartLen.length) {
                n7 = 2;
                ++this.remainingTileParts;
            } else {
                n7 = 1;
            }
            int n8 = n4;
            this.tileParts[n8] = this.tileParts[n8] + n7;
            n = this.tileParts[n4];
            FacilityManager.getMsgLogger().printmsg(2, "Header of tile-part " + n2 + " of tile " + n4 + ", does not indicate the total" + " number of tile-parts. Assuming that there are " + n + " tile-parts for this tile.");
            int[] nArray = this.tilePartLen[n4];
            this.tilePartLen[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.tilePartLen[n4][n6] = nArray[n6];
            }
            nArray = this.tilePartNum[n4];
            this.tilePartNum[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.tilePartNum[n4][n6] = nArray[n6];
            }
            nArray = this.firstPackOff[n4];
            this.firstPackOff[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.firstPackOff[n4][n6] = nArray[n6];
            }
            nArray = this.tilePartHeadLen[n4];
            this.tilePartHeadLen[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.tilePartHeadLen[n4][n6] = nArray[n6];
            }
        } else if (this.tileParts[n4] == 0) {
            this.remainingTileParts += n - 1;
            this.tileParts[n4] = n;
            this.tilePartLen[n4] = new int[n];
            this.tilePartNum[n4] = new int[n];
            this.firstPackOff[n4] = new int[n];
            this.tilePartHeadLen[n4] = new int[n];
        } else {
            if (this.tileParts[n4] > n) {
                throw new CorruptedCodestreamException("Invalid number of tile-parts in tile " + n4 + ": " + n);
            }
            this.remainingTileParts += n - this.tileParts[n4];
            if (this.tileParts[n4] != n) {
                int n9;
                int[] nArray = this.tilePartLen[n4];
                this.tilePartLen[n4] = new int[n];
                for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                    this.tilePartLen[n4][n9] = nArray[n9];
                }
                nArray = this.tilePartNum[n4];
                this.tilePartNum[n4] = new int[n];
                for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                    this.tilePartNum[n4][n9] = nArray[n9];
                }
                nArray = this.firstPackOff[n4];
                this.firstPackOff[n4] = new int[n];
                for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                    this.firstPackOff[n4][n9] = nArray[n9];
                }
                nArray = this.tilePartHeadLen[n4];
                this.tilePartHeadLen[n4] = new int[n];
                for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                    this.tilePartHeadLen[n4][n9] = nArray[n9];
                }
            }
        }
        this.hd.resetHeaderMarkers();
        this.hd.nTileParts[n4] = n;
        do {
            this.hd.extractTilePartMarkSeg(this.in.readShort(), this.in, n4, n2);
        } while ((this.hd.getNumFoundMarkSeg() & 0x2000) == 0);
        this.hd.readFoundTilePartMarkSeg(n4, n2);
        this.tilePartLen[n4][n2] = n3;
        this.tilePartNum[n4][n2] = this.totTilePartsRead++;
        this.hd.setTileOfTileParts(n4);
        return n4;
    }

    private boolean readLyResCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7;
        int n8 = 10000;
        for (n7 = n4; n7 < n5; ++n7) {
            if (n7 >= this.mdl.length) continue;
            for (n6 = n2; n6 < n3; ++n6) {
                if (nArray[n7] == null || n6 >= nArray[n7].length || nArray[n7][n6] >= n8) continue;
                n8 = nArray[n7][n6];
            }
        }
        n7 = this.getTileIdx();
        boolean bl = false;
        int n9 = this.firstPackOff[n7][this.curTilePart] + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
        int n10 = (Integer)this.decSpec.nls.getTileDef(n7);
        int n11 = 1;
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl2 = true;
        }
        for (int i = n8; i < n; ++i) {
            for (int j = n2; j < n3; ++j) {
                for (int k = n4; k < n5; ++k) {
                    if (k >= this.mdl.length || j >= nArray[k].length || j > this.mdl[k] || i < nArray[k][j] || i >= n10) continue;
                    n11 = this.pktDec.getNumPrecinct(k, j);
                    for (int i2 = 0; i2 < n11; ++i2) {
                        n6 = this.in.getPos();
                        if (bl2) {
                            this.pktDec.readPktHead(i, j, k, i2, this.cbI[k][j], this.nBytes);
                        }
                        if (n6 > n9 && this.curTilePart < this.firstPackOff[n7].length - 1) {
                            ++this.curTilePart;
                            this.in.seek(this.firstPackOff[n7][this.curTilePart]);
                            n9 = this.in.getPos() + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
                        }
                        if (bl = this.pktDec.readSOPMarker(this.nBytes, i2, k, j)) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        if (!bl2) {
                            bl = this.pktDec.readPktHead(i, j, k, i2, this.cbI[k][j], this.nBytes);
                        }
                        if (bl) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int n12 = this.in.getPos() - n6;
                        this.pktHL.addElement(new Integer(n12));
                        bl = this.pktDec.readPktBody(i, j, k, i2, this.cbI[k][j], this.nBytes);
                        int n13 = this.in.getPos() - n6;
                        string = string + " Pkt l=" + i + ",r=" + j + ",c=" + k + ",p=" + i2 + ": " + n6 + ", " + n13 + ", " + n12 + "\n";
                        if (!bl) continue;
                        if (this.printInfo) {
                            FacilityManager.getMsgLogger().printmsg(1, string);
                        }
                        return true;
                    }
                }
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResLyCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7 = this.getTileIdx();
        boolean bl = false;
        int n8 = this.firstPackOff[n7][this.curTilePart] + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
        int n9 = 10000;
        for (int i = n4; i < n5; ++i) {
            if (i >= this.mdl.length) continue;
            for (n6 = n2; n6 < n3; ++n6) {
                if (n6 > this.mdl[i] || nArray[i] == null || n6 >= nArray[i].length || nArray[i][n6] >= n9) continue;
                n9 = nArray[i][n6];
            }
        }
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        n6 = (Integer)this.decSpec.nls.getTileDef(n7);
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl2 = true;
        }
        int n10 = 1;
        for (int i = n2; i < n3; ++i) {
            for (int j = n9; j < n; ++j) {
                for (int k = n4; k < n5; ++k) {
                    if (k >= this.mdl.length || i > this.mdl[k] || i >= nArray[k].length || j < nArray[k][i] || j >= n6) continue;
                    n10 = this.pktDec.getNumPrecinct(k, i);
                    for (int i2 = 0; i2 < n10; ++i2) {
                        int n11 = this.in.getPos();
                        if (bl2) {
                            this.pktDec.readPktHead(j, i, k, i2, this.cbI[k][i], this.nBytes);
                        }
                        if (n11 > n8 && this.curTilePart < this.firstPackOff[n7].length - 1) {
                            ++this.curTilePart;
                            this.in.seek(this.firstPackOff[n7][this.curTilePart]);
                            n8 = this.in.getPos() + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
                        }
                        if (bl = this.pktDec.readSOPMarker(this.nBytes, i2, k, i)) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        if (!bl2) {
                            bl = this.pktDec.readPktHead(j, i, k, i2, this.cbI[k][i], this.nBytes);
                        }
                        if (bl) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int n12 = this.in.getPos() - n11;
                        this.pktHL.addElement(new Integer(n12));
                        bl = this.pktDec.readPktBody(j, i, k, i2, this.cbI[k][i], this.nBytes);
                        int n13 = this.in.getPos() - n11;
                        string = string + " Pkt l=" + j + ",r=" + i + ",c=" + k + ",p=" + i2 + ": " + n11 + ", " + n13 + ", " + n12 + "\n";
                        if (!bl) continue;
                        if (this.printInfo) {
                            FacilityManager.getMsgLogger().printmsg(1, string);
                        }
                        return true;
                    }
                }
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResPosCompLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        int n7;
        Coord coord = this.getNumTiles(null);
        Coord coord2 = this.getTile(null);
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = n8 + this.hd.getImgWidth();
        int n11 = n9 + this.hd.getImgHeight();
        int n12 = this.getTilePartULX();
        int n13 = this.getTilePartULY();
        int n14 = this.getNomTileWidth();
        int n15 = this.getNomTileHeight();
        int n16 = coord2.x == 0 ? n8 : n12 + coord2.x * n14;
        int n17 = coord2.y == 0 ? n9 : n13 + coord2.y * n15;
        int n18 = coord2.x != coord.x - 1 ? n12 + (coord2.x + 1) * n14 : n10;
        int n19 = coord2.y != coord.y - 1 ? n13 + (coord2.y + 1) * n15 : n11;
        int n20 = this.getTileIdx();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[][] nArrayArray = new int[n5][];
        int n24 = 100000;
        int n25 = n18;
        int n26 = n19;
        int n27 = n16;
        int n28 = n17;
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                if (n7 >= this.mdl.length || n6 > this.mdl[n7]) continue;
                nArrayArray[n7] = new int[this.mdl[n7] + 1];
                if (nArray[n7] != null && n6 < nArray[n7].length && nArray[n7][n6] < n24) {
                    n24 = nArray[n7][n6];
                }
                for (int i = this.pktDec.getNumPrecinct(n7, n6) - 1; i >= 0; --i) {
                    precInfo = this.pktDec.getPrecInfo(n7, n6, i);
                    if (precInfo.rgulx != n16) {
                        if (precInfo.rgulx < n25) {
                            n25 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n27) {
                            n27 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n17) {
                        if (precInfo.rguly < n26) {
                            n26 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n28) {
                            n28 = precInfo.rguly;
                        }
                    }
                    if (n23 == 0) {
                        n21 = precInfo.rgw;
                        n22 = precInfo.rgh;
                    } else {
                        n21 = MathUtil.gcd(n21, precInfo.rgw);
                        n22 = MathUtil.gcd(n22, precInfo.rgh);
                    }
                    ++n23;
                }
            }
        }
        if (n23 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n7 = (n28 - n26) / n22 + 1;
        n6 = (n27 - n25) / n21 + 1;
        boolean bl = false;
        int n29 = this.firstPackOff[n20][this.curTilePart] + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n20);
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n20)).booleanValue()) {
            bl2 = true;
        }
        for (int i = n2; i < n3; ++i) {
            int n31 = n17;
            int n32 = n16;
            for (int j = 0; j <= n7; ++j) {
                for (int k = 0; k <= n6; ++k) {
                    for (int i2 = n4; i2 < n5; ++i2) {
                        if (i2 >= this.mdl.length || i > this.mdl[i2] || nArrayArray[i2][i] >= this.pktDec.getNumPrecinct(i2, i)) continue;
                        precInfo = this.pktDec.getPrecInfo(i2, i, nArrayArray[i2][i]);
                        if (precInfo.rgulx != n32 || precInfo.rguly != n31) continue;
                        for (int i3 = n24; i3 < n; ++i3) {
                            if (i >= nArray[i2].length || i3 < nArray[i2][i] || i3 >= n30) continue;
                            int n33 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(i3, i, i2, nArrayArray[i2][i], this.cbI[i2][i], this.nBytes);
                            }
                            if (n33 > n29 && this.curTilePart < this.firstPackOff[n20].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n20][this.curTilePart]);
                                n29 = this.in.getPos() + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[i2][i], i2, i)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(i3, i, i2, nArrayArray[i2][i], this.cbI[i2][i], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n34 = this.in.getPos() - n33;
                            this.pktHL.addElement(new Integer(n34));
                            bl = this.pktDec.readPktBody(i3, i, i2, nArrayArray[i2][i], this.cbI[i2][i], this.nBytes);
                            int n35 = this.in.getPos() - n33;
                            string = string + " Pkt l=" + i3 + ",r=" + i + ",c=" + i2 + ",p=" + nArrayArray[i2][i] + ": " + n33 + ", " + n35 + ", " + n34 + "\n";
                            if (!bl) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int[] nArray2 = nArrayArray[i2];
                        int n36 = i;
                        nArray2[n36] = nArray2[n36] + 1;
                    }
                    n32 = k != n6 ? n25 + k * n21 : n16;
                }
                n31 = j != n7 ? n26 + j * n22 : n17;
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readPosCompResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        int n7;
        Coord coord = this.getNumTiles(null);
        Coord coord2 = this.getTile(null);
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = n8 + this.hd.getImgWidth();
        int n11 = n9 + this.hd.getImgHeight();
        int n12 = this.getTilePartULX();
        int n13 = this.getTilePartULY();
        int n14 = this.getNomTileWidth();
        int n15 = this.getNomTileHeight();
        int n16 = coord2.x == 0 ? n8 : n12 + coord2.x * n14;
        int n17 = coord2.y == 0 ? n9 : n13 + coord2.y * n15;
        int n18 = coord2.x != coord.x - 1 ? n12 + (coord2.x + 1) * n14 : n10;
        int n19 = coord2.y != coord.y - 1 ? n13 + (coord2.y + 1) * n15 : n11;
        int n20 = this.getTileIdx();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[][] nArrayArray = new int[n5][];
        int n24 = 100000;
        int n25 = n18;
        int n26 = n19;
        int n27 = n16;
        int n28 = n17;
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                if (n7 >= this.mdl.length || n6 > this.mdl[n7]) continue;
                nArrayArray[n7] = new int[this.mdl[n7] + 1];
                if (nArray[n7] != null && n6 < nArray[n7].length && nArray[n7][n6] < n24) {
                    n24 = nArray[n7][n6];
                }
                for (int i = this.pktDec.getNumPrecinct(n7, n6) - 1; i >= 0; --i) {
                    precInfo = this.pktDec.getPrecInfo(n7, n6, i);
                    if (precInfo.rgulx != n16) {
                        if (precInfo.rgulx < n25) {
                            n25 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n27) {
                            n27 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n17) {
                        if (precInfo.rguly < n26) {
                            n26 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n28) {
                            n28 = precInfo.rguly;
                        }
                    }
                    if (n23 == 0) {
                        n21 = precInfo.rgw;
                        n22 = precInfo.rgh;
                    } else {
                        n21 = MathUtil.gcd(n21, precInfo.rgw);
                        n22 = MathUtil.gcd(n22, precInfo.rgh);
                    }
                    ++n23;
                }
            }
        }
        if (n23 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n7 = (n28 - n26) / n22 + 1;
        n6 = (n27 - n25) / n21 + 1;
        boolean bl = false;
        int n29 = this.firstPackOff[n20][this.curTilePart] + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n20);
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n20)).booleanValue()) {
            bl2 = true;
        }
        int n31 = n17;
        int n32 = n16;
        for (int i = 0; i <= n7; ++i) {
            for (int j = 0; j <= n6; ++j) {
                for (int k = n4; k < n5; ++k) {
                    if (k >= this.mdl.length) continue;
                    for (int i2 = n2; i2 < n3; ++i2) {
                        if (i2 > this.mdl[k] || nArrayArray[k][i2] >= this.pktDec.getNumPrecinct(k, i2)) continue;
                        precInfo = this.pktDec.getPrecInfo(k, i2, nArrayArray[k][i2]);
                        if (precInfo.rgulx != n32 || precInfo.rguly != n31) continue;
                        for (int i3 = n24; i3 < n; ++i3) {
                            if (i2 >= nArray[k].length || i3 < nArray[k][i2] || i3 >= n30) continue;
                            int n33 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(i3, i2, k, nArrayArray[k][i2], this.cbI[k][i2], this.nBytes);
                            }
                            if (n33 > n29 && this.curTilePart < this.firstPackOff[n20].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n20][this.curTilePart]);
                                n29 = this.in.getPos() + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[k][i2], k, i2)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(i3, i2, k, nArrayArray[k][i2], this.cbI[k][i2], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n34 = this.in.getPos() - n33;
                            this.pktHL.addElement(new Integer(n34));
                            bl = this.pktDec.readPktBody(i3, i2, k, nArrayArray[k][i2], this.cbI[k][i2], this.nBytes);
                            int n35 = this.in.getPos() - n33;
                            string = string + " Pkt l=" + i3 + ",r=" + i2 + ",c=" + k + ",p=" + nArrayArray[k][i2] + ": " + n33 + ", " + n35 + ", " + n34 + "\n";
                            if (!bl) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int[] nArray2 = nArrayArray[k];
                        int n36 = i2;
                        nArray2[n36] = nArray2[n36] + 1;
                    }
                }
                n32 = j != n6 ? n25 + j * n21 : n16;
            }
            n31 = i != n7 ? n26 + i * n22 : n17;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readCompPosResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        int n7;
        Coord coord = this.getNumTiles(null);
        Coord coord2 = this.getTile(null);
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = n8 + this.hd.getImgWidth();
        int n11 = n9 + this.hd.getImgHeight();
        int n12 = this.getTilePartULX();
        int n13 = this.getTilePartULY();
        int n14 = this.getNomTileWidth();
        int n15 = this.getNomTileHeight();
        int n16 = coord2.x == 0 ? n8 : n12 + coord2.x * n14;
        int n17 = coord2.y == 0 ? n9 : n13 + coord2.y * n15;
        int n18 = coord2.x != coord.x - 1 ? n12 + (coord2.x + 1) * n14 : n10;
        int n19 = coord2.y != coord.y - 1 ? n13 + (coord2.y + 1) * n15 : n11;
        int n20 = this.getTileIdx();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[][] nArrayArray = new int[n5][];
        int n24 = 100000;
        int n25 = n18;
        int n26 = n19;
        int n27 = n16;
        int n28 = n17;
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                if (n7 >= this.mdl.length || n6 > this.mdl[n7]) continue;
                nArrayArray[n7] = new int[this.mdl[n7] + 1];
                if (nArray[n7] != null && n6 < nArray[n7].length && nArray[n7][n6] < n24) {
                    n24 = nArray[n7][n6];
                }
                for (int i = this.pktDec.getNumPrecinct(n7, n6) - 1; i >= 0; --i) {
                    precInfo = this.pktDec.getPrecInfo(n7, n6, i);
                    if (precInfo.rgulx != n16) {
                        if (precInfo.rgulx < n25) {
                            n25 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n27) {
                            n27 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n17) {
                        if (precInfo.rguly < n26) {
                            n26 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n28) {
                            n28 = precInfo.rguly;
                        }
                    }
                    if (n23 == 0) {
                        n21 = precInfo.rgw;
                        n22 = precInfo.rgh;
                    } else {
                        n21 = MathUtil.gcd(n21, precInfo.rgw);
                        n22 = MathUtil.gcd(n22, precInfo.rgh);
                    }
                    ++n23;
                }
            }
        }
        if (n23 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n7 = (n28 - n26) / n22 + 1;
        n6 = (n27 - n25) / n21 + 1;
        boolean bl = false;
        int n29 = this.firstPackOff[n20][this.curTilePart] + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n20);
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n";
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n20)).booleanValue()) {
            bl2 = true;
        }
        for (int i = n4; i < n5; ++i) {
            if (i >= this.mdl.length) continue;
            int n31 = n17;
            int n32 = n16;
            for (int j = 0; j <= n7; ++j) {
                for (int k = 0; k <= n6; ++k) {
                    for (int i2 = n2; i2 < n3; ++i2) {
                        if (i2 > this.mdl[i] || nArrayArray[i][i2] >= this.pktDec.getNumPrecinct(i, i2)) continue;
                        precInfo = this.pktDec.getPrecInfo(i, i2, nArrayArray[i][i2]);
                        if (precInfo.rgulx != n32 || precInfo.rguly != n31) continue;
                        for (int i3 = n24; i3 < n; ++i3) {
                            if (i2 >= nArray[i].length || i3 < nArray[i][i2]) continue;
                            int n33 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(i3, i2, i, nArrayArray[i][i2], this.cbI[i][i2], this.nBytes);
                            }
                            if (n33 > n29 && this.curTilePart < this.firstPackOff[n20].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n20][this.curTilePart]);
                                n29 = this.in.getPos() + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[i][i2], i, i2)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(i3, i2, i, nArrayArray[i][i2], this.cbI[i][i2], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n34 = this.in.getPos() - n33;
                            this.pktHL.addElement(new Integer(n34));
                            bl = this.pktDec.readPktBody(i3, i2, i, nArrayArray[i][i2], this.cbI[i][i2], this.nBytes);
                            int n35 = this.in.getPos() - n33;
                            string = string + " Pkt l=" + i3 + ",r=" + i2 + ",c=" + i + ",p=" + nArrayArray[i][i2] + ": " + n33 + ", " + n35 + ", " + n34 + "\n";
                            if (!bl) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int[] nArray2 = nArrayArray[i];
                        int n36 = i2;
                        nArray2[n36] = nArray2[n36] + 1;
                    }
                    n32 = k != n6 ? n25 + k * n21 : n16;
                }
                n31 = j != n7 ? n26 + j * n22 : n17;
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private void readTilePkts(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        Object object;
        this.pktHL = new Vector();
        int n5 = (Integer)this.decSpec.nls.getTileDef(n);
        if (((Boolean)this.decSpec.pphs.getTileDef(n)).booleanValue()) {
            object = this.hd.getPackedPktHead(n);
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n5, this.cbI, true, (ByteArrayInputStream)object);
        } else {
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n5, this.cbI, false, null);
        }
        object = (int[][])this.decSpec.pcs.getTileDef(n);
        int n6 = object == null ? 1 : ((Object)object).length;
        int[][] nArray = new int[n6][6];
        int n7 = 0;
        nArray[0][1] = 0;
        if (object == null) {
            nArray[n7][0] = (Integer)this.decSpec.pos.getTileDef(n);
            nArray[n7][1] = n5;
            nArray[n7][2] = 0;
            nArray[n7][3] = this.decSpec.dls.getMaxInTile(n) + 1;
            nArray[n7][4] = 0;
            nArray[n7][5] = this.nc;
        } else {
            for (n7 = 0; n7 < n6; ++n7) {
                nArray[n7][0] = (int)object[n7][5];
                nArray[n7][1] = (int)object[n7][2];
                nArray[n7][2] = (int)object[n7][0];
                nArray[n7][3] = (int)object[n7][3];
                nArray[n7][4] = (int)object[n7][1];
                nArray[n7][5] = (int)object[n7][4];
            }
        }
        try {
            if (this.isTruncMode && this.firstPackOff == null || this.firstPackOff[n] == null) {
                return;
            }
            this.in.seek(this.firstPackOff[n][0]);
        }
        catch (EOFException eOFException) {
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + n);
            return;
        }
        this.curTilePart = 0;
        boolean bl = false;
        int n8 = this.nBytes[n];
        int[][] nArrayArray = new int[this.nc][];
        for (n4 = 0; n4 < this.nc; ++n4) {
            nArrayArray[n4] = new int[(Integer)this.decSpec.dls.getTileCompVal(n, n4) + 1];
        }
        for (n4 = 0; n4 < n6; ++n4) {
            int n9 = nArray[n4][1];
            int n10 = nArray[n4][2];
            int n11 = nArray[n4][3];
            int n12 = nArray[n4][4];
            int n13 = nArray[n4][5];
            switch (nArray[n4][0]) {
                case 0: {
                    bl = this.readLyResCompPos(nArrayArray, n9, n10, n11, n12, n13);
                    break;
                }
                case 1: {
                    bl = this.readResLyCompPos(nArrayArray, n9, n10, n11, n12, n13);
                    break;
                }
                case 2: {
                    bl = this.readResPosCompLy(nArrayArray, n9, n10, n11, n12, n13);
                    break;
                }
                case 3: {
                    bl = this.readPosCompResLy(nArrayArray, n9, n10, n11, n12, n13);
                    break;
                }
                case 4: {
                    bl = this.readCompPosResLy(nArrayArray, n9, n10, n11, n12, n13);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not recognized progression type");
                }
            }
            for (n3 = n12; n3 < n13; ++n3) {
                if (n3 >= nArrayArray.length) continue;
                for (n2 = n10; n2 < n11; ++n2) {
                    if (n2 >= nArrayArray[n3].length) continue;
                    nArrayArray[n3][n2] = n9;
                }
            }
            if (!bl && !this.usePOCQuit) {
                continue;
            }
            break;
        }
        if (this.isTruncMode) {
            this.anbytes += n8 - this.nBytes[n];
            if (bl) {
                this.nBytes[n] = 0;
            }
        } else if (this.nBytes[n] < this.totTileLen[n] - this.totTileHeadLen[n]) {
            int n14;
            n2 = 0;
            int[] nArray2 = new int[this.pktHL.size()];
            for (n14 = this.pktHL.size() - 1; n14 >= 0; --n14) {
                nArray2[n14] = (Integer)this.pktHL.elementAt(n14);
            }
            n3 = 0;
            for (n14 = 0; n14 < n5; ++n14) {
                int n15;
                if (this.cbI == null) continue;
                int n16 = this.cbI.length;
                int n17 = 0;
                for (n15 = 0; n15 < n16; ++n15) {
                    if (this.cbI[n15] == null || this.cbI[n15].length <= n17) continue;
                    n17 = this.cbI[n15].length;
                }
                for (n15 = 0; n15 < n17; ++n15) {
                    int n18;
                    int n19 = 0;
                    for (n18 = 0; n18 < n16; ++n18) {
                        if (this.cbI[n18] == null || this.cbI[n18][n15] == null || this.cbI[n18][n15].length <= n19) continue;
                        n19 = this.cbI[n18][n15].length;
                    }
                    for (n18 = 0; n18 < n19; ++n18) {
                        int n20;
                        if (n15 == 0 && n18 != 0 || n15 != 0 && n18 == 0) continue;
                        int n21 = 0;
                        for (n20 = 0; n20 < n16; ++n20) {
                            if (this.cbI[n20] == null || this.cbI[n20][n15] == null || this.cbI[n20][n15][n18] == null || this.cbI[n20][n15][n18].length <= n21) continue;
                            n21 = this.cbI[n20][n15][n18].length;
                        }
                        for (n20 = 0; n20 < n21; ++n20) {
                            int n22;
                            int n23 = 0;
                            for (n22 = 0; n22 < n16; ++n22) {
                                if (this.cbI[n22] == null || this.cbI[n22][n15] == null || this.cbI[n22][n15][n18] == null || this.cbI[n22][n15][n18][n20] == null || this.cbI[n22][n15][n18][n20].length <= n23) continue;
                                n23 = this.cbI[n22][n15][n18][n20].length;
                            }
                            for (n22 = 0; n22 < n23; ++n22) {
                                for (int i = 0; i < n16; ++i) {
                                    if (this.cbI[i] == null || this.cbI[i][n15] == null || this.cbI[i][n15][n18] == null || this.cbI[i][n15][n18][n20] == null || this.cbI[i][n15][n18][n20][n22] == null) continue;
                                    CBlkInfo cBlkInfo = this.cbI[i][n15][n18][n20][n22];
                                    if (n3 == 0) {
                                        if (this.nBytes[n] < nArray2[cBlkInfo.pktIdx[n14]]) {
                                            n2 = 1;
                                            n3 = 1;
                                        } else if (n2 == 0) {
                                            int n24 = n;
                                            this.nBytes[n24] = this.nBytes[n24] - nArray2[cBlkInfo.pktIdx[n14]];
                                            this.anbytes += nArray2[cBlkInfo.pktIdx[n14]];
                                            nArray2[cBlkInfo.pktIdx[n14]] = 0;
                                        }
                                    }
                                    if (cBlkInfo.len[n14] == 0) continue;
                                    if (cBlkInfo.len[n14] < this.nBytes[n] && n3 == 0) {
                                        int n25 = n;
                                        this.nBytes[n25] = this.nBytes[n25] - cBlkInfo.len[n14];
                                        this.anbytes += cBlkInfo.len[n14];
                                        continue;
                                    }
                                    cBlkInfo.ntp[n14] = 0;
                                    cBlkInfo.off[n14] = 0;
                                    cBlkInfo.len[n14] = 0;
                                    n3 = 1;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.anbytes += this.totTileLen[n] - this.totTileHeadLen[n];
            if (n < this.getNumTiles() - 1) {
                int n26 = n + 1;
                this.nBytes[n26] = this.nBytes[n26] + (this.nBytes[n] - (this.totTileLen[n] - this.totTileHeadLen[n]));
            }
        }
    }

    @Override
    public void setTile(int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0 || n >= this.ntX || n2 >= this.ntY) {
            throw new IllegalArgumentException();
        }
        int n4 = n2 * this.ntX + n;
        if (n4 == 0) {
            this.anbytes = this.headLen;
            if (!this.isTruncMode) {
                this.anbytes += 2;
            }
            for (n3 = 0; n3 < this.nt; ++n3) {
                this.nBytes[n3] = this.baknBytes[n3];
            }
        }
        this.ctX = n;
        this.ctY = n2;
        n3 = n == 0 ? this.ax : this.px + n * this.ntW;
        int n5 = n2 == 0 ? this.ay : this.py + n2 * this.ntH;
        for (int i = this.nc - 1; i >= 0; --i) {
            this.culx[i] = (n3 + this.hd.getCompSubsX(i) - 1) / this.hd.getCompSubsX(i);
            this.culy[i] = (n5 + this.hd.getCompSubsY(i) - 1) / this.hd.getCompSubsY(i);
            this.offX[i] = (this.px + n * this.ntW + this.hd.getCompSubsX(i) - 1) / this.hd.getCompSubsX(i);
            this.offY[i] = (this.py + n2 * this.ntH + this.hd.getCompSubsY(i) - 1) / this.hd.getCompSubsY(i);
        }
        this.subbTrees = new SubbandSyn[this.nc];
        this.mdl = new int[this.nc];
        this.derived = new boolean[this.nc];
        this.params = new StdDequantizerParams[this.nc];
        this.gb = new int[this.nc];
        for (int i = 0; i < this.nc; ++i) {
            this.derived[i] = this.decSpec.qts.isDerived(n4, i);
            this.params[i] = (StdDequantizerParams)this.decSpec.qsss.getTileCompVal(n4, i);
            this.gb[i] = (Integer)this.decSpec.gbs.getTileCompVal(n4, i);
            this.mdl[i] = (Integer)this.decSpec.dls.getTileCompVal(n4, i);
            this.subbTrees[i] = new SubbandSyn(this.getTileCompWidth(n4, i, this.mdl[i]), this.getTileCompHeight(n4, i, this.mdl[i]), this.getResULX(i, this.mdl[i]), this.getResULY(i, this.mdl[i]), this.mdl[i], this.decSpec.wfs.getHFilters(n4, i), this.decSpec.wfs.getVFilters(n4, i));
            this.initSubbandsFields(i, this.subbTrees[i]);
        }
        try {
            this.readTilePkts(n4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("IO Error when reading tile " + n + " x " + n2);
        }
    }

    @Override
    public void nextTile() {
        if (this.ctX == this.ntX - 1 && this.ctY == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.ctX < this.ntX - 1) {
            this.setTile(this.ctX + 1, this.ctY);
        } else {
            this.setTile(0, this.ctY + 1);
        }
    }

    @Override
    public DecLyrdCBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, int n4, int n5, DecLyrdCBlk decLyrdCBlk) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        CBlkInfo cBlkInfo;
        int n11;
        int n12 = this.getTileIdx();
        int n13 = subbandSyn.resLvl;
        int n14 = subbandSyn.sbandIdx;
        int n15 = (Integer)this.decSpec.nls.getTileDef(n12);
        int n16 = (Integer)this.decSpec.ecopts.getTileCompVal(n12, n);
        if (n5 < 0) {
            n5 = n15 - n4 + 1;
        }
        if (this.lQuit != -1 && n4 + n5 > this.lQuit) {
            n5 = this.lQuit - n4;
        }
        if (n13 > this.targetRes + (n11 = this.getSynSubbandTree((int)n12, (int)n).resLvl) - this.decSpec.dls.getMin()) {
            throw new Error("JJ2000 error: requesting a code-block disallowed by the '-res' option.");
        }
        try {
            cBlkInfo = this.cbI[n][n13][n14][n2][n3];
            if (n4 < 1 || n4 > n15 || n4 + n5 - 1 > n15) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Code-block (t:" + n12 + ", c:" + n + ", r:" + n13 + ", s:" + n14 + ", " + n2 + "x" + n3 + ") not found in codestream");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Code-block (t:" + n12 + ", c:" + n + ", r:" + n13 + ", s:" + n14 + ", " + n2 + "x" + n3 + ") not found in bit stream");
        }
        if (decLyrdCBlk == null) {
            decLyrdCBlk = new DecLyrdCBlk();
        }
        decLyrdCBlk.m = n2;
        decLyrdCBlk.n = n3;
        decLyrdCBlk.nl = 0;
        decLyrdCBlk.dl = 0;
        decLyrdCBlk.nTrunc = 0;
        if (cBlkInfo == null) {
            decLyrdCBlk.skipMSBP = 0;
            decLyrdCBlk.prog = false;
            decLyrdCBlk.uly = 0;
            decLyrdCBlk.ulx = 0;
            decLyrdCBlk.h = 0;
            decLyrdCBlk.w = 0;
            return decLyrdCBlk;
        }
        decLyrdCBlk.skipMSBP = cBlkInfo.msbSkipped;
        decLyrdCBlk.ulx = cBlkInfo.ulx;
        decLyrdCBlk.uly = cBlkInfo.uly;
        decLyrdCBlk.w = cBlkInfo.w;
        decLyrdCBlk.h = cBlkInfo.h;
        decLyrdCBlk.ftpIdx = 0;
        for (n10 = 0; n10 < cBlkInfo.len.length && cBlkInfo.len[n10] == 0; ++n10) {
            decLyrdCBlk.ftpIdx += cBlkInfo.ntp[n10];
        }
        for (n10 = n4 - 1; n10 < n4 + n5 - 1; ++n10) {
            ++decLyrdCBlk.nl;
            decLyrdCBlk.dl += cBlkInfo.len[n10];
            decLyrdCBlk.nTrunc += cBlkInfo.ntp[n10];
        }
        if ((n16 & 4) != 0) {
            n9 = decLyrdCBlk.nTrunc - decLyrdCBlk.ftpIdx;
        } else if ((n16 & 1) != 0) {
            if (decLyrdCBlk.nTrunc <= 10) {
                n9 = 1;
            } else {
                n9 = 1;
                for (n8 = decLyrdCBlk.ftpIdx; n8 < decLyrdCBlk.nTrunc; ++n8) {
                    if (n8 < 9 || (n7 = (n8 + 2) % 3) != 1 && n7 != 2) continue;
                    ++n9;
                }
            }
        } else {
            n9 = 1;
        }
        if (decLyrdCBlk.data == null || decLyrdCBlk.data.length < decLyrdCBlk.dl) {
            decLyrdCBlk.data = new byte[decLyrdCBlk.dl];
        }
        if (n9 > 1 && (decLyrdCBlk.tsLengths == null || decLyrdCBlk.tsLengths.length < n9)) {
            decLyrdCBlk.tsLengths = new int[n9];
        } else if (n9 > 1 && (n16 & 5) == 1) {
            ArrayUtil.intArraySet(decLyrdCBlk.tsLengths, 0);
        }
        int n17 = -1;
        n8 = decLyrdCBlk.ftpIdx;
        int n18 = decLyrdCBlk.ftpIdx;
        int n19 = 0;
        for (n10 = n4 - 1; n10 < n4 + n5 - 1; ++n10) {
            int n20;
            n18 += cBlkInfo.ntp[n10];
            if (cBlkInfo.len[n10] == 0) continue;
            try {
                this.in.seek(cBlkInfo.off[n10]);
                this.in.readFully(decLyrdCBlk.data, n17 + 1, cBlkInfo.len[n10]);
                n17 += cBlkInfo.len[n10];
            }
            catch (IOException iOException) {
                JJ2KExceptionHandler.handleException(iOException);
            }
            if (n9 == 1) continue;
            if ((n16 & 4) != 0) {
                n20 = 0;
                while (n8 < n18) {
                    decLyrdCBlk.tsLengths[n19++] = cBlkInfo.segLen[n10] != null ? cBlkInfo.segLen[n10][n20] : cBlkInfo.len[n10];
                    ++n20;
                    ++n8;
                }
                continue;
            }
            n20 = 0;
            while (n8 < n18) {
                if (n8 >= 9 && (n7 = (n8 + 2) % 3) != 0) {
                    if (cBlkInfo.segLen[n10] != null) {
                        int n21 = n19++;
                        decLyrdCBlk.tsLengths[n21] = decLyrdCBlk.tsLengths[n21] + cBlkInfo.segLen[n10][n20++];
                        int n22 = n10;
                        cBlkInfo.len[n22] = cBlkInfo.len[n22] - cBlkInfo.segLen[n10][n20 - 1];
                    } else {
                        int n23 = n19++;
                        decLyrdCBlk.tsLengths[n23] = decLyrdCBlk.tsLengths[n23] + cBlkInfo.len[n10];
                        cBlkInfo.len[n10] = 0;
                    }
                }
                ++n8;
            }
            if (cBlkInfo.segLen[n10] != null && n20 < cBlkInfo.segLen[n10].length) {
                int n24 = n19;
                decLyrdCBlk.tsLengths[n24] = decLyrdCBlk.tsLengths[n24] + cBlkInfo.segLen[n10][n20];
                int n25 = n10;
                cBlkInfo.len[n25] = cBlkInfo.len[n25] - cBlkInfo.segLen[n10][n20];
                continue;
            }
            if (n19 >= n9) continue;
            int n26 = n19;
            decLyrdCBlk.tsLengths[n26] = decLyrdCBlk.tsLengths[n26] + cBlkInfo.len[n10];
            cBlkInfo.len[n10] = 0;
        }
        if (n9 == 1 && decLyrdCBlk.tsLengths != null) {
            decLyrdCBlk.tsLengths[0] = decLyrdCBlk.dl;
        }
        if ((n6 = n4 + n5 - 1) < n15 - 1) {
            for (n10 = n6 + 1; n10 < n15; ++n10) {
                if (cBlkInfo.len[n10] == 0) continue;
                decLyrdCBlk.prog = true;
            }
        }
        return decLyrdCBlk;
    }
}

