/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.IOException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.FileBitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public abstract class BitstreamReaderAgent
implements CodedCBlkDataSrcDec {
    protected DecoderSpecs decSpec;
    protected boolean[] derived = null;
    protected int[] gb = null;
    protected StdDequantizerParams[] params = null;
    public static final char OPT_PREFIX = 'B';
    private static final String[][] pinfo = null;
    protected int[] mdl;
    protected final int nc;
    protected int targetRes;
    protected SubbandSyn[] subbTrees;
    protected final int imgW;
    protected final int imgH;
    protected final int ax;
    protected final int ay;
    protected final int px;
    protected final int py;
    protected final int[] offX;
    protected final int[] offY;
    protected final int[] culx;
    protected final int[] culy;
    protected final int ntW;
    protected final int ntH;
    protected final int ntX;
    protected final int ntY;
    protected final int nt;
    protected int ctX;
    protected int ctY;
    protected final HeaderDecoder hd;
    protected int tnbytes;
    protected int anbytes;
    protected float trate;
    protected float arate;

    protected BitstreamReaderAgent(HeaderDecoder headerDecoder, DecoderSpecs decoderSpecs) {
        this.decSpec = decoderSpecs;
        this.hd = headerDecoder;
        this.nc = headerDecoder.getNumComps();
        this.offX = new int[this.nc];
        this.offY = new int[this.nc];
        this.culx = new int[this.nc];
        this.culy = new int[this.nc];
        this.imgW = headerDecoder.getImgWidth();
        this.imgH = headerDecoder.getImgHeight();
        this.ax = headerDecoder.getImgULX();
        this.ay = headerDecoder.getImgULY();
        Coord coord = headerDecoder.getTilingOrigin(null);
        this.px = coord.x;
        this.py = coord.y;
        this.ntW = headerDecoder.getNomTileWidth();
        this.ntH = headerDecoder.getNomTileHeight();
        this.ntX = (this.ax + this.imgW - this.px + this.ntW - 1) / this.ntW;
        this.ntY = (this.ay + this.imgH - this.py + this.ntH - 1) / this.ntH;
        this.nt = this.ntX * this.ntY;
    }

    @Override
    public final int getCbULX() {
        return this.hd.getCbULX();
    }

    @Override
    public int getCbULY() {
        return this.hd.getCbULY();
    }

    @Override
    public final int getNumComps() {
        return this.nc;
    }

    @Override
    public final int getCompSubsX(int n) {
        return this.hd.getCompSubsX(n);
    }

    @Override
    public int getCompSubsY(int n) {
        return this.hd.getCompSubsY(n);
    }

    @Override
    public int getTileWidth(int n) {
        int n2 = this.decSpec.dls.getMinInTile(this.getTileIdx());
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n3 = n2 - n;
        int n4 = this.ctX == 0 ? this.ax : this.px + this.ctX * this.ntW;
        int n5 = this.ctX < this.ntX - 1 ? this.px + (this.ctX + 1) * this.ntW : this.ax + this.imgW;
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public int getTileHeight(int n) {
        int n2 = this.decSpec.dls.getMinInTile(this.getTileIdx());
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n3 = n2 - n;
        int n4 = this.ctY == 0 ? this.ay : this.py + this.ctY * this.ntH;
        int n5 = this.ctY < this.ntY - 1 ? this.py + (this.ctY + 1) * this.ntH : this.ay + this.imgH;
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public int getImgWidth(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ax + this.imgW + (1 << n3) - 1) / (1 << n3) - (this.ax + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public int getImgHeight(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ay + this.imgH + (1 << n3) - 1) / (1 << n3) - (this.ay + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public int getImgULX(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ax + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public int getImgULY(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ay + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public final int getTileCompWidth(int n, int n2, int n3) {
        int n4 = this.getTileIdx();
        if (n != n4) {
            throw new Error("Asking the tile-component width of a tile different  from the current one.");
        }
        int n5 = this.mdl[n2] - n3;
        int n6 = this.ctX < this.ntX - 1 ? this.px + (this.ctX + 1) * this.ntW : this.ax + this.imgW;
        n6 = (n6 + this.hd.getCompSubsX(n2) - 1) / this.hd.getCompSubsX(n2);
        return (n6 + (1 << n5) - 1) / (1 << n5) - (this.culx[n2] + (1 << n5) - 1) / (1 << n5);
    }

    @Override
    public final int getTileCompHeight(int n, int n2, int n3) {
        int n4 = this.getTileIdx();
        if (n != n4) {
            throw new Error("Asking the tile-component width of a tile different  from the current one.");
        }
        int n5 = this.mdl[n2] - n3;
        int n6 = this.ctY < this.ntY - 1 ? this.py + (this.ctY + 1) * this.ntH : this.ay + this.imgH;
        n6 = (n6 + this.hd.getCompSubsY(n2) - 1) / this.hd.getCompSubsY(n2);
        return (n6 + (1 << n5) - 1) / (1 << n5) - (this.culy[n2] + (1 << n5) - 1) / (1 << n5);
    }

    @Override
    public final int getCompImgWidth(int n, int n2) {
        int n3 = this.decSpec.dls.getMinInComp(n) - n2;
        int n4 = (this.ax + this.hd.getCompSubsX(n) - 1) / this.hd.getCompSubsX(n);
        int n5 = (this.ax + this.imgW + this.hd.getCompSubsX(n) - 1) / this.hd.getCompSubsX(n);
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public final int getCompImgHeight(int n, int n2) {
        int n3 = this.decSpec.dls.getMinInComp(n) - n2;
        int n4 = (this.ay + this.hd.getCompSubsY(n) - 1) / this.hd.getCompSubsY(n);
        int n5 = (this.ay + this.imgH + this.hd.getCompSubsY(n) - 1) / this.hd.getCompSubsY(n);
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    @Override
    public abstract void setTile(int var1, int var2);

    @Override
    public abstract void nextTile();

    @Override
    public final Coord getTile(Coord coord) {
        if (coord != null) {
            coord.x = this.ctX;
            coord.y = this.ctY;
            return coord;
        }
        return new Coord(this.ctX, this.ctY);
    }

    @Override
    public final int getTileIdx() {
        return this.ctY * this.ntX + this.ctX;
    }

    @Override
    public final int getResULX(int n, int n2) {
        int n3 = this.mdl[n] - n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n4 = Math.max(this.px + this.ctX * this.ntW, this.ax);
        int n5 = (int)Math.ceil((double)n4 / (double)this.getCompSubsX(n));
        return (int)Math.ceil((double)n5 / (double)(1 << n3));
    }

    @Override
    public final int getResULY(int n, int n2) {
        int n3 = this.mdl[n] - n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n4 = Math.max(this.py + this.ctY * this.ntH, this.ay);
        int n5 = (int)Math.ceil((double)n4 / (double)this.getCompSubsY(n));
        return (int)Math.ceil((double)n5 / (double)(1 << n3));
    }

    @Override
    public final Coord getNumTiles(Coord coord) {
        if (coord != null) {
            coord.x = this.ntX;
            coord.y = this.ntY;
            return coord;
        }
        return new Coord(this.ntX, this.ntY);
    }

    @Override
    public final int getNumTiles() {
        return this.ntX * this.ntY;
    }

    @Override
    public final SubbandSyn getSynSubbandTree(int n, int n2) {
        if (n != this.getTileIdx()) {
            throw new IllegalArgumentException("Can not request subband tree of a different tile than the current one");
        }
        if (n2 < 0 || n2 >= this.nc) {
            throw new IllegalArgumentException("Component index out of range");
        }
        return this.subbTrees[n2];
    }

    public static BitstreamReaderAgent createInstance(RandomAccessIO randomAccessIO, HeaderDecoder headerDecoder, ParameterList parameterList, DecoderSpecs decoderSpecs, boolean bl, HeaderInfo headerInfo) throws IOException {
        parameterList.checkList('B', ParameterList.toNameArray(BitstreamReaderAgent.getParameterInfo()));
        return new FileBitstreamReaderAgent(headerDecoder, randomAccessIO, decoderSpecs, parameterList, bl, headerInfo);
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    protected void initSubbandsFields(int n, SubbandSyn subbandSyn) {
        int n2 = this.getTileIdx();
        int n3 = subbandSyn.resLvl;
        int n4 = this.decSpec.cblks.getCBlkWidth((byte)3, n2, n);
        int n5 = this.decSpec.cblks.getCBlkHeight((byte)3, n2, n);
        if (!subbandSyn.isNode) {
            int n6;
            int n7;
            int n8;
            int n9;
            if (this.hd.precinctPartitionUsed()) {
                n9 = MathUtil.log2(this.getPPX(n2, n, n3));
                n8 = MathUtil.log2(this.getPPY(n2, n, n3));
                n7 = MathUtil.log2(n4);
                n6 = MathUtil.log2(n5);
                switch (subbandSyn.resLvl) {
                    case 0: {
                        subbandSyn.nomCBlkW = n7 < n9 ? 1 << n7 : 1 << n9;
                        subbandSyn.nomCBlkH = n6 < n8 ? 1 << n6 : 1 << n8;
                        break;
                    }
                    default: {
                        subbandSyn.nomCBlkW = n7 < n9 - 1 ? 1 << n7 : 1 << n9 - 1;
                        subbandSyn.nomCBlkH = n6 < n8 - 1 ? 1 << n6 : 1 << n8 - 1;
                        break;
                    }
                }
            } else {
                subbandSyn.nomCBlkW = n4;
                subbandSyn.nomCBlkH = n5;
            }
            if (subbandSyn.numCb == null) {
                subbandSyn.numCb = new Coord();
            }
            if (subbandSyn.w == 0 || subbandSyn.h == 0) {
                subbandSyn.numCb.x = 0;
                subbandSyn.numCb.y = 0;
            } else {
                n9 = this.getCbULX();
                n8 = this.getCbULY();
                n6 = n9;
                int n10 = n8;
                switch (subbandSyn.sbandIdx) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        n6 = 0;
                        break;
                    }
                    case 2: {
                        n10 = 0;
                        break;
                    }
                    case 3: {
                        n6 = 0;
                        n10 = 0;
                        break;
                    }
                    default: {
                        throw new Error("Internal JJ2000 error");
                    }
                }
                if (subbandSyn.ulcx - n6 < 0 || subbandSyn.ulcy - n10 < 0) {
                    throw new IllegalArgumentException("Invalid code-blocks partition origin or image offset in the reference grid.");
                }
                n7 = subbandSyn.ulcx - n6 + subbandSyn.nomCBlkW;
                subbandSyn.numCb.x = (n7 + subbandSyn.w - 1) / subbandSyn.nomCBlkW - (n7 / subbandSyn.nomCBlkW - 1);
                n7 = subbandSyn.ulcy - n10 + subbandSyn.nomCBlkH;
                subbandSyn.numCb.y = (n7 + subbandSyn.h - 1) / subbandSyn.nomCBlkH - (n7 / subbandSyn.nomCBlkH - 1);
            }
            subbandSyn.magbits = this.derived[n] ? this.gb[n] + (this.params[n].exp[0][0] - (this.mdl[n] - subbandSyn.level)) - 1 : this.gb[n] + this.params[n].exp[subbandSyn.resLvl][subbandSyn.sbandIdx] - 1;
        } else {
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getLL());
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getHL());
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getLH());
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getHH());
        }
    }

    public int getImgRes() {
        return this.targetRes;
    }

    public float getTargetRate() {
        return this.trate;
    }

    public float getActualRate() {
        this.arate = (float)this.anbytes * 8.0f / (float)this.hd.getMaxCompImgWidth() / (float)this.hd.getMaxCompImgHeight();
        return this.arate;
    }

    public int getTargetNbytes() {
        return this.tnbytes;
    }

    public int getActualNbytes() {
        return this.anbytes;
    }

    @Override
    public int getTilePartULX() {
        return this.hd.getTilingOrigin(null).x;
    }

    @Override
    public int getTilePartULY() {
        return this.hd.getTilingOrigin(null).y;
    }

    @Override
    public int getNomTileWidth() {
        return this.hd.getNomTileWidth();
    }

    @Override
    public int getNomTileHeight() {
        return this.hd.getNomTileHeight();
    }
}

