/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Vector;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlkInt;

public class BlkImgDataSrcImageProducer
implements ImageProducer {
    private volatile Vector consumers;
    private BlkImgDataSrc src;
    private int type;
    private static final int GRAY = 0;
    private static final int RGB = 1;
    private static final int RGBA = 2;
    private static final ColorModel cm = ColorModel.getRGBdefault();

    public BlkImgDataSrcImageProducer(BlkImgDataSrc blkImgDataSrc) {
        switch (blkImgDataSrc.getNumComps()) {
            case 1: {
                this.type = 0;
                break;
            }
            case 3: {
                this.type = 1;
                break;
            }
            case 4: {
                this.type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only 1, 3, and 4 components supported");
            }
        }
        int n = blkImgDataSrc.getCompImgHeight(0);
        int n2 = blkImgDataSrc.getCompImgWidth(0);
        for (int i = blkImgDataSrc.getNumComps() - 1; i >= 0; --i) {
            if (blkImgDataSrc.getCompImgHeight(i) != n || blkImgDataSrc.getCompImgWidth(i) != n2) {
                throw new IllegalArgumentException("All components must have the same dimensions and no subsampling");
            }
            if (blkImgDataSrc.getNomRangeBits(i) <= 8) continue;
            throw new IllegalArgumentException("Depths greater than 8 bits per component is not supported");
        }
        this.src = blkImgDataSrc;
        this.consumers = new Vector();
    }

    public static Image createImage(BlkImgDataSrc blkImgDataSrc) {
        return Toolkit.getDefaultToolkit().createImage(new BlkImgDataSrcImageProducer(blkImgDataSrc));
    }

    public static Image createImage(BlkImgDataSrc blkImgDataSrc, Component component) {
        return component.getToolkit().createImage(new BlkImgDataSrcImageProducer(blkImgDataSrc));
    }

    @Override
    public final synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != null && !this.consumers.contains(imageConsumer)) {
            this.consumers.addElement(imageConsumer);
        }
    }

    @Override
    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startProduction(ImageConsumer imageConsumer) {
        int n;
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        Coord coord = this.src.getNumTiles(null);
        int n5 = 0;
        if (imageConsumer != null) {
            this.addConsumer(imageConsumer);
        }
        BlkImgDataSrcImageProducer blkImgDataSrcImageProducer = this;
        synchronized (blkImgDataSrcImageProducer) {
            objectArray = new ImageConsumer[this.consumers.size()];
            this.consumers.copyInto(objectArray);
        }
        if (this.src == null) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                objectArray[i].imageComplete(1);
            }
            return;
        }
        int[] nArray = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        DataBlkInt dataBlkInt = null;
        DataBlkInt dataBlkInt2 = null;
        DataBlkInt dataBlkInt3 = null;
        DataBlkInt dataBlkInt4 = null;
        switch (this.type) {
            case 2: {
                dataBlkInt = new DataBlkInt();
                n14 = 1 << this.src.getNomRangeBits(3) - 1;
                n12 = (1 << this.src.getNomRangeBits(3)) - 1;
                n13 = this.src.getFixedPoint(3);
            }
            case 1: {
                dataBlkInt2 = new DataBlkInt();
                n11 = 1 << this.src.getNomRangeBits(2) - 1;
                n9 = (1 << this.src.getNomRangeBits(2)) - 1;
                n10 = this.src.getFixedPoint(2);
                dataBlkInt3 = new DataBlkInt();
                n8 = 1 << this.src.getNomRangeBits(1) - 1;
                n6 = (1 << this.src.getNomRangeBits(1)) - 1;
                n7 = this.src.getFixedPoint(1);
            }
            case 0: {
                dataBlkInt4 = new DataBlkInt();
                n4 = 1 << this.src.getNomRangeBits(0) - 1;
                n3 = (1 << this.src.getNomRangeBits(0)) - 1;
                n2 = this.src.getFixedPoint(0);
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        coord = this.src.getNumTiles(null);
        int n15 = 24;
        n15 = coord.x == 1 ? (n15 |= 6) : (n15 |= 1);
        for (n = objectArray.length - 1; n >= 0; --n) {
            objectArray[n].setColorModel(cm);
            objectArray[n].setDimensions(this.src.getCompImgWidth(0), this.src.getCompImgHeight(0));
            objectArray[n].setHints(n15);
        }
        for (int i = 0; i < coord.y; ++i) {
            int n16 = 0;
            while (n16 < coord.x) {
                this.src.setTile(n16, i);
                int n17 = this.src.getTileCompHeight(n5, 0);
                int n18 = this.src.getTileCompWidth(n5, 0);
                if (nArray == null || nArray.length < n18) {
                    nArray = new int[n18];
                }
                int n19 = this.src.getCompULX(0) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(0));
                int n20 = this.src.getCompULY(0) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(0));
                for (int j = 0; j < n17; ++j) {
                    boolean bl = false;
                    switch (this.type) {
                        case 2: {
                            dataBlkInt.ulx = 0;
                            dataBlkInt.uly = j;
                            dataBlkInt.w = n18;
                            dataBlkInt.h = 1;
                            this.src.getInternCompData(dataBlkInt, 3);
                            bl = bl || dataBlkInt.progressive;
                        }
                        case 1: {
                            dataBlkInt2.ulx = 0;
                            dataBlkInt3.ulx = 0;
                            dataBlkInt3.uly = dataBlkInt2.uly = j;
                            dataBlkInt3.w = dataBlkInt2.w = n18;
                            dataBlkInt2.h = 1;
                            dataBlkInt3.h = 1;
                            this.src.getInternCompData(dataBlkInt2, 2);
                            bl = bl || dataBlkInt2.progressive;
                            this.src.getInternCompData(dataBlkInt3, 1);
                            bl = bl || dataBlkInt3.progressive;
                        }
                        case 0: {
                            dataBlkInt4.ulx = 0;
                            dataBlkInt4.uly = j;
                            dataBlkInt4.w = n18;
                            dataBlkInt4.h = 1;
                            this.src.getInternCompData(dataBlkInt4, 0);
                            boolean bl2 = bl = bl || dataBlkInt4.progressive;
                        }
                    }
                    if (bl) {
                        for (n = objectArray.length - 1; n >= 0; --n) {
                            objectArray[n].imageComplete(4);
                        }
                        return;
                    }
                    switch (this.type) {
                        case 0: {
                            int n21;
                            int[] nArray2 = dataBlkInt4.data;
                            int n22 = dataBlkInt4.offset + n18 - 1;
                            for (n = n18 - 1; n >= 0; --n) {
                                n21 = (n21 = (nArray2[n22--] >> n2) + n4) < 0 ? 0 : (n21 > n3 ? n3 : n21);
                                nArray[n] = 0xFF000000 | n21 << 16 | n21 << 8 | n21;
                            }
                            break;
                        }
                        case 1: {
                            int n23;
                            int n24;
                            int n21;
                            int[] nArray2 = dataBlkInt4.data;
                            int[] nArray3 = dataBlkInt3.data;
                            int[] nArray4 = dataBlkInt2.data;
                            int n22 = dataBlkInt4.offset + n18 - 1;
                            int n25 = dataBlkInt3.offset + n18 - 1;
                            int n26 = dataBlkInt2.offset + n18 - 1;
                            for (n = n18 - 1; n >= 0; --n) {
                                n21 = (n21 = (nArray2[n22--] >> n2) + n4) < 0 ? 0 : (n21 > n3 ? n3 : n21);
                                n24 = (nArray3[n25--] >> n7) + n8;
                                n24 = n24 < 0 ? 0 : (n24 > n6 ? n6 : n24);
                                n23 = (nArray4[n26--] >> n10) + n11;
                                n23 = n23 < 0 ? 0 : (n23 > n9 ? n9 : n23);
                                nArray[n] = 0xFF000000 | n21 << 16 | n24 << 8 | n23;
                            }
                            break;
                        }
                        case 2: {
                            int n23;
                            int n24;
                            int n21;
                            int[] nArray2 = dataBlkInt4.data;
                            int[] nArray3 = dataBlkInt3.data;
                            int[] nArray4 = dataBlkInt2.data;
                            int[] nArray5 = dataBlkInt.data;
                            int n22 = dataBlkInt4.offset + n18 - 1;
                            int n25 = dataBlkInt3.offset + n18 - 1;
                            int n26 = dataBlkInt2.offset + n18 - 1;
                            int n27 = dataBlkInt.offset + n18 - 1;
                            for (n = n18 - 1; n >= 0; --n) {
                                n21 = (n21 = (nArray2[n22--] >> n2) + n4) < 0 ? 0 : (n21 > n3 ? n3 : n21);
                                n24 = (nArray3[n25--] >> n7) + n8;
                                n24 = n24 < 0 ? 0 : (n24 > n6 ? n6 : n24);
                                n23 = (nArray4[n26--] >> n10) + n11;
                                n23 = n23 < 0 ? 0 : (n23 > n9 ? n9 : n23);
                                int n28 = (nArray5[n27--] >> n13) + n14;
                                n28 = n28 < 0 ? 0 : (n28 > n12 ? n12 : n28);
                                nArray[n] = n28 << 24 | n21 << 16 | n24 << 8 | n23;
                            }
                            break;
                        }
                    }
                    for (n = objectArray.length - 1; n >= 0; --n) {
                        objectArray[n].setPixels(n19, n20 + j, n18, 1, cm, nArray, 0, n18);
                    }
                }
                ++n16;
                ++n5;
            }
        }
        for (n = objectArray.length - 1; n >= 0; --n) {
            objectArray[n].imageComplete(2);
        }
        for (n = objectArray.length - 1; n >= 0; --n) {
            objectArray[n].imageComplete(3);
        }
        BlkImgDataSrcImageProducer blkImgDataSrcImageProducer2 = this;
        synchronized (blkImgDataSrcImageProducer2) {
            for (n = objectArray.length - 1; n >= 0; --n) {
                this.consumers.removeElement(objectArray[n]);
            }
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }
}

