/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import icc.ICCProfile;
import icc.tags.ICCCurveType;
import icc.tags.ICCTag;

public class ICCCurveTypeReverse
extends ICCTag {
    private static final String eol = System.getProperty("line.separator");
    public final int type;
    public final int reserved;
    public final int nEntries;
    public final int[] entry;

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[").append(super.toString()).append(eol);
        stringBuffer.append("num entries = " + String.valueOf(this.nEntries) + eol);
        stringBuffer.append("data length = " + String.valueOf(this.entry.length) + eol);
        for (int i = 0; i < this.nEntries; ++i) {
            stringBuffer.append(ICCProfile.toHexString(this.entry[i]) + eol);
        }
        return stringBuffer.append("]").toString();
    }

    public static double CurveToDouble(int n) {
        return ICCCurveType.CurveToDouble(n);
    }

    public static short DoubleToCurve(int n) {
        return ICCCurveType.DoubleToCurve(n);
    }

    public static double CurveGammaToDouble(int n) {
        return ICCCurveType.CurveGammaToDouble(n);
    }

    protected ICCCurveTypeReverse(int n, byte[] byArray, int n2, int n3) {
        super(n, byArray, n2, n2 + 8);
        this.type = ICCProfile.getInt(byArray, n2);
        this.reserved = ICCProfile.getInt(byArray, n2 + 4);
        this.nEntries = ICCProfile.getInt(byArray, n2 + 8);
        this.entry = new int[this.nEntries];
        for (int i = 0; i < this.nEntries; ++i) {
            this.entry[this.nEntries - 1 + i] = ICCProfile.getShort(byArray, n2 + 12 + i * 2) & 0xFFFF;
        }
    }

    public final int entry(int n) {
        return this.entry[n];
    }
}

