/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.FacilityManager;

public class SYccColorSpaceMapper
extends ColorSpaceMapper {
    protected static float Matrix00 = 1.0f;
    protected static float Matrix01 = 0.0f;
    protected static float Matrix02 = 1.402f;
    protected static float Matrix10 = 1.0f;
    protected static float Matrix11 = -0.34413f;
    protected static float Matrix12 = -0.71414f;
    protected static float Matrix20 = 1.0f;
    protected static float Matrix21 = 1.772f;
    protected static float Matrix22 = 0.0f;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        return new SYccColorSpaceMapper(blkImgDataSrc, colorSpace);
    }

    protected SYccColorSpaceMapper(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        super(blkImgDataSrc, colorSpace);
        this.initialize();
    }

    private void initialize() throws ColorSpaceException {
        if (this.ncomps != 1 && this.ncomps != 3) {
            String string = "SYccColorSpaceMapper: ycc transformation _not_ applied to " + this.ncomps + " component image";
            FacilityManager.getMsgLogger().printmsg(3, string);
            throw new ColorSpaceException(string);
        }
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        int n2 = dataBlk.getDataType();
        for (int i = 0; i < this.ncomps; ++i) {
            SYccColorSpaceMapper.copyGeometry(this.workInt[i], dataBlk);
            SYccColorSpaceMapper.copyGeometry(this.workFloat[i], dataBlk);
            SYccColorSpaceMapper.copyGeometry(this.inInt[i], dataBlk);
            SYccColorSpaceMapper.copyGeometry(this.inFloat[i], dataBlk);
            this.inInt[i] = (DataBlkInt)this.src.getInternCompData(this.inInt[i], i);
        }
        if (n2 == 3) {
            if (this.ncomps == 1) {
                this.workInt[n] = this.inInt[n];
            } else {
                this.workInt = SYccColorSpaceMapper.mult(this.inInt);
            }
            dataBlk.progressive = this.inInt[n].progressive;
            dataBlk.setData(this.workInt[n].getData());
        }
        if (n2 == 4) {
            if (this.ncomps == 1) {
                this.workFloat[n] = this.inFloat[n];
            } else {
                this.workFloat = SYccColorSpaceMapper.mult(this.inFloat);
            }
            dataBlk.progressive = this.inFloat[n].progressive;
            dataBlk.setData(this.workFloat[n].getData());
        }
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    @Override
    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.getCompData(dataBlk, n);
    }

    private static DataBlkFloat[] mult(DataBlkFloat[] dataBlkFloatArray) {
        if (dataBlkFloatArray.length != 3) {
            throw new IllegalArgumentException("bad input array size");
        }
        int n = dataBlkFloatArray[0].h * dataBlkFloatArray[0].w;
        DataBlkFloat[] dataBlkFloatArray2 = new DataBlkFloat[3];
        float[][] fArrayArray = new float[3][];
        float[][] fArrayArray2 = new float[3][];
        for (int i = 0; i < 3; ++i) {
            fArrayArray2[i] = dataBlkFloatArray[i].getDataFloat();
            dataBlkFloatArray2[i] = new DataBlkFloat();
            SYccColorSpaceMapper.copyGeometry(dataBlkFloatArray2[i], dataBlkFloatArray[i]);
            dataBlkFloatArray2[i].offset = dataBlkFloatArray[i].offset;
            fArrayArray[i] = new float[n];
            dataBlkFloatArray2[i].setData(fArrayArray[i]);
        }
        for (int i = 0; i < n; ++i) {
            fArrayArray[0][i] = Matrix00 * fArrayArray2[0][dataBlkFloatArray[0].offset + i] + Matrix01 * fArrayArray2[1][dataBlkFloatArray[1].offset + i] + Matrix02 * fArrayArray2[2][dataBlkFloatArray[2].offset + i];
            fArrayArray[1][i] = Matrix10 * fArrayArray2[0][dataBlkFloatArray[0].offset + i] + Matrix11 * fArrayArray2[1][dataBlkFloatArray[1].offset + i] + Matrix12 * fArrayArray2[2][dataBlkFloatArray[2].offset + i];
            fArrayArray[2][i] = Matrix20 * fArrayArray2[0][dataBlkFloatArray[0].offset + i] + Matrix21 * fArrayArray2[1][dataBlkFloatArray[1].offset + i] + Matrix22 * fArrayArray2[2][dataBlkFloatArray[2].offset + i];
        }
        return dataBlkFloatArray2;
    }

    private static DataBlkInt[] mult(DataBlkInt[] dataBlkIntArray) {
        if (dataBlkIntArray.length != 3) {
            throw new IllegalArgumentException("bad input array size");
        }
        int n = dataBlkIntArray[0].h * dataBlkIntArray[0].w;
        DataBlkInt[] dataBlkIntArray2 = new DataBlkInt[3];
        int[][] nArrayArray = new int[3][];
        int[][] nArrayArray2 = new int[3][];
        for (int i = 0; i < 3; ++i) {
            nArrayArray2[i] = dataBlkIntArray[i].getDataInt();
            dataBlkIntArray2[i] = new DataBlkInt();
            SYccColorSpaceMapper.copyGeometry(dataBlkIntArray2[i], dataBlkIntArray[i]);
            dataBlkIntArray2[i].offset = dataBlkIntArray[i].offset;
            nArrayArray[i] = new int[n];
            dataBlkIntArray2[i].setData(nArrayArray[i]);
        }
        for (int i = 0; i < n; ++i) {
            nArrayArray[0][i] = (int)(Matrix00 * (float)nArrayArray2[0][dataBlkIntArray[0].offset + i] + Matrix01 * (float)nArrayArray2[1][dataBlkIntArray[1].offset + i] + Matrix02 * (float)nArrayArray2[2][dataBlkIntArray[2].offset + i]);
            nArrayArray[1][i] = (int)(Matrix10 * (float)nArrayArray2[0][dataBlkIntArray[0].offset + i] + Matrix11 * (float)nArrayArray2[1][dataBlkIntArray[1].offset + i] + Matrix12 * (float)nArrayArray2[2][dataBlkIntArray[2].offset + i]);
            nArrayArray[2][i] = (int)(Matrix20 * (float)nArrayArray2[0][dataBlkIntArray[0].offset + i] + Matrix21 * (float)nArrayArray2[1][dataBlkIntArray[1].offset + i] + Matrix22 * (float)nArrayArray2[2][dataBlkIntArray[2].offset + i]);
        }
        return dataBlkIntArray2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ncomps= ").append(String.valueOf(this.ncomps));
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.ncomps; ++i) {
            stringBuffer2.append("  ").append("component[").append(String.valueOf(i)).append("] height, width = (").append(this.src.getCompImgHeight(i)).append(", ").append(this.src.getCompImgWidth(i)).append(")").append(eol);
        }
        StringBuffer stringBuffer3 = new StringBuffer("[SYccColorSpaceMapper ");
        stringBuffer3.append(stringBuffer).append(eol);
        stringBuffer3.append(stringBuffer2).append("  ");
        return stringBuffer3.append("]").toString();
    }
}

