/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;

public class Resampler
extends ColorSpaceMapper {
    private final int minCompSubsX;
    private final int minCompSubsY;
    private final int maxCompSubsX;
    private final int maxCompSubsY;
    final int wspan = 0;
    final int hspan = 0;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        return new Resampler(blkImgDataSrc, colorSpace);
    }

    protected Resampler(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        super(blkImgDataSrc, colorSpace);
        int n = blkImgDataSrc.getCompSubsX(0);
        int n2 = blkImgDataSrc.getCompSubsY(0);
        int n3 = n;
        int n4 = n2;
        for (int i = 1; i < this.ncomps; ++i) {
            n = Math.min(n, blkImgDataSrc.getCompSubsX(i));
            n2 = Math.min(n2, blkImgDataSrc.getCompSubsY(i));
            n3 = Math.max(n3, blkImgDataSrc.getCompSubsX(i));
            n4 = Math.max(n4, blkImgDataSrc.getCompSubsY(i));
        }
        if (n3 != 1 && n3 != 2 || n4 != 1 && n4 != 2) {
            throw new ColorSpaceException("Upsampling by other than 2:1 not supported");
        }
        this.minCompSubsX = n;
        this.minCompSubsY = n2;
        this.maxCompSubsX = n3;
        this.maxCompSubsY = n4;
    }

    @Override
    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        if (this.src.getCompSubsX(n) == 1 && this.src.getCompSubsY(n) == 1) {
            return this.src.getInternCompData(dataBlk, n);
        }
        int n2 = this.src.getCompSubsX(n);
        int n3 = this.src.getCompSubsY(n);
        if (n2 != 2 && n2 != 1 || n3 != 2 && n3 != 1) {
            throw new IllegalArgumentException("Upsampling by other than 2:1 not supported");
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = dataBlk.uly;
        int n9 = n8 + dataBlk.h - 1;
        int n10 = dataBlk.ulx;
        int n11 = n10 + dataBlk.w - 1;
        int n12 = n8 / n3;
        int n13 = n9 / n3;
        int n14 = n10 / n2;
        int n15 = n11 / n2;
        int n16 = n15 - n14 + 1;
        int n17 = n13 - n12 + 1;
        int n18 = -1;
        int n19 = -1;
        switch (dataBlk.getDataType()) {
            case 3: {
                DataBlkInt dataBlkInt = new DataBlkInt(n14, n12, n16, n17);
                dataBlkInt = (DataBlkInt)this.src.getInternCompData(dataBlkInt, n);
                this.dataInt[n] = dataBlkInt.getDataInt();
                int[] nArray = (int[])dataBlk.getData();
                if (nArray == null || nArray.length != dataBlk.w * dataBlk.h) {
                    nArray = new int[dataBlk.h * dataBlk.w];
                    dataBlk.setData(nArray);
                }
                for (int i = n8; i <= n9; ++i) {
                    int n20 = i / n3;
                    n6 = dataBlkInt.offset + (n20 - n12) * dataBlkInt.scanw;
                    n7 = n6 + dataBlkInt.w;
                    n4 = dataBlk.offset + (i - n8) * dataBlk.scanw;
                    n5 = n4 + dataBlk.w;
                    n19 = n6;
                    n18 = n4;
                    if ((n10 & 1) == 1) {
                        nArray[n18++] = this.dataInt[n][n19++];
                    }
                    if ((n11 & 1) == 0) {
                        --n5;
                    }
                    while (n18 < n5) {
                        nArray[n18++] = this.dataInt[n][n19];
                        nArray[n18++] = this.dataInt[n][n19++];
                    }
                    if ((n11 & 1) != 0) continue;
                    nArray[n18++] = this.dataInt[n][n19];
                }
                dataBlk.progressive = dataBlkInt.progressive;
                break;
            }
            case 4: {
                DataBlkFloat dataBlkFloat = new DataBlkFloat(n14, n12, n16, n17);
                dataBlkFloat = (DataBlkFloat)this.src.getInternCompData(dataBlkFloat, n);
                this.dataFloat[n] = dataBlkFloat.getDataFloat();
                float[] fArray = (float[])dataBlk.getData();
                if (fArray == null || fArray.length != dataBlk.w * dataBlk.h) {
                    fArray = new float[dataBlk.h * dataBlk.w];
                    dataBlk.setData(fArray);
                }
                for (int i = n8; i <= n9; ++i) {
                    int n21 = i / n3;
                    n6 = dataBlkFloat.offset + (n21 - n12) * dataBlkFloat.scanw;
                    n7 = n6 + dataBlkFloat.w;
                    n4 = dataBlk.offset + (i - n8) * dataBlk.scanw;
                    n5 = n4 + dataBlk.w;
                    n19 = n6;
                    n18 = n4;
                    if ((n10 & 1) == 1) {
                        fArray[n18++] = this.dataFloat[n][n19++];
                    }
                    if ((n11 & 1) == 0) {
                        --n5;
                    }
                    while (n18 < n5) {
                        fArray[n18++] = this.dataFloat[n][n19];
                        fArray[n18++] = this.dataFloat[n][n19++];
                    }
                    if ((n11 & 1) != 0) continue;
                    fArray[n18++] = this.dataFloat[n][n19];
                }
                dataBlk.progressive = dataBlkFloat.progressive;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid source datablock type");
            }
        }
        return dataBlk;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Resampler: ncomps= " + this.ncomps);
        StringBuffer stringBuffer2 = new StringBuffer("  ");
        for (int i = 0; i < this.ncomps; ++i) {
            stringBuffer2.append(eol);
            stringBuffer2.append("comp[");
            stringBuffer2.append(i);
            stringBuffer2.append("] xscale= ");
            stringBuffer2.append(this.imgdatasrc.getCompSubsX(i));
            stringBuffer2.append(", yscale= ");
            stringBuffer2.append(this.imgdatasrc.getCompSubsY(i));
        }
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2));
        return stringBuffer.append("]").toString();
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.getInternCompData(dataBlk, n);
    }

    @Override
    public int getCompImgHeight(int n) {
        return this.src.getCompImgHeight(n) * this.src.getCompSubsY(n);
    }

    @Override
    public int getCompImgWidth(int n) {
        return this.src.getCompImgWidth(n) * this.src.getCompSubsX(n);
    }

    @Override
    public int getCompSubsX(int n) {
        return 1;
    }

    @Override
    public int getCompSubsY(int n) {
        return 1;
    }

    @Override
    public int getTileCompHeight(int n, int n2) {
        return this.src.getTileCompHeight(n, n2) * this.src.getCompSubsY(n2);
    }

    @Override
    public int getTileCompWidth(int n, int n2) {
        return this.src.getTileCompWidth(n, n2) * this.src.getCompSubsX(n2);
    }
}

