/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.EnumeratedColorSpaceMapper;
import colorspace.SYccColorSpaceMapper;
import icc.ICCProfileException;
import icc.ICCProfiler;
import java.io.IOException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.ParameterList;

public abstract class ColorSpaceMapper
extends ImgDataAdapter
implements BlkImgDataSrc {
    public static final char OPT_PREFIX = 'I';
    protected static final String eol = System.getProperty("line.separator");
    protected DataBlkInt[] inInt;
    protected DataBlkFloat[] inFloat;
    protected DataBlkInt[] workInt;
    protected DataBlkFloat[] workFloat;
    protected int[][] dataInt;
    protected float[][] dataFloat;
    protected float[][] workDataFloat;
    protected int[][] workDataInt;
    protected int[] shiftValueArray = null;
    protected int[] maxValueArray = null;
    protected int[] fixedPtBitsArray = null;
    private static final String[][] pinfo = new String[][]{{"IcolorSpacedebug", null, "Print debugging messages during colorspace mapping.", "off"}};
    protected ParameterList pl = null;
    protected ColorSpace csMap = null;
    protected int ncomps = 0;
    protected BlkImgDataSrc src = null;
    protected DataBlk[] srcBlk = null;
    protected ComputedComponents computed = new ComputedComponents();

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    protected static void setInternalBuffer(DataBlk dataBlk) {
        switch (dataBlk.getDataType()) {
            case 3: {
                if (dataBlk.getData() != null && ((int[])dataBlk.getData()).length >= dataBlk.w * dataBlk.h) break;
                dataBlk.setData(new int[dataBlk.w * dataBlk.h]);
                break;
            }
            case 4: {
                if (dataBlk.getData() != null && ((float[])dataBlk.getData()).length >= dataBlk.w * dataBlk.h) break;
                dataBlk.setData(new float[dataBlk.w * dataBlk.h]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid output datablock type");
            }
        }
    }

    protected static void copyGeometry(DataBlk dataBlk, DataBlk dataBlk2) {
        dataBlk.offset = 0;
        dataBlk.h = dataBlk2.h;
        dataBlk.w = dataBlk2.w;
        dataBlk.ulx = dataBlk2.ulx;
        dataBlk.uly = dataBlk2.uly;
        dataBlk.scanw = dataBlk2.w;
        ColorSpaceMapper.setInternalBuffer(dataBlk);
    }

    public static BlkImgDataSrc createInstance(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws IOException, ColorSpaceException, ICCProfileException {
        ParameterList cfr_ignored_0 = colorSpace.pl;
        colorSpace.pl.checkList('I', ParameterList.toNameArray(pinfo));
        if (colorSpace.getMethod() == ColorSpace.ICC_PROFILED) {
            return ICCProfiler.createInstance(blkImgDataSrc, colorSpace);
        }
        ColorSpace.CSEnum cSEnum = colorSpace.getColorSpace();
        if (cSEnum == ColorSpace.sRGB) {
            return EnumeratedColorSpaceMapper.createInstance(blkImgDataSrc, colorSpace);
        }
        if (cSEnum == ColorSpace.GreyScale) {
            return EnumeratedColorSpaceMapper.createInstance(blkImgDataSrc, colorSpace);
        }
        if (cSEnum == ColorSpace.sYCC) {
            return SYccColorSpaceMapper.createInstance(blkImgDataSrc, colorSpace);
        }
        if (cSEnum == ColorSpace.Unknown) {
            return null;
        }
        throw new ColorSpaceException("Bad color space specification in image");
    }

    protected ColorSpaceMapper(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.csMap = colorSpace;
        this.initialize();
    }

    private void initialize() throws ColorSpaceException {
        this.pl = this.csMap.pl;
        this.ncomps = this.src.getNumComps();
        this.shiftValueArray = new int[this.ncomps];
        this.maxValueArray = new int[this.ncomps];
        this.fixedPtBitsArray = new int[this.ncomps];
        this.srcBlk = new DataBlk[this.ncomps];
        this.inInt = new DataBlkInt[this.ncomps];
        this.inFloat = new DataBlkFloat[this.ncomps];
        this.workInt = new DataBlkInt[this.ncomps];
        this.workFloat = new DataBlkFloat[this.ncomps];
        this.dataInt = new int[this.ncomps][];
        this.dataFloat = new float[this.ncomps][];
        this.workDataInt = new int[this.ncomps][];
        this.workDataFloat = new float[this.ncomps][];
        this.dataInt = new int[this.ncomps][];
        this.dataFloat = new float[this.ncomps][];
        for (int i = 0; i < this.ncomps; ++i) {
            this.shiftValueArray[i] = 1 << this.src.getNomRangeBits(i) - 1;
            this.maxValueArray[i] = (1 << this.src.getNomRangeBits(i)) - 1;
            this.fixedPtBitsArray[i] = this.src.getFixedPoint(i);
            this.inInt[i] = new DataBlkInt();
            this.inFloat[i] = new DataBlkFloat();
            this.workInt[i] = new DataBlkInt();
            this.workInt[i].progressive = this.inInt[i].progressive;
            this.workFloat[i] = new DataBlkFloat();
            this.workFloat[i].progressive = this.inFloat[i].progressive;
        }
    }

    @Override
    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.src.getCompData(dataBlk, n);
    }

    @Override
    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.src.getInternCompData(dataBlk, n);
    }

    protected class ComputedComponents {
        private int tIdx = -1;
        private int h = -1;
        private int w = -1;
        private int ulx = -1;
        private int uly = -1;
        private int offset = -1;
        private int scanw = -1;

        public ComputedComponents() {
            this.clear();
        }

        public ComputedComponents(DataBlk dataBlk) {
            this.set(dataBlk);
        }

        public void set(DataBlk dataBlk) {
            this.h = dataBlk.h;
            this.w = dataBlk.w;
            this.ulx = dataBlk.ulx;
            this.uly = dataBlk.uly;
            this.offset = dataBlk.offset;
            this.scanw = dataBlk.scanw;
        }

        public void clear() {
            this.scanw = -1;
            this.offset = -1;
            this.uly = -1;
            this.ulx = -1;
            this.w = -1;
            this.h = -1;
        }

        public boolean equals(ComputedComponents computedComponents) {
            return this.h == computedComponents.h && this.w == computedComponents.w && this.ulx == computedComponents.ulx && this.uly == computedComponents.uly && this.offset == computedComponents.offset && this.scanw == computedComponents.scanw;
        }
    }
}

