/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpaceException;
import colorspace.boxes.ChannelDefinitionBox;
import colorspace.boxes.ColorSpecificationBox;
import colorspace.boxes.ComponentMappingBox;
import colorspace.boxes.ImageHeaderBox;
import colorspace.boxes.PaletteBox;
import icc.ICCProfile;
import java.io.IOException;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.ParameterList;

public class ColorSpace {
    public static final String eol = System.getProperty("line.separator");
    static final int GRAY = 0;
    static final int RED = 1;
    static final int GREEN = 2;
    static final int BLUE = 3;
    public ParameterList pl;
    public HeaderDecoder hd;
    private PaletteBox pbox = null;
    private ComponentMappingBox cmbox = null;
    private ColorSpecificationBox csbox = null;
    private ChannelDefinitionBox cdbox = null;
    private ImageHeaderBox ihbox = null;
    private RandomAccessIO in = null;
    public static final MethodEnum ICC_PROFILED = new MethodEnum("profiled");
    public static final MethodEnum ENUMERATED = new MethodEnum("enumerated");
    public static final CSEnum sRGB = new CSEnum("sRGB");
    public static final CSEnum GreyScale = new CSEnum("GreyScale");
    public static final CSEnum sYCC = new CSEnum("sYCC");
    public static final CSEnum Illegal = new CSEnum("Illegal");
    public static final CSEnum Unknown = new CSEnum("Unknown");

    public byte[] getICCProfile() {
        return this.csbox.getICCProfile();
    }

    public static String indent(String string, StringBuffer stringBuffer) {
        return ColorSpace.indent(string, stringBuffer.toString());
    }

    public static String indent(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        char c = eol.charAt(0);
        int n = stringBuffer.length();
        while (--n > 0) {
            if (stringBuffer.charAt(n) != c) continue;
            stringBuffer.insert(n + 1, string);
        }
        return string + stringBuffer.toString();
    }

    public ColorSpace(RandomAccessIO randomAccessIO, HeaderDecoder headerDecoder, ParameterList parameterList) throws IOException, ColorSpaceException {
        this.pl = parameterList;
        this.in = randomAccessIO;
        this.hd = headerDecoder;
        this.getBoxes();
    }

    protected final void getBoxes() throws ColorSpaceException, IOException {
        int n;
        long l = 0L;
        int n2 = 0;
        byte[] byArray = new byte[16];
        int n3 = 0;
        while (true) {
            this.in.seek(n2);
            this.in.readFully(byArray, 0, 16);
            l = ICCProfile.getInt(byArray, 0);
            if (l == 1L) {
                l = ICCProfile.getLong(byArray, 8);
            }
            n = ICCProfile.getInt(byArray, 4);
            if (n3 == 0 && n != 1783636000) {
                throw new ColorSpaceException("first box in image not signature");
            }
            if (n3 == 1 && n != 1718909296) {
                throw new ColorSpaceException("second box in image not file");
            }
            if (n == 1785737827) {
                throw new ColorSpaceException("header box not found in image");
            }
            if (n == 1785737832) break;
            ++n3;
            n2 = (int)((long)n2 + l);
        }
        long l2 = (long)n2 + l;
        if (l == 1L) {
            n2 += 8;
        }
        n2 += 8;
        while ((long)n2 < l2) {
            this.in.seek(n2);
            this.in.readFully(byArray, 0, 16);
            l = ICCProfile.getInt(byArray, 0);
            if (l == 1L) {
                throw new ColorSpaceException("Extended length boxes not supported");
            }
            n = ICCProfile.getInt(byArray, 4);
            switch (n) {
                case 1768449138: {
                    this.ihbox = new ImageHeaderBox(this.in, n2);
                    break;
                }
                case 1668246642: {
                    this.csbox = new ColorSpecificationBox(this.in, n2);
                    break;
                }
                case 1667523942: {
                    this.cdbox = new ChannelDefinitionBox(this.in, n2);
                    break;
                }
                case 1668112752: {
                    this.cmbox = new ComponentMappingBox(this.in, n2);
                    break;
                }
                case 1885564018: {
                    this.pbox = new PaletteBox(this.in, n2);
                    break;
                }
            }
            n2 = (int)((long)n2 + l);
        }
        if (this.ihbox == null) {
            throw new ColorSpaceException("image header box not found");
        }
        if (this.pbox == null && this.cmbox != null || this.pbox != null && this.cmbox == null) {
            throw new ColorSpaceException("palette box and component mapping box inconsistency");
        }
    }

    public int getChannelDefinition(int n) {
        if (this.cdbox == null) {
            return n;
        }
        return this.cdbox.getCn(n + 1);
    }

    public MethodEnum getMethod() {
        return this.csbox.getMethod();
    }

    public CSEnum getColorSpace() {
        return this.csbox.getColorSpace();
    }

    public PaletteBox getPaletteBox() {
        return this.pbox;
    }

    public int getPaletteChannels() {
        return this.pbox == null ? 0 : this.pbox.getNumColumns();
    }

    public int getPaletteChannelBits(int n) {
        return this.pbox == null ? 0 : (int)this.pbox.getBitDepth(n);
    }

    public int getPalettizedSample(int n, int n2) {
        return this.pbox == null ? 0 : this.pbox.getEntry(n, n2);
    }

    public boolean isPalettized() {
        return this.pbox != null;
    }

    public boolean isOutputSigned(int n) {
        return this.pbox != null ? this.pbox.isSigned(n) : this.hd.isOriginalSigned(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ColorSpace is ").append(this.csbox.getMethodString()).append(this.isPalettized() ? "  and palettized " : " ").append(this.getMethod() == ENUMERATED ? this.csbox.getColorSpaceString() : "");
        if (this.ihbox != null) {
            stringBuffer.append(eol).append(ColorSpace.indent("    ", this.ihbox.toString()));
        }
        if (this.cdbox != null) {
            stringBuffer.append(eol).append(ColorSpace.indent("    ", this.cdbox.toString()));
        }
        if (this.csbox != null) {
            stringBuffer.append(eol).append(ColorSpace.indent("    ", this.csbox.toString()));
        }
        if (this.pbox != null) {
            stringBuffer.append(eol).append(ColorSpace.indent("    ", this.pbox.toString()));
        }
        if (this.cmbox != null) {
            stringBuffer.append(eol).append(ColorSpace.indent("    ", this.cmbox.toString()));
        }
        return stringBuffer.append("]").toString();
    }

    public boolean debugging() {
        return this.pl.getProperty("colorspace_debug") != null && this.pl.getProperty("colorspace_debug").equalsIgnoreCase("on");
    }

    public static class CSEnum
    extends Enumeration {
        public CSEnum(String string) {
            super(string);
        }
    }

    public static class MethodEnum
    extends Enumeration {
        public MethodEnum(String string) {
            super(string);
        }
    }

    public static class Enumeration {
        public final String value;

        public Enumeration(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

